/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.rpc.CallHelper;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AccountCall {
    public static String createContractAddress(int chainId) throws NulsException {
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(4);
            params.put("chainId", chainId);
            Map resultMap = (Map)CallHelper.request(ModuleE.AC.abbr, "ac_createContractAccount", params);
            return (String)resultMap.get("address");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Result validationPassword(int chainId, String address, String passwd) {
        try {
            if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)passwd)) {
                return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("address", address);
            params.put("password", passwd);
            Map resultMap = (Map)CallHelper.request(ModuleE.AC.abbr, "ac_validationPassword", params);
            boolean validate = (Boolean)resultMap.get("value");
            if (validate) {
                return ContractUtil.getSuccess();
            }
            return Result.getFailed((ErrorCode)ContractErrorCode.PASSWORD_IS_WRONG);
        }
        catch (Exception e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)ContractErrorCode.ACCOUNT_NOT_EXIST);
        }
    }

    public static boolean validationWhitelistForTransferOnContractCall(int chainId, String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                return false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("address", address);
            Map resultMap = (Map)CallHelper.request(ModuleE.AC.abbr, "ac_validationWhitelistForTransferOnContractCall", params);
            boolean validate = (Boolean)resultMap.get("value");
            return validate;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public static void transactionSignature(int chainId, String address, String password, Transaction tx) throws NulsException {
        try {
            P2PHKSignature p2PHKSignature = new P2PHKSignature();
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chainId);
            callParams.put("address", address);
            callParams.put("password", password);
            callParams.put("data", RPCUtil.encode((byte[])tx.getHash().getBytes()));
            Response signResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_signDigest", callParams);
            if (!signResp.isSuccess()) {
                throw new NulsException(ContractErrorCode.SIGNATURE_ERROR);
            }
            HashMap signResult = (HashMap)((HashMap)signResp.getResponseData()).get("ac_signDigest");
            p2PHKSignature.parse(RPCUtil.decode((String)((String)signResult.get("signature"))), 0);
            TransactionSignature signature = new TransactionSignature();
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            p2PHKSignatures.add(p2PHKSignature);
            signature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(signature.serialize());
        }
        catch (NulsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

