/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.contract.rpc.CallHelper;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import java.util.HashMap;
import java.util.Map;

public class BlockCall {
    public static long getLatestHeight(int chainId) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            Map resultMap = (Map)CallHelper.request(ModuleE.BL.abbr, "latestHeight", params);
            return Long.parseLong(resultMap.get("value").toString());
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static BlockHeader getLatestBlockHeader(int chainId) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            Map resultMap = (Map)CallHelper.request(ModuleE.BL.abbr, "latestBlockHeader", params);
            BlockHeader header = new BlockHeader();
            header.parse(RPCUtil.decode((String)((String)resultMap.get("value"))), 0);
            return header;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static BlockHeader getBlockHeader(int chainId, long height) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("height", height);
            Map resultMap = (Map)CallHelper.request(ModuleE.BL.abbr, "getBlockHeaderByHeight", params);
            BlockHeader header = new BlockHeader();
            header.parse(RPCUtil.decode((String)((String)resultMap.get("value"))), 0);
            return header;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static BlockHeader getBlockHeader(int chainId, String hash) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("hash", hash);
            Map resultMap = (Map)CallHelper.request(ModuleE.BL.abbr, "getBlockHeaderByHash", params);
            BlockHeader header = new BlockHeader();
            header.parse(RPCUtil.decode((String)((String)resultMap.get("value"))), 0);
            return header;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

