/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.contract.rpc.CallHelper;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionCall {
    public static boolean newTx(int chainId, String txData) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("tx", txData);
        try {
            Map registerResult = (Map)CallHelper.request(ModuleE.TX.abbr, "tx_newTx", params);
            return (Boolean)registerResult.get("value");
        }
        catch (Exception e) {
            if (e instanceof NulsException) {
                throw (NulsException)((Object)e);
            }
            throw new NulsException((Throwable)e);
        }
    }

    public static Transaction getConfirmedTx(int chainId, String txHash) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("txHash", txHash);
        try {
            Map result = (Map)CallHelper.request(ModuleE.TX.abbr, "tx_getConfirmedTx", params);
            String txData = (String)result.get("tx");
            if (StringUtils.isBlank((String)txData)) {
                return null;
            }
            Transaction tx = new Transaction();
            tx.parse(RPCUtil.decode((String)txData), 0);
            return tx;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map getTxList(int chainId, List<String> txHashList) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("txHashList", txHashList);
        try {
            return (Map)CallHelper.request(ModuleE.TX.abbr, "tx_getBlockTxs", params);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static boolean baseValidateTx(int chainId, String txData) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("tx", txData);
        try {
            Map baseValidateResult = (Map)CallHelper.request(ModuleE.TX.abbr, "tx_baseValidateTx", params);
            return (Boolean)baseValidateResult.get("value");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static boolean setContractGenerateTxTypes(int chainId, List<Integer> txTypeList) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("txTypeList", txTypeList);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_setContractGenerateTxTypes", params);
            return cmdResp.isSuccess();
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

