/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.cmd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.enums.BlockType;
import io.nuls.contract.enums.CmdRegisterMode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.CmdRegisterManager;
import io.nuls.contract.manager.ContractTxProcessorManager;
import io.nuls.contract.manager.ContractTxValidatorManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.ContractTempTransaction;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.model.dto.ModuleCmdRegisterDto;
import io.nuls.contract.model.po.ContractOfflineTxHashPo;
import io.nuls.contract.rpc.call.TransactionCall;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.MapUtil;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramInternalCall;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.ProgramTransfer;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.SC)
public class ContractCmd
extends BaseCmd {
    @Autowired
    private ContractService contractService;
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractTxProcessorManager contractTxProcessorManager;
    @Autowired
    private ContractTxValidatorManager contractTxValidatorManager;
    @Autowired
    private CmdRegisterManager cmdRegisterManager;
    @Autowired
    private NulsCoresConfig contractConfig;

    @CmdAnnotation(cmd="sc_batch_begin", version=1.0, description="Execute the start notification for a batch of contracts, generate information for the current batch/batch begin")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockType", parameterType="int", parameterDes="Block processing mode, Packaging blocks - 0, Verify Block - 1"), @Parameter(parameterName="blockHeight", parameterType="long", parameterDes="The height of the currently packaged blocks"), @Parameter(parameterName="blockTime", parameterType="long", parameterDes="The current packaged block time"), @Parameter(parameterName="packingAddress", parameterType="String", parameterDes="The current block packaging address"), @Parameter(parameterName="preStateRoot", parameterType="String", parameterDes="PreviousstateRoot")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response batchBegin(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Integer blockType = (Integer)params.get("blockType");
            ChainManager.chainHandle(chainId, blockType);
            Long blockHeight = Long.parseLong(params.get("blockHeight").toString());
            Long blockTime = Long.parseLong(params.get("blockTime").toString());
            String packingAddress = (String)params.get("packingAddress");
            String preStateRoot = (String)params.get("preStateRoot");
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                Result result = this.contractService.beginV8(chainId, blockHeight, blockTime, packingAddress, preStateRoot);
                return this.success(result.getData());
            }
            this.contractService.begin(chainId, blockHeight, blockTime, packingAddress, preStateRoot);
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_invoke_contract", version=1.0, description="After the batch notification starts, execute the contract one by one/invoke contract one by one")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockType", parameterType="int", parameterDes="Block processing mode, Packaging blocks - 0, Verify Block - 1"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Serialized transactionHEXEncoding string")})
    @ResponseData(description="No specific return value, successful without errors. If an error is returned, the transaction will be discarded")
    public Response invokeContractOneByOne(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Integer blockType = (Integer)params.get("blockType");
            ChainManager.chainHandle(chainId, blockType);
            String txData = (String)params.get("tx");
            ContractTempTransaction tx = new ContractTempTransaction();
            tx.setTxHex(txData);
            tx.parse(RPCUtil.decode((String)txData), 0);
            String hash = tx.getHash().toHex();
            HashMap<String, Boolean> dealResult = new HashMap<String, Boolean>(2);
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_22) {
                Result result = this.contractService.invokeContractOneByOneV22(chainId, tx);
                if (result.isFailed()) {
                    return ContractUtil.wrapperFailed(result);
                }
                if (result.getData() == null) {
                    HashMap<String, Object> resultData = new HashMap<String, Object>();
                    resultData.put("success", true);
                    resultData.put("gasUsed", 0);
                    resultData.put("txList", List.of());
                    return this.success(resultData);
                }
                return this.success(result.getData());
            }
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_14) {
                Result result = this.contractService.invokeContractOneByOneV14(chainId, tx);
                if (result.isFailed()) {
                    return ContractUtil.wrapperFailed(result);
                }
                if (result.getData() == null) {
                    HashMap<String, Object> resultData = new HashMap<String, Object>();
                    resultData.put("success", true);
                    resultData.put("gasUsed", 0);
                    resultData.put("txList", List.of());
                    return this.success(resultData);
                }
                return this.success(result.getData());
            }
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                Result result = this.contractService.invokeContractOneByOneV8(chainId, tx);
                if (result.isFailed()) {
                    return ContractUtil.wrapperFailed(result);
                }
                if (result.getData() == null) {
                    HashMap<String, Object> resultData = new HashMap<String, Object>();
                    resultData.put("success", true);
                    resultData.put("gasUsed", 0);
                    resultData.put("txList", List.of());
                    return this.success(resultData);
                }
                return this.success(result.getData());
            }
            if (!this.contractHelper.getChain(chainId).getBatchInfo().checkGasCostTotal(hash)) {
                Log.warn("Exceed tx count [600] or gas limit of block [13,000,000 gas], the contract transaction [{}] revert to package queue.", hash);
                dealResult.put("value", false);
                return this.success(dealResult);
            }
            Result result = this.contractService.invokeContractOneByOne(chainId, tx);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            dealResult.put("value", true);
            return this.success(dealResult);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_batch_before_end", version=1.0, description="After the transaction module has packaged the transaction, before conducting unified verification, notify the contract module to stop receiving transactions and start asynchronous processing of the results of this batch/batch before end")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockType", parameterType="int", parameterDes="Block processing mode, Packaging blocks - 0, Verify Block - 1"), @Parameter(parameterName="blockHeight", parameterType="long", parameterDes="The height of the currently packaged blocks")})
    @ResponseData(description="No specific return value, success is achieved without errors. If an error is returned, the batch is discarded, and all executed contract transactions within the batch are returned to the queue for packaging transactions")
    public Response batchBeforeEnd(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            Integer blockType = (Integer)params.get("blockType");
            ChainManager.chainHandle(chainId, blockType);
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                return this.success();
            }
            Long blockHeight = Long.parseLong(params.get("blockHeight").toString());
            Result result = this.contractService.beforeEnd(chainId, blockHeight);
            Log.info("[Before End Result] contract batch, result is {}", result.toString());
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_batch_end", version=1.0, description="Notify the end of the current batch and return the result/batch end")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockHeight", parameterType="long", parameterDes="The height of the currently packaged blocks")})
    @ResponseData(name="Return value", description="Return aMapObject, containing twokey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="stateRoot", description="currentstateRoot"), @Key(name="txList", valueType=List.class, valueElement=String.class, description="List of newly generated transaction serialization strings for contracts(There may be a contract transfer\u3001Contract consensus\u3001Contract returnGAS), version8Only return the contract and aboveGAStransaction")}))
    public Response batchEnd(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId, BlockType.VERIFY_BLOCK.type());
            Long blockHeight = Long.parseLong(params.get("blockHeight").toString());
            Log.info("[End Contract Batch] contract batch request start, height is {}", blockHeight);
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                Result result = this.contractService.endV8(chainId, blockHeight);
                if (result.isFailed()) {
                    return ContractUtil.wrapperFailed(result);
                }
                return this.success(result.getData());
            }
            Result result = this.contractService.end(chainId, blockHeight);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            BatchInfo batchInfo = this.contractHelper.getChain(chainId).getBatchInfo();
            List<String> pendingTxHashList = batchInfo.getPendingTxHashList();
            ContractPackageDto dto = (ContractPackageDto)result.getData();
            List<String> resultTxDataList = dto.getResultTxList();
            HashMap resultMap = MapUtil.createHashMap(2);
            resultMap.put("stateRoot", RPCUtil.encode((byte[])dto.getStateRoot()));
            resultMap.put("txList", resultTxDataList);
            resultMap.put("originTxList", dto.getResultOrginTxList());
            resultMap.put("pendingTxHashList", pendingTxHashList);
            Log.info("[End Contract Batch] Gas total cost is [{}], packaging blockHeight is [{}], packaging StateRoot is [{}]", batchInfo.getGasCostTotal(), blockHeight, RPCUtil.encode((byte[])dto.getStateRoot()));
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_package_batch_end", version=1.0, description="Packaging completed - Notify the end of the current batch and return the result/batch end")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockHeight", parameterType="long", parameterDes="The height of the currently packaged blocks")})
    @ResponseData(name="Return value", description="Return aMapObject, containing twokey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="stateRoot", description="currentstateRoot"), @Key(name="txList", valueType=List.class, valueElement=String.class, description="List of newly generated transaction serialization strings for contracts(There may be a contract transfer\u3001Contract consensus\u3001Contract returnGAS), version8Only return the contract and aboveGAStransaction")}))
    public Response packageBatchEnd(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId, BlockType.PACKAGE_BLOCK.type());
            Long blockHeight = Long.parseLong(params.get("blockHeight").toString());
            Log.info("[End Package Contract Batch] contract batch request start, height is {}", blockHeight);
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                Result result = this.contractService.packageEndV8(chainId, blockHeight);
                if (result.isFailed()) {
                    return ContractUtil.wrapperFailed(result);
                }
                Log.info("[End Package Contract Batch] packaging blockHeight is [{}], packaging StateRoot is [{}]", blockHeight, ((Map)result.getData()).get("stateRoot"));
                return this.success(result.getData());
            }
            Result result = this.contractService.packageEnd(chainId, blockHeight);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            BatchInfo batchInfo = this.contractHelper.getChain(chainId).getBatchInfo();
            List<String> pendingTxHashList = batchInfo.getPendingTxHashList();
            ContractPackageDto dto = (ContractPackageDto)result.getData();
            List<String> resultTxDataList = dto.getResultTxList();
            HashMap resultMap = MapUtil.createHashMap(2);
            resultMap.put("stateRoot", RPCUtil.encode((byte[])dto.getStateRoot()));
            resultMap.put("txList", resultTxDataList);
            resultMap.put("originTxList", dto.getResultOrginTxList());
            resultMap.put("pendingTxHashList", pendingTxHashList);
            Log.info("[End Package Contract Batch] Gas total cost is [{}], packaging blockHeight is [{}], packaging StateRoot is [{}]", batchInfo.getGasCostTotal(), blockHeight, RPCUtil.encode((byte[])dto.getStateRoot()));
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_offline_tx_hash_list", version=1.0, description="Return the contract generated transaction in the specified block\uff08Contract returnGASExcluding transactions\uff09ofhashlist\uff08Newly generated transactions in the contract except for contract returnsGASExcept for transactions, they are not saved to the block. The contract module saves the relationship between these transactions and the specified block\uff09/contract offline tx hash list")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockHash", parameterType="String", parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return aMapObject, containing twokey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=String.class, description="Contract transaction serialization string list(There may be a contract transfer\u3001Contract consensus)")}))
    public Response contractOfflineTxHashList(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String blockHash = (String)params.get("blockHash");
            Result<ContractOfflineTxHashPo> result = this.contractService.getContractOfflineTxHashList(chainId, blockHash);
            if (result.isFailed()) {
                if (result.getErrorCode().equals((Object)ContractErrorCode.DATA_NOT_FOUND)) {
                    HashMap resultMap = new HashMap(2);
                    resultMap.put("list", Collections.emptyList());
                    return this.success(resultMap);
                }
                return ContractUtil.wrapperFailed(result);
            }
            HashMap resultMap = new HashMap(2);
            List<byte[]> hashList = ((ContractOfflineTxHashPo)((Object)result.getData())).getHashList();
            ArrayList<String> resultList = new ArrayList<String>(hashList.size());
            for (byte[] hash : hashList) {
                resultList.add(RPCUtil.encode((byte[])hash));
            }
            resultMap.put("list", resultList);
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_offline_tx_list", version=1.0, description="Return the contract generated transaction in the specified block\uff08Contract returnGASExcluding transactions\uff09List of\uff08Newly generated transactions in the contract except for contract returnsGASExcept for transactions, they are not saved to the block. The contract module saves the relationship between these transactions and the specified block\uff09/contract offline tx hash list")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="blockHash", parameterType="String", parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txList", valueType=List.class, valueElement=String.class, description="Returns a collection of transaction serialization data strings")}))
    public Response contractOfflineTxList(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String blockHash = (String)params.get("blockHash");
            Result<ContractOfflineTxHashPo> result = this.contractService.getContractOfflineTxHashList(chainId, blockHash);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            List<byte[]> hashList = ((ContractOfflineTxHashPo)((Object)result.getData())).getHashList();
            ArrayList<String> resultList = new ArrayList<String>(hashList.size());
            for (byte[] hash : hashList) {
                resultList.add(RPCUtil.encode((byte[])hash));
            }
            return this.success(TransactionCall.getTxList(chainId, resultList));
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_register_cmd_for_contract", version=1.0, description="Other modules register commands that can be called by the contract with the contract module, and after registration, the registered commands can be called within the contract code/register cmd for contract")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="moduleCode", parameterType="String", parameterDes="Module code"), @Parameter(parameterName="cmdRegisterList", parameterType="List", parameterDes="Registration Information List")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response registerCmdForContract(Map<String, Object> params) {
        try {
            String errorMsg = CommonCodeConstanst.PARAMETER_ERROR.getMsg();
            Integer chainId = (Integer)params.get("chainId");
            ObjectUtils.canNotEmpty((Object)chainId, (String)errorMsg);
            ChainManager.chainHandle(chainId);
            String moduleCode = (String)params.get("moduleCode");
            ObjectUtils.canNotEmpty((Object)moduleCode, (String)errorMsg);
            List cmdRegisterList = (List)params.get("cmdRegisterList");
            ObjectUtils.canNotEmpty((Object)cmdRegisterList, (String)errorMsg);
            JSONUtils.getInstance().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ModuleCmdRegisterDto moduleCmdRegisterDto = (ModuleCmdRegisterDto)JSONUtils.map2pojo(params, ModuleCmdRegisterDto.class);
            Result result = this.cmdRegisterManager.registerCmd(moduleCmdRegisterDto);
            if (result.isFailed()) {
                return this.failed(result.getErrorCode());
            }
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_trigger_payable_for_consensus_contract", version=1.0, description="When the consensus reward return address is the contract address, it will trigger the contract_payable(String[][] args)Method, parameter is node revenue address details<br>args[0] = new String[]{address, amount}<br>...<br>/trigger payable for consensus contract")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainid"), @Parameter(parameterName="stateRoot", parameterType="String", parameterDes="CurrentstateRoot"), @Parameter(parameterName="blockHeight", parameterType="Long", parameterDes="The current latest block height"), @Parameter(parameterName="contractAddress", parameterType="String", parameterDes="Contract address"), @Parameter(parameterName="tx", parameterType="String", parameterDes="The current packaging block contains CoinBase Transaction serialization string")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="After changes stateRoot")}))
    public Response triggerPayableForConsensusContract(Map<String, Object> params) {
        Integer chainId = (Integer)params.get("chainId");
        ObjectUtils.canNotEmpty((Object)chainId, (String)CommonCodeConstanst.PARAMETER_ERROR.getMsg());
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_21) {
            return this._triggerPayableForConsensusContractAfterP21(params);
        }
        return this._triggerPayableForConsensusContract(params);
    }

    private Response _triggerPayableForConsensusContractAfterP21(Map<String, Object> params) {
        try {
            Result result;
            String contractAddress;
            boolean hasAgentContract;
            String errorMsg = CommonCodeConstanst.PARAMETER_ERROR.getMsg();
            Integer chainId = (Integer)params.get("chainId");
            ObjectUtils.canNotEmpty((Object)chainId, (String)errorMsg);
            ChainManager.chainHandle(chainId);
            String stateRoot = (String)params.get("stateRoot");
            Long blockHeight = Long.parseLong(params.get("blockHeight").toString());
            Long packageHeight = blockHeight + 1L;
            if (Log.isDebugEnabled()) {
                Log.debug("contract trigger payable for consensus rewarding, blockHeight is {}, preStateRoot is {}", packageHeight, stateRoot);
            }
            if ((hasAgentContract = StringUtils.isNotBlank((String)(contractAddress = (String)params.get("contractAddress")))) && !AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            String txString = (String)params.get("tx");
            Transaction tx = new Transaction();
            tx.parse(RPCUtil.decode((String)txString), 0);
            if (1 != tx.getType()) {
                return this.failed(CommonCodeConstanst.PARAMETER_ERROR);
            }
            CoinData coinData = tx.getCoinDataInstance();
            List toList = coinData.getTo();
            int toListSize = toList.size();
            if (toListSize == 0) {
                HashMap<String, String> rpcResult = new HashMap<String, String>(2);
                rpcResult.put("value", stateRoot);
                return this.success(rpcResult);
            }
            byte[] stateRootBytes = RPCUtil.decode((String)stateRoot);
            ProgramExecutor programExecutor = this.contractHelper.getProgramExecutor(chainId);
            ProgramExecutor batchExecutor = programExecutor.begin(stateRootBytes);
            BigInteger agentValue = BigInteger.ZERO;
            byte[] contractAddressBytes = null;
            if (hasAgentContract) {
                contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            }
            ArrayList<String[]> agentArgList = new ArrayList<String[]>();
            String[][] depositArgs = new String[1][];
            ArrayList<CoinTo> assetRewardList = new ArrayList<CoinTo>();
            for (CoinTo to : toList) {
                byte[] address = to.getAddress();
                BigInteger value = to.getAmount();
                if (value.compareTo(BigInteger.ZERO) < 0) {
                    Log.error("address [{}] - error amount [{}]", AddressTool.getStringAddressByBytes((byte[])address), value.toString());
                    return this.failed(CommonCodeConstanst.PARAMETER_ERROR);
                }
                if (to.getAssetsChainId() != ContractContext.LOCAL_CHAIN_ID || to.getAssetsId() != ContractContext.LOCAL_MAIN_ASSET_ID) {
                    if (!AddressTool.validContractAddress((byte[])address, (int)chainId)) continue;
                    assetRewardList.add(to);
                    continue;
                }
                if (hasAgentContract && Arrays.equals(address, contractAddressBytes)) {
                    agentValue = to.getAmount();
                    assetRewardList.add(to);
                    continue;
                }
                String[] element = new String[]{AddressTool.getStringAddressByBytes((byte[])address), value.toString()};
                if (AddressTool.validContractAddress((byte[])address, (int)chainId)) {
                    assetRewardList.add(to);
                    depositArgs[0] = element;
                    result = this.callDepositContract(chainId, address, value, blockHeight, depositArgs, batchExecutor, stateRootBytes);
                    if (result.isFailed()) {
                        Log.error("deposit contract address [{}] trigger payable error [{}], blockHeight is {}", AddressTool.getStringAddressByBytes((byte[])address), this.extractMsg(result), packageHeight);
                    }
                }
                agentArgList.add(element);
            }
            if (hasAgentContract) {
                agentArgList.add(0, new String[]{contractAddress, agentValue.toString()});
                String[][] agentArgs = new String[agentArgList.size()][];
                agentArgList.toArray((T[])agentArgs);
                result = this.callAgentContract(chainId, contractAddressBytes, agentValue, blockHeight, agentArgs, batchExecutor, stateRootBytes);
                if (result.isFailed()) {
                    Log.error("agent contract address [{}] trigger payable error [{}], blockHeight is {}", AddressTool.getStringAddressByBytes((byte[])contractAddressBytes), this.extractMsg(result), packageHeight);
                }
            }
            this.contractHelper.saveContractRewardLogByConsensus(chainId, assetRewardList);
            batchExecutor.commit();
            byte[] newStateRootBytes = batchExecutor.getRoot();
            if (Log.isDebugEnabled()) {
                Log.debug("contract trigger payable for consensus rewarding, blockHeight is {}, preStateRoot is {}, currentStateRoot is {}", packageHeight, stateRoot, HexUtil.encode((byte[])newStateRootBytes));
            }
            HashMap<String, String> rpcResult = new HashMap<String, String>(2);
            rpcResult.put("value", RPCUtil.encode((byte[])newStateRootBytes));
            return this.success(rpcResult);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    private Response _triggerPayableForConsensusContract(Map<String, Object> params) {
        try {
            Result result;
            String contractAddress;
            boolean hasAgentContract;
            String errorMsg = CommonCodeConstanst.PARAMETER_ERROR.getMsg();
            Integer chainId = (Integer)params.get("chainId");
            ObjectUtils.canNotEmpty((Object)chainId, (String)errorMsg);
            ChainManager.chainHandle(chainId);
            String stateRoot = (String)params.get("stateRoot");
            Long blockHeight = Long.parseLong(params.get("blockHeight").toString());
            Long packageHeight = blockHeight + 1L;
            if (Log.isDebugEnabled()) {
                Log.debug("contract trigger payable for consensus rewarding, blockHeight is {}, preStateRoot is {}", packageHeight, stateRoot);
            }
            if ((hasAgentContract = StringUtils.isNotBlank((String)(contractAddress = (String)params.get("contractAddress")))) && !AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            String txString = (String)params.get("tx");
            Transaction tx = new Transaction();
            tx.parse(RPCUtil.decode((String)txString), 0);
            if (1 != tx.getType()) {
                return this.failed(CommonCodeConstanst.PARAMETER_ERROR);
            }
            CoinData coinData = tx.getCoinDataInstance();
            List toList = coinData.getTo();
            int toListSize = toList.size();
            if (toListSize == 0) {
                HashMap<String, String> rpcResult = new HashMap<String, String>(2);
                rpcResult.put("value", stateRoot);
                return this.success(rpcResult);
            }
            byte[] stateRootBytes = RPCUtil.decode((String)stateRoot);
            ProgramExecutor programExecutor = this.contractHelper.getProgramExecutor(chainId);
            ProgramExecutor batchExecutor = programExecutor.begin(stateRootBytes);
            BigInteger agentValue = BigInteger.ZERO;
            byte[] contractAddressBytes = null;
            if (hasAgentContract) {
                contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            }
            String[][] agentArgs = new String[toListSize][];
            String[][] depositArgs = new String[1][];
            int i = 0;
            if (hasAgentContract) {
                ++i;
            }
            for (CoinTo to : toList) {
                byte[] address = to.getAddress();
                BigInteger value = to.getAmount();
                if (value.compareTo(BigInteger.ZERO) < 0) {
                    Log.error("address [{}] - error amount [{}]", AddressTool.getStringAddressByBytes((byte[])address), value.toString());
                    return this.failed(CommonCodeConstanst.PARAMETER_ERROR);
                }
                if (hasAgentContract && Arrays.equals(address, contractAddressBytes)) {
                    agentValue = to.getAmount();
                    continue;
                }
                String[] element = new String[]{AddressTool.getStringAddressByBytes((byte[])address), value.toString()};
                if (AddressTool.validContractAddress((byte[])address, (int)chainId)) {
                    depositArgs[0] = element;
                    result = this.callDepositContract(chainId, address, value, blockHeight, depositArgs, batchExecutor, stateRootBytes);
                    if (result.isFailed()) {
                        Log.error("deposit contract address [{}] trigger payable error [{}], blockHeight is {}", AddressTool.getStringAddressByBytes((byte[])address), this.extractMsg(result), packageHeight);
                    }
                }
                agentArgs[i++] = element;
            }
            if (hasAgentContract) {
                agentArgs[0] = new String[]{contractAddress, agentValue.toString()};
                result = this.callAgentContract(chainId, contractAddressBytes, agentValue, blockHeight, agentArgs, batchExecutor, stateRootBytes);
                if (result.isFailed()) {
                    Log.error("agent contract address [{}] trigger payable error [{}], blockHeight is {}", AddressTool.getStringAddressByBytes((byte[])contractAddressBytes), this.extractMsg(result), packageHeight);
                }
            }
            batchExecutor.commit();
            byte[] newStateRootBytes = batchExecutor.getRoot();
            if (Log.isDebugEnabled()) {
                Log.debug("contract trigger payable for consensus rewarding, blockHeight is {}, preStateRoot is {}, currentStateRoot is {}", packageHeight, stateRoot, HexUtil.encode((byte[])newStateRootBytes));
            }
            HashMap<String, String> rpcResult = new HashMap<String, String>(2);
            rpcResult.put("value", RPCUtil.encode((byte[])newStateRootBytes));
            return this.success(rpcResult);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_get_cross_token_system_contract", version=1.0, description="get cross token system contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Token Cross Chain System Contract Address")}))
    public Response getCrossTokenSystemContract(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("value", this.contractConfig.getCrossTokenSystemContract());
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    private String extractMsg(Result result) {
        if (result == null) {
            return "";
        }
        String msg = result.getMsg();
        return msg != null ? msg : result.getErrorCode().getMsg();
    }

    private Result callAgentContract(int chainId, byte[] contractAddressBytes, BigInteger value, Long blockHeight, String[][] args, ProgramExecutor batchExecutor, byte[] stateRootBytes) {
        if (Log.isDebugEnabled()) {
            Log.debug("agent contract trigger payable for consensus rewarding, blockHeight is {}, contractAddress is {}, reward detail is {}", blockHeight + 1L, AddressTool.getStringAddressByBytes((byte[])contractAddressBytes), ContractUtil.toString(args));
        }
        return this.callConsensusContract(chainId, contractAddressBytes, value, blockHeight, args, batchExecutor, stateRootBytes, true);
    }

    private Result callDepositContract(int chainId, byte[] contractAddressBytes, BigInteger value, Long blockHeight, String[][] args, ProgramExecutor batchExecutor, byte[] stateRootBytes) {
        if (Log.isDebugEnabled()) {
            Log.debug("deposit contract trigger payable for consensus rewarding, blockHeight is {}, contractAddress is {}, reward is {}", blockHeight + 1L, AddressTool.getStringAddressByBytes((byte[])contractAddressBytes), value.toString());
        }
        return this.callConsensusContract(chainId, contractAddressBytes, value, blockHeight, args, batchExecutor, stateRootBytes, false);
    }

    private Result callConsensusContract(int chainId, byte[] contractAddressBytes, BigInteger value, Long blockHeight, String[][] args, ProgramExecutor batchExecutor, byte[] stateRootBytes, boolean isAgentContract) {
        ProgramMethod methodInfo = this.contractHelper.getMethodInfoByContractAddress(chainId, stateRootBytes, "_payable", "(String[][] args) return void", contractAddressBytes);
        if (methodInfo == null) {
            Log.error("chainId: {}, contractAddress: {}, stateRoot: {}", chainId, AddressTool.getStringAddressByBytes((byte[])contractAddressBytes), HexUtil.encode((byte[])stateRootBytes));
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_METHOD_NOT_EXIST);
        }
        if (!methodInfo.isPayable()) {
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_NO_ACCEPT_DIRECT_TRANSFER);
        }
        ProgramCall programCall = new ProgramCall();
        programCall.setContractAddress(contractAddressBytes);
        programCall.setSender(null);
        programCall.setNumber(blockHeight);
        programCall.setValue(value);
        programCall.setPrice(25L);
        if (isAgentContract) {
            programCall.setGasLimit(500000L);
        } else {
            programCall.setGasLimit(100000L);
        }
        programCall.setMethodName("_payable");
        programCall.setMethodDesc("(String[][] args) return void");
        programCall.setArgs(args);
        ProgramExecutor track = batchExecutor.startTracking();
        ProgramResult programResult = track.call(programCall);
        if (!programResult.isSuccess()) {
            Log.error("contractAddress[{}], errorMessage[{}], errorStackTrace[{}]", AddressTool.getStringAddressByBytes((byte[])contractAddressBytes), programResult.getErrorMessage(), programResult.getStackTrace());
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
            result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
            result = ContractUtil.checkVmResultAndReturn(programResult.getErrorMessage(), result);
            return result;
        }
        List<String> events = programResult.getEvents();
        List<ProgramTransfer> transfers = programResult.getTransfers();
        List<ProgramInternalCall> internalCalls = programResult.getInternalCalls();
        List<ProgramInvokeRegisterCmd> invokeRegisterCmds = programResult.getInvokeRegisterCmds();
        int size = events.size() + transfers.size() + internalCalls.size();
        if (size > 0) {
            return Result.getFailed((ErrorCode)ContractErrorCode.TRIGGER_PAYABLE_FOR_CONSENSUS_CONTRACT_ERROR);
        }
        for (ProgramInvokeRegisterCmd registerCmd : invokeRegisterCmds) {
            if (!CmdRegisterMode.NEW_TX.equals((Object)registerCmd.getCmdRegisterMode())) continue;
            return Result.getFailed((ErrorCode)ContractErrorCode.TRIGGER_PAYABLE_FOR_CONSENSUS_CONTRACT_ERROR);
        }
        track.commit();
        return ContractUtil.getSuccess();
    }
}

