/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.ContractTxValidatorManager;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.HashMap;
import java.util.Map;

@Service
@NulsCoresCmd(module=ModuleE.SC)
public class ContractTransactionHandler
extends BaseCmd {
    @Autowired
    private ContractTxValidatorManager contractTxValidatorManager;

    @CmdAnnotation(cmd="sc_create_validator", version=1.0, description="create contract validator")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainID"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Transaction serialization string")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Verified successfully")}))
    public Response createValidator(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String txData = (String)params.get("tx");
            CreateContractTransaction tx = new CreateContractTransaction();
            tx.parse(RPCUtil.decode((String)txData), 0);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
            if (tx.getType() != 15) {
                return this.failed("non create contract tx");
            }
            Result validator = this.contractTxValidatorManager.createValidator(chainId, tx);
            if (validator.isFailed()) {
                return ContractUtil.wrapperFailed(validator);
            }
            result.put("value", true);
            return this.success(result);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_call_validator", version=1.0, description="call contract validator")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainID"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Transaction serialization string")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Verified successfully")}))
    public Response callValidator(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String txData = (String)params.get("tx");
            CallContractTransaction tx = new CallContractTransaction();
            tx.parse(RPCUtil.decode((String)txData), 0);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
            if (tx.getType() != 16) {
                return this.failed("non call contract tx");
            }
            Result validator = this.contractTxValidatorManager.callValidator(chainId, tx);
            if (validator.isFailed()) {
                return ContractUtil.wrapperFailed(validator);
            }
            result.put("value", true);
            return this.success(result);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_delete_validator", version=1.0, description="delete contract validator")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterDes="chainID"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Transaction serialization string")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Verified successfully")}))
    public Response deleteValidator(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String txData = (String)params.get("tx");
            DeleteContractTransaction tx = new DeleteContractTransaction();
            tx.parse(RPCUtil.decode((String)txData), 0);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
            if (tx.getType() != 17) {
                return this.failed("non delete contract tx");
            }
            Result validator = this.contractTxValidatorManager.deleteValidator(chainId, tx);
            if (validator.isFailed()) {
                return ContractUtil.wrapperFailed(validator);
            }
            result.put("value", true);
            return this.success(result);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }
}

