/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.service.impl;

import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.helper.ContractTxHelper;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.service.ContractExecutor;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.contract.vm.program.ProgramCreate;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import java.math.BigInteger;

@Component
public class ContractExecutorImpl
implements ContractExecutor {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractTxHelper contractTxHelper;

    @Override
    public ContractResult create(ProgramExecutor executor, ContractData create, long number, String preStateRoot, byte[] publicKey) {
        byte[] contractAddress = create.getContractAddress();
        byte[] sender = create.getSender();
        long price = create.getPrice();
        ProgramCreate programCreate = new ProgramCreate();
        programCreate.setContractAddress(contractAddress);
        programCreate.setSender(sender);
        programCreate.setValue(BigInteger.ZERO);
        programCreate.setPrice(price);
        programCreate.setGasLimit(create.getGasLimit());
        programCreate.setNumber(number);
        programCreate.setContractCode(create.getCode());
        programCreate.setArgs(create.getArgs());
        programCreate.setSenderPublicKey(publicKey);
        ProgramExecutor track = executor.startTracking();
        ProgramResult programResult = track.create(programCreate);
        ContractResult contractResult = new ContractResult();
        contractResult.setGasUsed(programResult.getGasUsed());
        contractResult.setPrice(price);
        contractResult.setContractAddress(contractAddress);
        contractResult.setSender(sender);
        contractResult.setRemark("create");
        contractResult.setTxTrack(track);
        contractResult.setDebugEvents(programResult.getDebugEvents());
        if (!programResult.isSuccess()) {
            contractResult.setError(programResult.isError());
            contractResult.setRevert(programResult.isRevert());
            contractResult.setErrorMessage(programResult.getErrorMessage());
            contractResult.setStackTrace(programResult.getStackTrace());
            return contractResult;
        }
        contractResult.setError(false);
        contractResult.setRevert(false);
        contractResult.setEvents(programResult.getEvents());
        contractResult.setTransfers(programResult.getTransfers());
        contractResult.setOrderedInnerTxs(programResult.getOrderedInnerTxs());
        return contractResult;
    }

    @Override
    public ContractResult call(ProgramExecutor executor, ContractData call, long number, String preStateRoot, byte[] publicKey) {
        byte[] contractAddress = call.getContractAddress();
        byte[] sender = call.getSender();
        long price = call.getPrice();
        ProgramCall programCall = new ProgramCall();
        programCall.setContractAddress(contractAddress);
        programCall.setSender(sender);
        programCall.setValue(call.getValue());
        programCall.setMultyAssetValues(call.getMultyAssetValues());
        programCall.setPrice(price);
        programCall.setGasLimit(call.getGasLimit());
        programCall.setNumber(number);
        programCall.setMethodName(call.getMethodName());
        programCall.setMethodDesc(call.getMethodDesc());
        programCall.setArgs(call.getArgs());
        programCall.setSenderPublicKey(publicKey);
        ProgramExecutor track = executor.startTracking();
        ProgramResult programResult = track.call(programCall);
        ContractResult contractResult = new ContractResult();
        contractResult.setGasUsed(programResult.getGasUsed());
        contractResult.setPrice(price);
        contractResult.setContractAddress(contractAddress);
        contractResult.setSender(sender);
        contractResult.setValue(programCall.getValue().longValue());
        contractResult.setRemark("call");
        contractResult.setTxTrack(track);
        contractResult.setDebugEvents(programResult.getDebugEvents());
        if (!programResult.isSuccess()) {
            contractResult.setError(programResult.isError());
            contractResult.setRevert(programResult.isRevert());
            contractResult.setErrorMessage(programResult.getErrorMessage());
            contractResult.setStackTrace(programResult.getStackTrace());
            return contractResult;
        }
        contractResult.setError(false);
        contractResult.setRevert(false);
        contractResult.setResult(programResult.getResult());
        contractResult.setEvents(programResult.getEvents());
        contractResult.setTransfers(programResult.getTransfers());
        contractResult.setInvokeRegisterCmds(programResult.getInvokeRegisterCmds());
        contractResult.setOrderedInnerTxs(programResult.getOrderedInnerTxs());
        contractResult.setContractAddressInnerCallSet(this.contractTxHelper.generateInnerCallSet(programResult.getInternalCalls()));
        contractResult.setProgramInternalCreates(programResult.getInternalCreates());
        contractResult.setAccounts(programResult.getAccounts());
        return contractResult;
    }

    @Override
    public ContractResult delete(ProgramExecutor executor, ContractData delete, long number, String preStateRoot) {
        byte[] contractAddress = delete.getContractAddress();
        byte[] sender = delete.getSender();
        ProgramExecutor track = executor.startTracking();
        ProgramResult programResult = track.stop(number, contractAddress, sender);
        ContractResult contractResult = new ContractResult();
        contractResult.setGasUsed(programResult.getGasUsed());
        contractResult.setContractAddress(contractAddress);
        contractResult.setSender(sender);
        contractResult.setRemark("delete");
        contractResult.setTxTrack(track);
        if (!programResult.isSuccess()) {
            contractResult.setError(programResult.isError());
            contractResult.setRevert(programResult.isRevert());
            contractResult.setErrorMessage(programResult.getErrorMessage());
            contractResult.setStackTrace(programResult.getStackTrace());
            return contractResult;
        }
        contractResult.setError(false);
        contractResult.setRevert(false);
        return contractResult;
    }

    @Override
    public ProgramExecutor createBatchExecute(int chainId, byte[] stateRoot) {
        if (stateRoot == null) {
            return null;
        }
        ProgramExecutor executor = this.contractHelper.getProgramExecutor(chainId).begin(stateRoot);
        return executor;
    }

    @Override
    public Result<byte[]> commitBatchExecute(ProgramExecutor executor) {
        if (executor == null) {
            return ContractUtil.getSuccess();
        }
        executor.commit();
        byte[] stateRoot = executor.getRoot();
        if (Log.isDebugEnabled()) {
            Log.debug("after commit state is {}", HexUtil.encode((byte[])stateRoot));
        }
        return ContractUtil.getSuccess().setData((Object)stateRoot);
    }
}

