/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.service.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.NulsHash;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.helper.ContractTxHelper;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.dto.AccountAmountDto;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.service.ContractTxService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.MapUtil;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;

@Component
public class ContractTxServiceImpl
implements ContractTxService {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractTxHelper contractTxHelper;

    @Override
    public Result contractCreateTx(int chainId, String sender, String alias, Long gasLimit, Long price, byte[] contractCode, String[][] args, String password, String remark) {
        try {
            Result<CreateContractTransaction> result = this.contractTxHelper.makeCreateTx(chainId, sender, alias, gasLimit, price, contractCode, args, password, remark);
            if (result.isFailed()) {
                return result;
            }
            CreateContractTransaction tx = (CreateContractTransaction)((Object)result.getData());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            Result signAndBroadcastTxResult = this.contractTxHelper.signAndBroadcastTx(chainId, sender, password, tx);
            if (signAndBroadcastTxResult.isFailed()) {
                return signAndBroadcastTxResult;
            }
            HashMap resultMap = MapUtil.createHashMap(2);
            String txHash = tx.getHash().toHex();
            String contractAddressStr = AddressTool.getStringAddressByBytes((byte[])((CreateContractData)tx.getTxDataObj()).getContractAddress());
            resultMap.put("txHash", txHash);
            resultMap.put("contractAddress", contractAddressStr);
            this.contractHelper.getChain(chainId).getContractTxCreateUnconfirmedManager().saveLocalUnconfirmedCreateContractTransaction(sender, resultMap, tx.getTime());
            return ContractUtil.getSuccess().setData((Object)resultMap);
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
        catch (IOException e) {
            Log.error(e);
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_TX_CREATE_ERROR);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    @Override
    public Result validateContractCreateTx(int chainId, byte[] sender, Long gasLimit, Long price, byte[] contractCode, String[][] args) {
        return this.contractTxHelper.validateCreate(chainId, sender, null, gasLimit, price, contractCode, args);
    }

    @Override
    public Result contractCallTx(int chainId, String sender, BigInteger value, Long gasLimit, Long price, String contractAddress, String methodName, String methodDesc, String[][] args, String password, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOtherList) {
        try {
            Result<CallContractTransaction> result = this.contractTxHelper.makeCallTx(chainId, sender, value, gasLimit, price, contractAddress, methodName, methodDesc, args, password, remark, multyAssetValues, nulsValueToOtherList);
            if (result.isFailed()) {
                return result;
            }
            CallContractTransaction tx = (CallContractTransaction)((Object)result.getData());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            Result signAndBroadcastTxResult = this.contractTxHelper.signAndBroadcastTx(chainId, sender, password, tx);
            if (signAndBroadcastTxResult.isFailed()) {
                return signAndBroadcastTxResult;
            }
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            resultMap.put("txHash", tx.getHash().toHex());
            return ContractUtil.getSuccess().setData(resultMap);
        }
        catch (IOException e) {
            Log.error(e);
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_EXECUTE_ERROR);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    @Override
    public Result validateContractCallTx(int chainId, byte[] senderBytes, BigInteger value, Long gasLimit, Long price, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args, List<ProgramMultyAssetValue> multyAssetValues) {
        return this.contractTxHelper.validateCall(chainId, senderBytes, contractAddressBytes, value, gasLimit, price, methodName, methodDesc, args, multyAssetValues);
    }

    @Override
    public Result<ContractResult> previewContractCallTx(int chainId, byte[] senderBytes, BigInteger value, Long gasLimit, Long price, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args, List<ProgramMultyAssetValue> multyAssetValues) {
        return this.contractTxHelper.previewCall(chainId, senderBytes, contractAddressBytes, value, gasLimit, price, methodName, methodDesc, args, multyAssetValues);
    }

    @Override
    public Result contractDeleteTx(int chainId, String sender, String contractAddress, String password, String remark) {
        try {
            Result<DeleteContractTransaction> result = this.contractTxHelper.makeDeleteTx(chainId, sender, contractAddress, password, remark);
            if (result.isFailed()) {
                return result;
            }
            DeleteContractTransaction tx = (DeleteContractTransaction)((Object)result.getData());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            Result signAndBroadcastTxResult = this.contractTxHelper.signAndBroadcastTx(chainId, sender, password, tx);
            if (signAndBroadcastTxResult.isFailed()) {
                return signAndBroadcastTxResult;
            }
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            resultMap.put("txHash", tx.getHash().toHex());
            return ContractUtil.getSuccess().setData(resultMap);
        }
        catch (IOException e) {
            Log.error(e);
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_OTHER_ERROR);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    @Override
    public Result validateContractDeleteTx(int chainId, String sender, String contractAddress) {
        byte[] senderBytes = AddressTool.getAddress((String)sender);
        byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
        return this.contractTxHelper.validateDelete(chainId, senderBytes, contractAddress, contractAddressBytes);
    }
}

