/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.helper.ContractTransferHandler;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.AnalyzerResult;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.ContractTransferData;
import io.nuls.contract.service.ContractCaller;
import io.nuls.contract.service.ResultHanlder;
import io.nuls.contract.util.CompareTxOrderAsc;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class ResultHandlerImpl
implements ResultHanlder {
    @Autowired
    private ContractCaller contractCaller;
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractTransferHandler contractTransferHandler;

    @Override
    public List<ContractResult> handleAnalyzerResult(int chainId, ProgramExecutor batchExecutor, AnalyzerResult analyzerResult, String preStateRoot) {
        try {
            BlockHeader currentBlockHeader = this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
            long blockTime = currentBlockHeader.getTime();
            List<ContractResult> reCallResultList = this.reCall(batchExecutor, analyzerResult, chainId, preStateRoot);
            this.handleFailedContract(chainId, analyzerResult, blockTime);
            ArrayList<ContractResult> finalResultList = new ArrayList<ContractResult>();
            finalResultList.addAll(analyzerResult.getSuccessList());
            finalResultList.addAll(analyzerResult.getFailedSet());
            finalResultList.addAll(reCallResultList);
            return finalResultList.stream().sorted(CompareTxOrderAsc.getInstance()).collect(Collectors.toList());
        }
        catch (IOException e) {
            Log.error(e);
            return Collections.emptyList();
        }
        catch (NulsException e) {
            Log.error(e);
            return Collections.emptyList();
        }
    }

    private void handleFailedContract(int chainId, AnalyzerResult analyzerResult, long blockTime) throws IOException, NulsException {
        ContractTempBalanceManager tempBalanceManager = this.contractHelper.getBatchInfoTempBalanceManager(chainId);
        int assetsId = this.contractHelper.getChain(chainId).getConfig().getAssetId();
        Set<ContractResult> failedSet = analyzerResult.getFailedSet();
        for (ContractResult contractResult : failedSet) {
            ContractData contractData;
            BigInteger value;
            ContractWrapperTransaction orginTx = contractResult.getTx();
            if (orginTx.getType() != 16 || (value = (contractData = orginTx.getContractData()).getValue()).compareTo(BigInteger.ZERO) <= 0) continue;
            byte[] contractAddress = contractData.getContractAddress();
            ContractTransferData txData = new ContractTransferData(orginTx.getHash(), contractAddress);
            CoinData coinData = new CoinData();
            ContractBalance balance = (ContractBalance)tempBalanceManager.getBalance(contractAddress, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID).getData();
            byte[] nonceBytes = RPCUtil.decode((String)balance.getNonce());
            CoinFrom coinFrom = new CoinFrom(contractAddress, chainId, assetsId, value, nonceBytes, 0);
            coinData.getFrom().add(coinFrom);
            CoinTo coinTo = new CoinTo(contractData.getSender(), chainId, assetsId, value, 0L);
            coinData.getTo().add(coinTo);
            ContractTransferTransaction tx = new ContractTransferTransaction();
            tx.setCoinDataObj(coinData);
            tx.setTxDataObj(txData);
            tx.setTime(blockTime);
            tx.serializeData();
            NulsHash hash = NulsHash.calcHash((byte[])tx.serializeForHash());
            byte[] hashBytes = hash.getBytes();
            byte[] currentNonceBytes = Arrays.copyOfRange(hashBytes, hashBytes.length - 8, hashBytes.length);
            balance.setNonce(RPCUtil.encode((byte[])currentNonceBytes));
            tx.setHash(hash);
            contractResult.getContractTransferList().add(tx);
            contractResult.setMergedTransferList(this.contractTransferHandler.contractTransfer2mergedTransfer(orginTx, contractResult.getContractTransferList()));
            contractResult.setMergerdMultyAssetTransferList(this.contractTransferHandler.contractMultyAssetTransfer2mergedTransfer(orginTx, contractResult.getContractTransferList()));
        }
    }

    private List<ContractResult> reCall(ProgramExecutor batchExecutor, AnalyzerResult analyzerResult, int chainId, String preStateRoot) throws NulsException {
        List<ContractResult> list = analyzerResult.getReCallTxList();
        List<ContractWrapperTransaction> collectTxs = list.stream().sorted(CompareTxOrderAsc.getInstance()).map(c -> c.getTx()).collect(Collectors.toList());
        List<ContractResult> resultList = this.contractCaller.reCallTx(batchExecutor, collectTxs, chainId, preStateRoot);
        return resultList;
    }
}

