/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.storage.impl;

import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.storage.ContractAddressStorageService;
import io.nuls.contract.util.ContractDBUtil;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
public class ContractAddressStorageServiceImpl
implements ContractAddressStorageService {
    private final String baseArea = "contract_address_";

    @Override
    public Result saveContractAddress(int chainId, byte[] contractAddressBytes, ContractAddressInfoPo info) {
        if (contractAddressBytes == null || info == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        boolean result = ContractDBUtil.putModel("contract_address_" + chainId, contractAddressBytes, info);
        if (result) {
            return ContractUtil.getSuccess();
        }
        return ContractUtil.getFailed();
    }

    @Override
    public Result<ContractAddressInfoPo> getContractAddressInfo(int chainId, byte[] contractAddressBytes) {
        if (contractAddressBytes == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        ContractAddressInfoPo infoPo = ContractDBUtil.getModel("contract_address_" + chainId, contractAddressBytes, ContractAddressInfoPo.class);
        if (infoPo != null) {
            infoPo.setContractAddress(contractAddressBytes);
        }
        return ContractUtil.getSuccess().setData((Object)infoPo);
    }

    @Override
    public Result deleteContractAddress(int chainId, byte[] contractAddressBytes) throws Exception {
        if (contractAddressBytes == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        boolean result = RocksDBService.delete((String)("contract_address_" + chainId), (byte[])contractAddressBytes);
        if (result) {
            return ContractUtil.getSuccess();
        }
        return ContractUtil.getFailed();
    }

    @Override
    public boolean isExistContractAddress(int chainId, byte[] contractAddressBytes) {
        if (contractAddressBytes == null) {
            return false;
        }
        byte[] contract = RocksDBService.get((String)("contract_address_" + chainId), (byte[])contractAddressBytes);
        return contract != null;
    }

    @Override
    public Result<List<ContractAddressInfoPo>> getContractInfoList(int chainId, byte[] creater) {
        List list = RocksDBService.entryList((String)("contract_address_" + chainId));
        if (list == null || list.size() == 0) {
            return Result.getFailed((ErrorCode)ContractErrorCode.DATA_NOT_FOUND);
        }
        ArrayList<ContractAddressInfoPo> resultList = new ArrayList<ContractAddressInfoPo>();
        for (Entry entry : list) {
            ContractAddressInfoPo po = ContractDBUtil.getModel((byte[])entry.getValue(), ContractAddressInfoPo.class);
            if (!Arrays.equals(creater, po.getSender())) continue;
            po.setContractAddress((byte[])entry.getKey());
            resultList.add(po);
        }
        Result result = ContractUtil.getSuccess();
        result.setData(resultList);
        return result;
    }

    @Override
    public Result<List<ContractAddressInfoPo>> getAllContractInfoList(int chainId) {
        List list = RocksDBService.entryList((String)("contract_address_" + chainId));
        if (list == null || list.size() == 0) {
            return Result.getFailed((ErrorCode)ContractErrorCode.DATA_NOT_FOUND);
        }
        ArrayList<ContractAddressInfoPo> resultList = new ArrayList<ContractAddressInfoPo>();
        for (Entry entry : list) {
            ContractAddressInfoPo po = ContractDBUtil.getModel((byte[])entry.getValue(), ContractAddressInfoPo.class);
            po.setContractAddress((byte[])entry.getKey());
            resultList.add(po);
        }
        Result result = ContractUtil.getSuccess();
        result.setData(resultList);
        return result;
    }
}

