/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.storage.impl;

import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.model.po.ContractOfflineTxHashPo;
import io.nuls.contract.storage.ContractOfflineTxHashListStorageService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rockdb.service.RocksDBService;

@Component
public class ContractOfflineTxHashListStorageServiceImpl
implements ContractOfflineTxHashListStorageService {
    private final String baseArea = "contract_offline_tx_hash_list_";

    @Override
    public Result saveOfflineTxHashList(int chainId, byte[] blockHash, ContractOfflineTxHashPo po) throws Exception {
        if (blockHash == null || po == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        boolean result = RocksDBService.put((String)("contract_offline_tx_hash_list_" + chainId), (byte[])blockHash, (byte[])po.serialize());
        if (result) {
            return ContractUtil.getSuccess();
        }
        return ContractUtil.getFailed();
    }

    @Override
    public Result deleteOfflineTxHashList(int chainId, byte[] blockHash) throws Exception {
        if (blockHash == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        boolean result = RocksDBService.delete((String)("contract_offline_tx_hash_list_" + chainId), (byte[])blockHash);
        if (result) {
            return ContractUtil.getSuccess();
        }
        return ContractUtil.getFailed();
    }

    @Override
    public Result<ContractOfflineTxHashPo> getOfflineTxHashList(int chainId, byte[] blockHash) throws NulsException {
        if (blockHash == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        byte[] poBytes = RocksDBService.get((String)("contract_offline_tx_hash_list_" + chainId), (byte[])blockHash);
        if (poBytes == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.DATA_NOT_FOUND);
        }
        ContractOfflineTxHashPo po = new ContractOfflineTxHashPo();
        po.parse(poBytes, 0);
        return ContractUtil.getSuccess().setData((Object)po);
    }
}

