/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx.v20;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.ContractCreate;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.ContractResultDto;
import io.nuls.contract.model.dto.CreateContractDataDto;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.processor.CreateContractTxProcessor;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.validator.CreateContractTxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="CreateContractProcessorV20")
public class CreateContractProcessorV20
implements TransactionProcessor {
    @Autowired
    private CreateContractTxProcessor createContractTxProcessor;
    @Autowired
    private CreateContractTxValidator createContractTxValidator;
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractService contractService;

    public int getType() {
        return 15;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ChainManager.chainHandle(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        result.put("txList", errorList);
        String errorCode = null;
        for (Transaction tx : txs) {
            CreateContractTransaction createTx = new CreateContractTransaction();
            createTx.copyTx(tx);
            try {
                Result validate = this.createContractTxValidator.validate(chainId, createTx);
                if (!validate.isFailed()) continue;
                errorCode = validate.getErrorCode().getCode();
                errorList.add(tx);
            }
            catch (NulsException e) {
                Log.error(e);
                errorCode = e.getErrorCode().getCode();
                errorList.add(tx);
            }
        }
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader header) {
        try {
            BatchInfoV8 batchInfo = this.contractHelper.getChain(chainId).getBatchInfoV8();
            if (batchInfo != null) {
                Map<String, ContractResult> contractResultMap = batchInfo.getContractResultMap();
                for (Transaction tx : txs) {
                    String txHash = tx.getHash().toString();
                    ContractResult contractResult = contractResultMap.get(txHash);
                    if (contractResult == null) {
                        Log.warn("empty contract result with txHash: {}", txHash);
                        continue;
                    }
                    ContractWrapperTransaction wrapperTx = contractResult.getTx();
                    wrapperTx.setContractResult(contractResult);
                    this.onCommit(chainId, wrapperTx);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            ChainManager.chainHandle(chainId);
            for (Transaction tx : txs) {
                CreateContractData create = new CreateContractData();
                create.parse(tx.getTxData(), 0);
                this.onRollback(chainId, new ContractWrapperTransaction(tx, create));
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    private Result onCommit(int chainId, ContractWrapperTransaction tx) throws Exception {
        BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId);
        long blockHeight = blockHeader.getHeight();
        tx.setBlockHeight(blockHeight);
        ContractResult contractResult = tx.getContractResult();
        contractResult.setBlockHeight(blockHeight);
        Result saveContractExecuteResult = this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        if (saveContractExecuteResult.isFailed()) {
            return saveContractExecuteResult;
        }
        if (!contractResult.isSuccess()) {
            return ContractUtil.getSuccess();
        }
        CreateContractData txData = (CreateContractData)tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        byte[] sender = txData.getSender();
        String alias = txData.getAlias();
        byte[] code = txData.getCode();
        byte[] newestStateRoot = blockHeader.getStateRoot();
        ContractCreate create = new ContractCreate();
        create.setTokenType(contractResult.getTokenType());
        create.setTokenName(contractResult.getTokenName());
        create.setTokenSymbol(contractResult.getTokenSymbol());
        create.setTokenDecimals(contractResult.getTokenDecimals());
        create.setTokenTotalSupply(contractResult.getTokenTotalSupply());
        create.setAcceptDirectTransfer(contractResult.isAcceptDirectTransfer());
        HashMap<String, ContractAddressInfoPo> infoPoMap = new HashMap<String, ContractAddressInfoPo>();
        Result result = this.contractHelper.onCommitForCreateV16(chainId, blockHeader, create, tx.getHash(), tx.getTime(), contractAddress, sender, code, alias, infoPoMap);
        if (result.isFailed()) {
            return result;
        }
        return result;
    }

    private Result onRollback(int chainId, ContractWrapperTransaction tx) throws Exception {
        ContractData txData = tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        ContractResult contractResult = tx.getContractResult();
        if (contractResult == null) {
            contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
        }
        if (contractResult == null) {
            return Result.getSuccess(null);
        }
        try {
            CreateContractData contractData = (CreateContractData)tx.getContractData();
            Log.info("rollback create tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CreateContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
        }
        catch (Exception e) {
            Log.warn("failed to trace create rollback log, error is {}", e.getMessage());
        }
        Result result = this.contractHelper.onRollbackForCreateV16(chainId, contractAddress, contractResult.isNrc20());
        if (result.isFailed()) {
            return result;
        }
        return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
    }
}

