/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx.v8;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.processor.CreateContractTxProcessor;
import io.nuls.contract.util.Log;
import io.nuls.contract.validator.CreateContractTxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="CreateContractProcessorV8")
public class CreateContractProcessorV8
implements TransactionProcessor {
    @Autowired
    private CreateContractTxProcessor createContractTxProcessor;
    @Autowired
    private CreateContractTxValidator createContractTxValidator;
    @Autowired
    private ContractHelper contractHelper;

    public int getType() {
        return 15;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ChainManager.chainHandle(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        result.put("txList", errorList);
        String errorCode = null;
        for (Transaction tx : txs) {
            CreateContractTransaction createTx = new CreateContractTransaction();
            createTx.copyTx(tx);
            try {
                Result validate = this.createContractTxValidator.validate(chainId, createTx);
                if (!validate.isFailed()) continue;
                errorCode = validate.getErrorCode().getCode();
                errorList.add(tx);
            }
            catch (NulsException e) {
                Log.error(e);
                errorCode = e.getErrorCode().getCode();
                errorList.add(tx);
            }
        }
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader header) {
        try {
            BatchInfoV8 batchInfo = this.contractHelper.getChain(chainId).getBatchInfoV8();
            if (batchInfo != null) {
                Map<String, ContractResult> contractResultMap = batchInfo.getContractResultMap();
                for (Transaction tx : txs) {
                    String txHash = tx.getHash().toString();
                    ContractResult contractResult = contractResultMap.get(txHash);
                    if (contractResult == null) {
                        Log.warn("empty contract result with txHash: {}", txHash);
                        continue;
                    }
                    ContractWrapperTransaction wrapperTx = contractResult.getTx();
                    wrapperTx.setContractResult(contractResult);
                    this.createContractTxProcessor.onCommitV8(chainId, wrapperTx);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            ChainManager.chainHandle(chainId);
            for (Transaction tx : txs) {
                CreateContractData create = new CreateContractData();
                create.parse(tx.getTxData(), 0);
                this.createContractTxProcessor.onRollbackV8(chainId, new ContractWrapperTransaction(tx, create));
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }
}

