/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.util;

import io.nuls.contract.model.bo.ModelWrapper;
import io.nuls.contract.util.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.RocksDBService;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;

public class ContractDBUtil {
    private static final RuntimeSchema MODEL_WRAPPER_SCHEMA = RuntimeSchema.createFrom(ModelWrapper.class);

    public static <T> boolean putModel(String area, byte[] key, T value) {
        if (!ContractDBUtil.baseCheckArea(area)) {
            return false;
        }
        if (key == null || value == null) {
            return false;
        }
        try {
            byte[] bytes = ContractDBUtil.getModelSerialize(value);
            return RocksDBService.put((String)area, (byte[])key, (byte[])bytes);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    private static boolean baseCheckArea(String areaName) {
        return !StringUtils.isBlank((String)areaName) && RocksDBManager.getTable((String)areaName) != null;
    }

    public static <T> T getModel(byte[] value, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        try {
            ModelWrapper model = new ModelWrapper();
            ProtostuffIOUtil.mergeFrom((byte[])value, model, (Schema)MODEL_WRAPPER_SCHEMA);
            if (clazz != null && model.getT() != null) {
                return clazz.cast(model.getT());
            }
            return model.getT();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> byte[] getModelSerialize(T value) {
        ModelWrapper<T> modelWrapper = new ModelWrapper<T>(value);
        byte[] bytes = ProtostuffIOUtil.toByteArray(modelWrapper, (Schema)MODEL_WRAPPER_SCHEMA, (LinkedBuffer)LinkedBuffer.allocate((int)512));
        return bytes;
    }

    public static <T> T getModel(String area, byte[] key, Class<T> clazz) {
        if (!ContractDBUtil.baseCheckArea(area)) {
            return null;
        }
        if (key == null) {
            return null;
        }
        try {
            byte[] bytes = RocksDBService.get((String)area, (byte[])key);
            if (bytes == null) {
                return null;
            }
            ModelWrapper model = new ModelWrapper();
            ProtostuffIOUtil.mergeFrom((byte[])bytes, model, (Schema)MODEL_WRAPPER_SCHEMA);
            if (clazz != null && model.getT() != null) {
                return clazz.cast(model.getT());
            }
            return model.getT();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

