/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.util;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.dto.BlockHeaderDto;
import io.nuls.contract.rpc.call.BlockCall;
import io.nuls.contract.rpc.call.ChainManagerCall;
import io.nuls.contract.rpc.call.ConsensusCall;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class VMContext {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private NulsCoresConfig contractConfig;
    private Map<String, Integer> assetDecimalsCache = new ConcurrentHashMap<String, Integer>();
    private static Map<String, ProgramMethod> NRC20_METHODS = null;
    private static Map<String, ProgramMethod> NRC721_METHODS = null;
    private static Map<String, ProgramMethod> NRC1155_METHODS = null;

    public BlockHeaderDto getBlockHeader(int chainId, String hash) {
        BlockHeader header;
        if (chainId < 0 || StringUtils.isBlank((String)hash)) {
            Log.warn("parameter error.");
            return null;
        }
        try {
            header = BlockCall.getBlockHeader(chainId, hash);
            if (header == null) {
                return null;
            }
        }
        catch (NulsException e) {
            Log.error(e);
            return null;
        }
        BlockHeaderDto resultHeader = new BlockHeaderDto(chainId, header);
        return resultHeader;
    }

    public BlockHeaderDto getBlockHeader(int chainId, long height) {
        BlockHeader header;
        if (chainId < 0 || height < 0L) {
            Log.warn("parameter error.");
            return null;
        }
        try {
            header = BlockCall.getBlockHeader(chainId, height);
            if (header == null) {
                return null;
            }
        }
        catch (NulsException e) {
            Log.error(e);
            return null;
        }
        BlockHeaderDto resultHeader = new BlockHeaderDto(chainId, header);
        return resultHeader;
    }

    public BlockHeaderDto getNewestBlockHeader(int chainId) {
        try {
            BlockHeader header = BlockCall.getLatestBlockHeader(chainId);
            if (header != null) {
                return new BlockHeaderDto(chainId, header);
            }
        }
        catch (NulsException e) {
            Log.error(e);
        }
        return null;
    }

    public BlockHeaderDto getCurrentBlockHeader(int chainId) {
        BlockHeader blockHeader = ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_BALANCE ? this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId) : this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
        if (blockHeader == null) {
            BlockHeaderDto header = this.getNewestBlockHeader(chainId);
            if (header != null) {
                header.setHeight(header.getHeight() + 1L);
                header.setTime(header.getTime() + 10L);
            }
            return header;
        }
        return new BlockHeaderDto(chainId, blockHeader);
    }

    public ContractBalance getBalance(int chainId, int assetChainId, int assetId, byte[] address) {
        ContractBalance balance = this.contractHelper.getBalance(chainId, assetChainId, assetId, address);
        return balance;
    }

    public BigInteger getTotalBalance(int chainId, int assetChainId, int assetId, byte[] address) {
        ContractBalance balance = this.contractHelper.getBalance(chainId, assetChainId, assetId, address);
        if (balance != null) {
            return balance.getTotal();
        }
        return BigInteger.ZERO;
    }

    public int getCrossAssetsDecimals(int assetChainId, int assetId) {
        String key = assetChainId + "_" + assetId;
        Integer decimals = this.assetDecimalsCache.get(key);
        if (decimals == null || decimals == 0) {
            int callResult = ChainManagerCall.getCrossAssetsDecimals(assetChainId, assetId);
            if (callResult > 0) {
                this.assetDecimalsCache.put(key, callResult);
            }
            return callResult;
        }
        return decimals;
    }

    public static Map<String, ProgramMethod> getNrc20Methods() {
        return NRC20_METHODS;
    }

    public static void setNrc20Methods(Map<String, ProgramMethod> nrc20Methods) {
        NRC20_METHODS = nrc20Methods;
    }

    public static Map<String, ProgramMethod> getNrc721Methods() {
        return NRC721_METHODS;
    }

    public static void setNrc721Methods(Map<String, ProgramMethod> nrc721Methods) {
        NRC721_METHODS = nrc721Methods;
    }

    public static Map<String, ProgramMethod> getNrc1155Methods() {
        return NRC1155_METHODS;
    }

    public static void setNrc1155Methods(Map<String, ProgramMethod> nrc1155Methods) {
        NRC1155_METHODS = nrc1155Methods;
    }

    public long getBestHeight(int chainId) {
        BlockHeader currentBlockHeader = ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_BALANCE ? this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId) : this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
        if (currentBlockHeader != null) {
            return currentBlockHeader.getHeight() - 1L;
        }
        try {
            return BlockCall.getLatestHeight(chainId);
        }
        catch (NulsException e) {
            Log.error(e);
            return -1L;
        }
    }

    public String getRandomSeed(int chainId, long endHeight, int count, String algorithm) {
        try {
            return ConsensusCall.getRandomSeedByCount(chainId, endHeight, count, algorithm);
        }
        catch (NulsException e) {
            throw new RuntimeException(e.format());
        }
    }

    public String getRandomSeed(int chainId, long startHeight, long endHeight, String algorithm) {
        try {
            return ConsensusCall.getRandomSeedByHeight(chainId, startHeight, endHeight, algorithm);
        }
        catch (NulsException e) {
            throw new RuntimeException(e.format());
        }
    }

    public List<String> getRandomSeedList(int chainId, long endHeight, int seedCount) {
        try {
            return ConsensusCall.getRandomRawSeedsByCount(chainId, endHeight, seedCount);
        }
        catch (NulsException e) {
            throw new RuntimeException(e.format());
        }
    }

    public List<String> getRandomSeedList(int chainId, long startHeight, long endHeight) {
        try {
            return ConsensusCall.getRandomRawSeedsByHeight(chainId, startHeight, endHeight);
        }
        catch (NulsException e) {
            throw new RuntimeException(e.format());
        }
    }

    public long getCustomMaxViewGasLimit(int chainId) {
        return this.contractHelper.getChain(chainId).getConfig().getMaxViewGas();
    }

    public String getCrossTokenSystemContract() {
        return this.contractConfig.getCrossTokenSystemContract();
    }

    public Set<String> getAssetsAbountContractRewardLogByConsensus(int chainId, byte[] address) {
        return this.contractHelper.getAssetsAboutContractRewardLogByConsensus(chainId, address);
    }

    public BigInteger getAssetAmountAbountContractRewardLogByConsensus(int chainId, byte[] address, int assetChainId, int assetId) {
        return this.contractHelper.getAssetAmountAboutContractRewardLogByConsensus(chainId, address, assetChainId, assetId);
    }
}

