/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import io.nuls.contract.vm.Heap;
import io.nuls.contract.vm.LocalVariables;
import io.nuls.contract.vm.MethodArea;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.OpCode;
import io.nuls.contract.vm.OperandStack;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.VM;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.instructions.references.Athrow;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Frame {
    public final VM vm;
    public final Heap heap;
    public final MethodArea methodArea;
    public final MethodCode methodCode;
    public final int maxStack;
    public final int maxLocals;
    public final OperandStack operandStack;
    public final LocalVariables localVariables;
    public final Result result;
    private AbstractInsnNode currentInsnNode;
    private OpCode currentOpCode;
    public boolean addGas = true;

    public Frame(VM vm, MethodCode methodCode, Object[] args) {
        this.vm = vm;
        this.heap = vm.heap;
        this.methodArea = vm.methodArea;
        this.methodCode = methodCode;
        this.maxStack = this.methodCode.maxStack;
        this.maxLocals = this.methodCode.maxLocals;
        this.operandStack = new OperandStack(this.maxStack);
        this.localVariables = new LocalVariables(this.maxLocals, args);
        this.result = new Result(this.methodCode.returnVariableType);
        this.currentInsnNode = this.methodCode.instructions.getFirst();
    }

    public void step() {
        if (this.currentInsnNode != null) {
            this.currentInsnNode = this.currentInsnNode.getNext();
        }
    }

    public void jump() {
        this.currentInsnNode = this.jumpInsnNode().label;
    }

    public void jump(LabelNode label) {
        this.currentInsnNode = label;
    }

    public OpCode currentOpCode() {
        this.currentOpCode = this.currentInsnNode != null ? OpCode.valueOf(this.currentInsnNode.getOpcode()) : null;
        return this.currentOpCode;
    }

    public int getLine(LabelNode labelNode) {
        LabelNode abstractInsnNode = labelNode;
        while (!(abstractInsnNode instanceof LineNumberNode)) {
            abstractInsnNode = abstractInsnNode.getNext();
        }
        return ((LineNumberNode)abstractInsnNode).line;
    }

    public int getLine() {
        AbstractInsnNode abstractInsnNode = this.currentInsnNode;
        while (!(abstractInsnNode instanceof LineNumberNode)) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        return ((LineNumberNode)abstractInsnNode).line;
    }

    public boolean checkArray(ObjectRef arrayRef, int index) {
        if (arrayRef == null) {
            this.throwNullPointerException();
            return false;
        }
        int length = arrayRef.getDimensions()[0];
        if (index < 0 || index >= length) {
            this.throwArrayIndexOutOfBoundsException(index);
            return false;
        }
        return true;
    }

    private void throwException(ObjectRef objectRef) {
        this.operandStack.pushRef(objectRef);
        Athrow.athrow(this);
    }

    public void throwRuntimeException(String message) {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.RUNTIME_EXCEPTION_TYPE, message);
        this.throwException(objectRef);
    }

    public void throwNumberFormatException(String message) {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.NUMBER_FORMAT_EXCEPTION_TYPE, message);
        this.throwException(objectRef);
    }

    public void throwNullPointerException() {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.NULL_POINTER_EXCEPTION_TYPE);
        this.throwException(objectRef);
    }

    public void throwArrayIndexOutOfBoundsException(int index) {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION_TYPE);
        this.throwException(objectRef);
    }

    public void throwNegativeArraySizeException() {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.NEGATIVE_ARRAY_SIZE_EXCEPTION_TYPE);
        this.throwException(objectRef);
    }

    public void throwClassCastException() {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.CLASS_CAST_EXCEPTION_TYPE);
        this.throwException(objectRef);
    }

    public void throwArithmeticException(String message) {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.ARITHMETIC_EXCEPTION_TYPE, message);
        this.throwException(objectRef);
    }

    private void throwError(ObjectRef objectRef) {
        this.vm.getResult().error(objectRef);
    }

    public void throwStackOverflowError() {
        ObjectRef objectRef = this.heap.runNewObject(VariableType.STACK_OVERFLOW_ERROR_TYPE);
        this.throwError(objectRef);
    }

    public void nonsupportOpCode() {
        int line = this.getLine();
        throw new RuntimeException(String.format("nonsupport opcode\uff1aclass(%s), line(%d)", this.methodCode.className, line));
    }

    public void nonsupportMethod(MethodCode methodCode) {
        throw new RuntimeException("nonsupport method: " + methodCode.fullName);
    }

    public InsnNode insnNode() {
        return (InsnNode)this.currentInsnNode;
    }

    public IntInsnNode intInsnNode() {
        return (IntInsnNode)this.currentInsnNode;
    }

    public VarInsnNode varInsnNode() {
        return (VarInsnNode)this.currentInsnNode;
    }

    public TypeInsnNode typeInsnNode() {
        return (TypeInsnNode)this.currentInsnNode;
    }

    public FieldInsnNode fieldInsnNode() {
        return (FieldInsnNode)this.currentInsnNode;
    }

    public MethodInsnNode methodInsnNode() {
        return (MethodInsnNode)this.currentInsnNode;
    }

    public InvokeDynamicInsnNode invokeDynamicInsnNode() {
        return (InvokeDynamicInsnNode)this.currentInsnNode;
    }

    public JumpInsnNode jumpInsnNode() {
        return (JumpInsnNode)this.currentInsnNode;
    }

    public LabelNode labelNode() {
        return (LabelNode)this.currentInsnNode;
    }

    public LdcInsnNode ldcInsnNode() {
        return (LdcInsnNode)this.currentInsnNode;
    }

    public IincInsnNode iincInsnNode() {
        return (IincInsnNode)this.currentInsnNode;
    }

    public TableSwitchInsnNode tableSwitchInsnNode() {
        return (TableSwitchInsnNode)this.currentInsnNode;
    }

    public LookupSwitchInsnNode lookupSwitchInsnNode() {
        return (LookupSwitchInsnNode)this.currentInsnNode;
    }

    public MultiANewArrayInsnNode multiANewArrayInsnNode() {
        return (MultiANewArrayInsnNode)this.currentInsnNode;
    }

    public FrameNode frameNode() {
        return (FrameNode)this.currentInsnNode;
    }

    public LineNumberNode lineNumberNode() {
        return (LineNumberNode)this.currentInsnNode;
    }

    public AbstractInsnNode getCurrentInsnNode() {
        return this.currentInsnNode;
    }

    public void setAddGas(boolean addGas) {
        this.addGas = addGas;
    }

    public OpCode getCurrentOpCode() {
        return this.currentOpCode;
    }
}

