/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.vm.BigIntegerWrapper;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.VM;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.FieldCode;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeAddress;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.util.CloneUtils;
import io.nuls.contract.vm.util.JsonUtils;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ethereum.core.Repository;
import org.ethereum.vm.DataWord;

public class Heap {
    public static final Map<ObjectRef, Map<String, Object>> INIT_OBJECTS = new HashMap<ObjectRef, Map<String, Object>>(1024);
    public static final Map<String, Object> INIT_ARRAYS = new HashMap<String, Object>(1024);
    private VM vm;
    public Map<ObjectRef, Map<String, Object>> objects = new LinkedHashMap<ObjectRef, Map<String, Object>>(1024);
    public Map<String, Object> arrays = new LinkedHashMap<String, Object>(1024);
    public Set<ObjectRef> changes = new LinkedHashSet<ObjectRef>(1024);
    private final BiMap<String, String> classNames = HashBiMap.create((int)1024);
    private ObjectRef contract;
    private byte[] address;
    private Repository repository;
    public BigIntegerWrapper objectRefCount;
    private static final DataWord OBJECT_REF_COUNT = new DataWord("objectRefCount");

    public Heap(BigInteger objectRefCount) {
        this.objectRefCount = new BigIntegerWrapper(objectRefCount);
    }

    public void setVm(VM vm) {
        this.vm = vm;
    }

    public void loadClassCodes(Map<String, ClassCode> classCodes) {
        if (classCodes != null) {
            int i = 0;
            for (ClassCode classCode : classCodes.values()) {
                this.classNames.put((Object)String.valueOf(i++), (Object)classCode.variableType.getDesc());
            }
            this.classNames.putAll(VariableType.DESCRIPTORS);
        }
    }

    public ObjectRef newObjectRef(String ref, String desc, int ... dimensions) {
        if (StringUtils.isEmpty((CharSequence)ref)) {
            this.objectRefCount.addOne();
            ref = this.objectRefCount.toString();
        }
        ObjectRef objectRef = new ObjectRef(ref, desc, dimensions);
        this.objects.put(objectRef, new LinkedHashMap());
        this.change(objectRef);
        return objectRef;
    }

    public ObjectRef newObjectRef(String desc, int ... dimensions) {
        return this.newObjectRef(null, desc, dimensions);
    }

    public ObjectRef newObject(String ref, ClassCode classCode) {
        ObjectRef objectRef = this.newObjectRef(ref, classCode.variableType.getDesc(), new int[0]);
        this.initFields(classCode, objectRef);
        return objectRef;
    }

    public ObjectRef newObject(ClassCode classCode) {
        return this.newObject(null, classCode);
    }

    public ObjectRef newObject(String className) {
        ClassCode classCode = this.vm.methodArea.loadClass(className);
        return this.newObject(classCode);
    }

    public ObjectRef newObject(VariableType variableType) {
        ClassCode classCode = this.vm.methodArea.loadClass(variableType.getType());
        return this.newObject(classCode);
    }

    public Map<String, Object> getFieldsInit(ObjectRef objectRef) {
        Map<String, Object> fields = this.objects.get(objectRef);
        if (fields == null) {
            fields = INIT_OBJECTS.get(objectRef);
        }
        return fields;
    }

    public Map<String, Object> getFields(ObjectRef objectRef) {
        Map<String, Object> fields = this.getFieldsInit(objectRef);
        if (fields == null && (fields = this.getFieldsFromState(objectRef)) != null) {
            this.objects.put(objectRef, fields);
        }
        return fields;
    }

    public void putFields(ObjectRef objectRef, Map<String, Object> fields) {
        this.objects.put(objectRef, fields);
        this.change(objectRef);
    }

    public Map<String, Object> putFields(ObjectRef objectRef) {
        Map<String, Object> fields = this.objects.get(objectRef);
        if (fields == null) {
            fields = INIT_OBJECTS.get(objectRef);
            if (fields != null) {
                fields = CloneUtils.clone(fields);
                this.objects.put(objectRef, fields);
            } else {
                fields = this.getFieldsFromState(objectRef);
                if (fields != null) {
                    this.objects.put(objectRef, fields);
                }
            }
        }
        return fields;
    }

    public Map<String, Object> getFieldsFromState(ObjectRef objectRef) {
        int capacity;
        if (this.repository == null) {
            return null;
        }
        String key = JsonUtils.encode(objectRef, this.classNames);
        DataWord dataWord = this.repository.getStorageValue(this.address, new DataWord(key));
        if (dataWord == null) {
            return null;
        }
        byte[] value = dataWord.getNoLeadZeroesData();
        Map map = (Map)JsonUtils.decode(new String(value), this.classNames);
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) < ContractContext.UPDATE_VERSION_CONTRACT_BALANCE) {
            return map;
        }
        if (!VariableType.HASH_MAP_TYPE.getDesc().equals(objectRef.getDesc())) {
            return map;
        }
        Float loadFactor = (Float)map.get("loadFactor");
        ObjectRef tableRef = (ObjectRef)map.get("table");
        int n = capacity = tableRef == null ? 0 : tableRef.getDimensions()[0];
        if ((double)loadFactor.floatValue() == 0.75 && capacity >= 65536) {
            map.put("threshold", capacity);
            map.put("loadFactor", Float.valueOf(1.0f));
            this.change(objectRef);
        }
        return map;
    }

    public Object getField(ObjectRef objectRef, String fieldName) {
        return this.getFields(objectRef).get(fieldName);
    }

    public void putField(ObjectRef objectRef, String fieldName, Object value) {
        this.putFields(objectRef).put(fieldName, value);
        this.change(objectRef);
    }

    public Object getStatic(String className, String fieldName) {
        ObjectRef objectRef = this.getStaticObjectRef(className);
        return this.getField(objectRef, fieldName);
    }

    public void putStatic(String className, String fieldName, Object value) {
        ObjectRef objectRef = this.getStaticObjectRef(className);
        this.putField(objectRef, fieldName, value);
    }

    private ObjectRef getStaticObjectRef(String className) {
        ClassCode classCode = this.vm.methodArea.loadClass(className);
        ObjectRef objectRef = new ObjectRef(classCode.name, classCode.variableType.getDesc(), new int[0]);
        Map<String, Object> map = this.getFieldsInit(objectRef);
        if (map == null) {
            objectRef = this.newObjectRef(classCode.name, classCode.variableType.getDesc(), new int[0]);
        }
        return objectRef;
    }

    public ObjectRef newArray(VariableType type, int ... dimensions) {
        ObjectRef objectRef = this.newObjectRef(type.getDesc(), dimensions);
        return objectRef;
    }

    public Object getArrayInit(ObjectRef arrayRef, Integer key) {
        if (key == 0) {
            return this.getField(arrayRef, key.toString());
        }
        String arrayKey = arrayRef.getRef() + "_" + key;
        Object object = this.arrays.get(arrayKey);
        if (object == null) {
            object = INIT_ARRAYS.get(arrayKey);
        }
        return object;
    }

    public Object putArrayInit(ObjectRef arrayRef, Integer key) {
        if (key == 0) {
            return this.putFields(arrayRef).get(key.toString());
        }
        String arrayKey = arrayRef.getRef() + "_" + key;
        Object object = this.arrays.get(arrayKey);
        if (object == null && (object = INIT_ARRAYS.get(arrayKey)) != null) {
            object = CloneUtils.cloneObject(object);
            this.arrays.put(arrayKey, object);
        }
        return object;
    }

    public Object getArrayChunk(ObjectRef arrayRef, int chunkNum, boolean write) {
        return this.getArrayChunk(arrayRef, chunkNum, write, true);
    }

    public Object getArrayChunk(ObjectRef arrayRef, int chunkNum, boolean write, boolean loadDB) {
        this.getFields(arrayRef);
        String key = Integer.toString(chunkNum);
        String arrayKey = arrayRef.getRef() + "_" + key;
        Object value = write ? this.putArrayInit(arrayRef, chunkNum) : this.getArrayInit(arrayRef, chunkNum);
        if (value == null && chunkNum != 0 && loadDB && (value = this.getArrayChunkFromState(arrayRef, arrayKey)) != null) {
            this.arrays.put(arrayKey, value);
        }
        if (value == null) {
            int chunkLength;
            int arrayLength = this.getArrayLength(arrayRef);
            int n = chunkLength = (chunkNum + 1) * 1024 <= arrayLength ? 1024 : arrayLength % 1024;
            if (arrayRef.getDimensions().length == 1 && arrayRef.getVariableType().isPrimitiveType()) {
                Class componentType = arrayRef.getVariableType().getPrimitiveTypeClass();
                value = Array.newInstance(componentType, chunkLength);
            } else {
                value = new ObjectRef[chunkLength];
            }
            if (chunkNum == 0) {
                this.putField(arrayRef, key, value);
            } else {
                this.arrays.put(arrayKey, value);
                this.putField(arrayRef, key, key);
            }
        }
        value = this.getArrayInit(arrayRef, chunkNum);
        return value;
    }

    public Object getArrayChunkFromState(ObjectRef arrayRef, String arrayKey) {
        if (this.repository == null) {
            return null;
        }
        DataWord dataWord = this.repository.getStorageValue(this.address, new DataWord(arrayKey));
        if (dataWord == null) {
            return null;
        }
        byte[] value = dataWord.getNoLeadZeroesData();
        Class<ObjectRef> clazz = arrayRef.getVariableType().getPrimitiveTypeClass();
        if (!arrayRef.getVariableType().getComponentType().isPrimitive()) {
            clazz = ObjectRef.class;
        }
        Object object = JsonUtils.decodeArray(new String(value), clazz, this.classNames);
        return object;
    }

    public Object getArray(ObjectRef arrayRef, int index) {
        int chunkNum = index / 1024;
        int chunkIndex = index % 1024;
        Object arrayChunk = this.getArrayChunk(arrayRef, chunkNum, false);
        Object value = Array.get(arrayChunk, chunkIndex);
        if (value == null && arrayRef.getDimensions().length > 1) {
            int[] dimensions = new int[arrayRef.getDimensions().length - 1];
            System.arraycopy(arrayRef.getDimensions(), 1, dimensions, 0, arrayRef.getDimensions().length - 1);
            VariableType variableType = VariableType.valueOf(arrayRef.getVariableType().getDesc().substring(1));
            value = this.newArray(variableType, dimensions);
            this.putArray(arrayRef, index, value);
        }
        return value;
    }

    public void putArray(ObjectRef arrayRef, int index, Object value) {
        int chunkNum = index / 1024;
        int chunkIndex = index % 1024;
        Object arrayChunk = this.getArrayChunk(arrayRef, chunkNum, true);
        Array.set(arrayChunk, chunkIndex, value);
        this.change(arrayRef);
    }

    public void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        this.arraycopy(src, srcPos, dest, destPos, length, true);
    }

    public void arraycopy(Object src, int srcPos, Object dest, int destPos, int length, boolean loadDB) {
        if (length < 1) {
            return;
        }
        this.checkArray(src, srcPos);
        this.checkArray(src, srcPos + length - 1);
        this.checkArray(dest, destPos);
        this.checkArray(dest, destPos + length - 1);
        while (length > 0) {
            int srcChunk = srcPos / 1024;
            int srcIndex = srcPos % 1024;
            int destChunk = destPos / 1024;
            int destIndex = destPos % 1024;
            int index = Math.max(srcIndex, destIndex);
            int copyLength = 1024 - index;
            copyLength = Math.min(copyLength, length);
            this.arrayChunkCopy(src, srcChunk, srcIndex, dest, destChunk, destIndex, copyLength, loadDB);
            srcPos += copyLength;
            destPos += copyLength;
            length -= copyLength;
        }
    }

    public void arrayChunkCopy(Object src, int srcChunk, int srcPos, Object dest, int destChunk, int destPos, int length, boolean loadDB) {
        Object srcArray = src;
        if (src instanceof ObjectRef) {
            srcArray = this.getArrayChunk((ObjectRef)src, srcChunk, false, loadDB);
        } else {
            srcPos = srcChunk * 1024 + srcPos;
        }
        Object destArray = dest;
        if (dest instanceof ObjectRef) {
            ObjectRef destObjectRef = (ObjectRef)dest;
            destArray = this.getArrayChunk(destObjectRef, destChunk, true, loadDB);
            this.change(destObjectRef);
        } else {
            destPos = destChunk * 1024 + destPos;
        }
        System.arraycopy(srcArray, srcPos, destArray, destPos, length);
    }

    public ObjectRef newArray(char[] chars) {
        if (chars == null) {
            return null;
        }
        ObjectRef objectRef = this.newArray(VariableType.CHAR_ARRAY_TYPE, chars.length);
        this.arraycopy(chars, 0, objectRef, 0, chars.length);
        return objectRef;
    }

    public ObjectRef newArrayWithoutDB(char[] chars) {
        if (chars == null) {
            return null;
        }
        ObjectRef objectRef = this.newArray(VariableType.CHAR_ARRAY_TYPE, chars.length);
        this.arraycopy(chars, 0, objectRef, 0, chars.length, false);
        return objectRef;
    }

    public ObjectRef newArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ObjectRef objectRef = this.newArray(VariableType.BYTE_ARRAY_TYPE, bytes.length);
        this.arraycopy(bytes, 0, objectRef, 0, bytes.length);
        return objectRef;
    }

    public ObjectRef newArray(Object array, VariableType variableType, int length) {
        if (array == null) {
            return null;
        }
        ObjectRef objectRef = this.newArray(variableType, length);
        this.arraycopy(array, 0, objectRef, 0, length);
        return objectRef;
    }

    public ObjectRef newArrayList() {
        ObjectRef objectRef = this.runNewObject(VariableType.ARRAYLIST_TYPE);
        return objectRef;
    }

    public ObjectRef newString(String str) {
        if (str == null) {
            return null;
        }
        ObjectRef objectRef = this.newObjectRef(VariableType.STRING_TYPE.getDesc(), new int[0]);
        this.putField(objectRef, "hash", str.hashCode());
        this.putField(objectRef, "value", this.newArrayWithoutDB(str.toCharArray()));
        return objectRef;
    }

    public ObjectRef newBigInteger(String value) {
        ObjectRef objectRef = this.runNewObject(VariableType.BIGINTEGER_TYPE, value);
        return objectRef;
    }

    public ObjectRef newBigInteger(byte[] value) {
        ObjectRef objectRef = this.runNewObject(VariableType.BIGINTEGER_TYPE, value);
        return objectRef;
    }

    public ObjectRef newAddress(String value) {
        ObjectRef objectRef = this.runNewObject(VariableType.ADDRESS_TYPE, value);
        return objectRef;
    }

    public ObjectRef newCharacter(char value) {
        return this.runNewObjectWithArgs(VariableType.CHAR_WRAPPER_TYPE, "(C)V", Character.valueOf(value));
    }

    public ObjectRef runNewObject(VariableType variableType, byte[] bytes) {
        ObjectRef ref = this.newArray(bytes);
        return this.runNewObjectWithArgs(variableType, "([B)V", ref);
    }

    public ObjectRef runNewObject(VariableType variableType) {
        return this.runNewObjectWithArgs(variableType, "()V", new Object[0]);
    }

    public ObjectRef runNewObject(VariableType variableType, String str) {
        ObjectRef strRef = this.newString(str);
        return this.runNewObjectWithArgs(variableType, "(Ljava/lang/String;)V", strRef);
    }

    public ObjectRef runNewObjectWithArgs(VariableType variableType, String methodDesc, Object ... args) {
        ClassCode classCode = this.vm.methodArea.loadClass(variableType.getType());
        ObjectRef objectRef = this.newObject(classCode);
        MethodCode methodCode = this.vm.methodArea.loadMethod(objectRef.getVariableType().getType(), "<init>", methodDesc);
        if (methodCode == null) {
            throw new RuntimeException(String.format("can't new %s", variableType.getType()));
        }
        Object[] runArgs = new Object[args.length + 1];
        runArgs[0] = objectRef;
        for (int i = 1; i < runArgs.length; ++i) {
            runArgs[i] = args[i - 1];
        }
        this.vm.run(methodCode, runArgs, false);
        return objectRef;
    }

    public ObjectRef stringArrayToObjectRef(String[] resultArray) {
        ObjectRef objectRef = this.newArray(VariableType.STRING_ARRAY_TYPE, resultArray.length);
        int i = 0;
        for (String value : resultArray) {
            this.putArray(objectRef, i++, this.newString(value));
        }
        return objectRef;
    }

    public ObjectRef multyAssetValueArrayToObjectRef(List<ProgramMultyAssetValue> multyAssetValueArray) {
        ObjectRef objectRef = this.newArray(VariableType.MULTY_ASSET_VALUE_ARRAY_TYPE, multyAssetValueArray.size());
        int i = 0;
        for (ProgramMultyAssetValue value : multyAssetValueArray) {
            this.putArray(objectRef, i++, this.newMultyAssetValue(value));
        }
        return objectRef;
    }

    private ObjectRef newMultyAssetValue(ProgramMultyAssetValue value) {
        ObjectRef objectRef = this.newObject(VariableType.MULTY_ASSET_VALUE_TYPE);
        this.putField(objectRef, "value", this.newBigInteger(value.getValue().toString()));
        this.putField(objectRef, "assetChainId", value.getAssetChainId());
        this.putField(objectRef, "assetId", value.getAssetId());
        return objectRef;
    }

    public ObjectRef stringTwoDimensionalArrayToObjectRef(String[][] resultArray) {
        ObjectRef objectRef = this.newArray(VariableType.STRING_TWO_DIMENSIONAL_ARRAY_TYPE, resultArray.length, 0);
        int i = 0;
        for (String[] valueArray : resultArray) {
            this.putArray(objectRef, i++, this.stringArrayToObjectRef(valueArray));
        }
        return objectRef;
    }

    public ObjectRef getClassRef(String desc) {
        ObjectRef objectRef = new ObjectRef(desc, "Ljava/lang/Class;", new int[0]);
        Map<String, Object> object = this.getFields(objectRef);
        if (object == null) {
            ClassCode classCode = this.vm.methodArea.loadClass("java/lang/Class");
            objectRef = this.newObject(desc, classCode);
        }
        return objectRef;
    }

    public Object getObject(ObjectRef objectRef) {
        if (objectRef == null) {
            return null;
        }
        if (objectRef.isArray() && objectRef.getVariableType().isPrimitiveType() && objectRef.getDimensions().length == 1) {
            Class componentType = objectRef.getVariableType().getPrimitiveTypeClass();
            Object array = Array.newInstance(componentType, objectRef.getDimensions());
            int length = this.getArrayLength(objectRef);
            this.arraycopy(objectRef, 0, array, 0, length);
            return array;
        }
        if (VariableType.STRING_ARRAY_TYPE.equals(objectRef.getVariableType())) {
            int length = this.getArrayLength(objectRef);
            String[] strings = new String[length];
            for (int i = 0; i < strings.length; ++i) {
                String str;
                ObjectRef ref = (ObjectRef)this.getArray(objectRef, i);
                strings[i] = str = this.runToString(ref);
            }
            return strings;
        }
        if (VariableType.STRING_TYPE.equals(objectRef.getVariableType())) {
            ObjectRef charsRef = (ObjectRef)this.getField(objectRef, "value");
            char[] chars = (char[])this.getObject(charsRef);
            String str = new String(chars);
            return str;
        }
        if (VariableType.BIGINTEGER_TYPE.equals(objectRef.getVariableType())) {
            return this.toBigInteger(objectRef);
        }
        return this.runToString(objectRef);
    }

    public ObjectRef getCollectionArrayRef(ObjectRef ref) {
        this.vm.run(this.vm.methodArea.lazyLoadCollectionToArrayMethodCode(), new Object[]{ref}, false);
        Object result = this.vm.getResultValue();
        ObjectRef resultRef = (ObjectRef)result;
        return resultRef;
    }

    public ObjectRef getMapEntrySetRef(ObjectRef ref) {
        this.vm.run(this.vm.methodArea.lazyLoadMapEntrySetMethodCode(), new Object[]{ref}, false);
        Object result = this.vm.getResultValue();
        ObjectRef resultRef = (ObjectRef)result;
        return resultRef;
    }

    public ObjectRef getMapEntryKeyRef(ObjectRef ref) {
        this.vm.run(this.vm.methodArea.lazyLoadMapEntryKeyMethodCode(), new Object[]{ref}, false);
        Object result = this.vm.getResultValue();
        ObjectRef resultRef = (ObjectRef)result;
        return resultRef;
    }

    public ObjectRef getMapEntryValueRef(ObjectRef ref) {
        this.vm.run(this.vm.methodArea.lazyLoadMapEntryValueMethodCode(), new Object[]{ref}, false);
        Object result = this.vm.getResultValue();
        ObjectRef resultRef = (ObjectRef)result;
        return resultRef;
    }

    public String runToString(ObjectRef objectRef) {
        if (objectRef == null) {
            return null;
        }
        String type = objectRef.getVariableType().getType();
        if (objectRef.getVariableType().isArray() && objectRef.getVariableType().isPrimitiveType()) {
            type = VariableType.OBJECT_TYPE.getType();
        }
        MethodCode methodCode = this.vm.methodArea.loadMethod(type, "toString", "()Ljava/lang/String;");
        this.vm.run(methodCode, new Object[]{objectRef}, false);
        Object result = this.vm.getResultValue();
        String value = (String)this.getObject((ObjectRef)result);
        return value;
    }

    public String stackTrace(ObjectRef objectRef) {
        if (objectRef == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.runToString(objectRef));
        s.append("\n");
        ObjectRef stackTraceElementsRef = (ObjectRef)this.getField(objectRef, "stackTraceElements");
        int size = stackTraceElementsRef.getDimensions()[0];
        for (int i = 0; i < size; ++i) {
            ObjectRef stackTraceElementRef = (ObjectRef)this.getArray(stackTraceElementsRef, i);
            s.append("\tat " + this.runToString(stackTraceElementRef));
            s.append("\n");
        }
        return s.toString();
    }

    public BigInteger toBigInteger(ObjectRef objectRef) {
        String value = this.runToString(objectRef);
        if (value == null) {
            return null;
        }
        return new BigInteger(value);
    }

    public Integer toInteger(ObjectRef objectRef) {
        String value = this.runToString(objectRef);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public ObjectRef newContract(byte[] address, ClassCode contractCode, Repository repository) {
        ObjectRef objectRef;
        this.contract = objectRef = this.newObject(NativeAddress.toString(address), contractCode);
        this.address = address;
        this.repository = repository;
        return this.contract;
    }

    public ObjectRef loadContract(byte[] address, ClassCode contractCode, Repository repository) {
        ObjectRef objectRef;
        if (this.contract != null) {
            return this.contract;
        }
        this.contract = objectRef = new ObjectRef(NativeAddress.toString(address), contractCode.variableType.getDesc(), new int[0]);
        this.address = address;
        this.repository = repository;
        this.objectRefCount = new BigIntegerWrapper(this.repository.getStorageValue(this.address, OBJECT_REF_COUNT).toBigInteger());
        String className = this.contract.getVariableType().getType();
        ObjectRef staticObjectRef = this.getStaticObjectRef(className);
        Map<String, Object> fields = this.getFieldsFromState(staticObjectRef);
        if (fields != null) {
            this.objects.put(staticObjectRef, fields);
        }
        return this.contract;
    }

    public Map<DataWord, DataWord> contractState() {
        LinkedHashMap<DataWord, DataWord> contractState = new LinkedHashMap<DataWord, DataWord>(1024);
        contractState.put(OBJECT_REF_COUNT, new DataWord(this.objectRefCount.getValue()));
        LinkedHashSet<ObjectRef> stateObjectRefs = new LinkedHashSet<ObjectRef>(1024);
        String className = this.contract.getVariableType().getType();
        ObjectRef staticObjectRef = this.getStaticObjectRef(className);
        this.stateObjectRefs(stateObjectRefs, staticObjectRef);
        this.stateObjectRefs(stateObjectRefs, this.contract);
        ArrayList<ObjectRef> clearList = new ArrayList<ObjectRef>();
        for (ObjectRef objectRef : stateObjectRefs) {
            Map<String, Object> fields;
            if (!this.changes.contains(objectRef) || (fields = this.getFieldsInit(objectRef)) == null) continue;
            String key = JsonUtils.encode(objectRef, this.classNames);
            String value = JsonUtils.encode(fields, this.classNames);
            contractState.put(new DataWord(key), new DataWord(value));
            if (objectRef.isArray()) {
                for (String k : fields.keySet()) {
                    Integer i = Integer.valueOf(k);
                    if (i == 0) continue;
                    String arrayKey = objectRef.getRef() + "_" + k;
                    Object object = this.getArrayInit(objectRef, i);
                    if (object == null) continue;
                    Class<ObjectRef> clazz = objectRef.getVariableType().getPrimitiveTypeClass();
                    if (!objectRef.getVariableType().getComponentType().isPrimitive()) {
                        clazz = ObjectRef.class;
                    }
                    String arrayValue = JsonUtils.encodeArray(object, clazz, this.classNames);
                    contractState.put(new DataWord(arrayKey), new DataWord(arrayValue));
                }
            }
            clearList.add(objectRef);
        }
        return contractState;
    }

    public void stateObjectRefs(Set<ObjectRef> stateObjectRefs, ObjectRef objectRef) {
        if (!stateObjectRefs.contains(objectRef)) {
            stateObjectRefs.add(objectRef);
            Map<String, Object> fields = this.getFieldsInit(objectRef);
            if (fields != null) {
                for (Map.Entry<String, Object> entry : fields.entrySet()) {
                    Object array;
                    String key = entry.getKey();
                    Object object = entry.getValue();
                    if (object == null) continue;
                    if (object instanceof ObjectRef) {
                        this.stateObjectRefs(stateObjectRefs, (ObjectRef)object);
                    }
                    if (!objectRef.isArray() || (array = this.getArrayInit(objectRef, Integer.valueOf(key))) == null || objectRef.getVariableType().getComponentType().isPrimitive()) continue;
                    int length = Array.getLength(array);
                    for (int i = 0; i < length; ++i) {
                        Object a = Array.get(array, i);
                        if (a == null) continue;
                        this.stateObjectRefs(stateObjectRefs, (ObjectRef)a);
                    }
                }
            }
        }
    }

    private void change(ObjectRef objectRef) {
        if (objectRef != null) {
            this.changes.add(objectRef);
        }
    }

    private void initFields(ClassCode classCode, ObjectRef objectRef) {
        if (StringUtils.isNotBlank((CharSequence)classCode.superName)) {
            ClassCode superClassCode = this.vm.methodArea.loadClass(classCode.superName);
            this.initFields(superClassCode, objectRef);
        }
        for (FieldCode fieldCode : classCode.fields.values()) {
            if (fieldCode.isStatic) continue;
            this.putField(objectRef, fieldCode.name, fieldCode.variableType.getDefaultValue());
        }
    }

    private void checkArray(Object array, int index) {
        if (array instanceof ObjectRef) {
            this.checkArray((ObjectRef)array, index);
        } else {
            if (array == null) {
                throw new NullPointerException();
            }
            int length = Array.getLength(array);
            if (index < 0 || index >= length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
    }

    private void checkArray(ObjectRef arrayRef, int index) {
        if (arrayRef == null) {
            throw new NullPointerException();
        }
        int length = this.getArrayLength(arrayRef);
        if (index < 0 || index >= length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    private int getArrayLength(ObjectRef arrayRef) {
        int length = arrayRef.getDimensions()[0];
        return length;
    }

    public boolean existContract(byte[] address) {
        return this.repository != null && this.repository.isExist(address);
    }

    public BigInteger getObjectRefCount() {
        return this.objectRefCount.getValue();
    }
}

