/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import io.nuls.contract.vm.VM;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.ClassCodeLoader;
import io.nuls.contract.vm.code.FieldCode;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.util.Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MethodArea {
    public static final Map<String, ClassCode> INIT_CLASS_CODES = new HashMap<String, ClassCode>(1024);
    public static final Map<String, MethodCode> INIT_METHOD_CODES = new HashMap<String, MethodCode>(1024);
    private VM vm;
    private final Map<String, ClassCode> classCodes = new HashMap<String, ClassCode>(1024);
    private final Map<String, MethodCode> methodCodes = new HashMap<String, MethodCode>(1024);
    private final Map<String, ClassCode> loadClassCodes = new HashMap<String, ClassCode>(1024);
    private MethodCode collectionToArrayMethodCode;
    private MethodCode mapEntrySetMethodCode;
    private MethodCode mapEntryKeyMethodCode;
    private MethodCode mapEntryValueMethodCode;

    public void setVm(VM vm) {
        this.vm = vm;
    }

    public MethodCode loadMethod(String className, String methodName, String methodDesc) {
        String fullName = StringUtils.isNotEmpty((CharSequence)methodDesc) ? className + "." + methodName + methodDesc : className + "." + methodName;
        MethodCode methodCode = INIT_METHOD_CODES.get(fullName);
        if (methodCode != null) {
            return methodCode;
        }
        methodCode = this.methodCodes.get(fullName);
        if (methodCode != null) {
            return methodCode;
        }
        ClassCode classCode = this.loadClass(className);
        methodCode = classCode.getMethodCode(methodName, methodDesc);
        if (methodCode == null && classCode.superName != null) {
            methodCode = this.loadSuperMethod(classCode.superName, methodName, methodDesc);
        }
        if (methodCode == null) {
            String interfaceName;
            Iterator<String> iterator = classCode.interfaces.iterator();
            while (iterator.hasNext() && (methodCode = this.loadMethod(interfaceName = iterator.next(), methodName, methodDesc)) == null) {
            }
        }
        this.methodCodes.put(fullName, methodCode);
        return methodCode;
    }

    private MethodCode loadSuperMethod(String className, String methodName, String methodDesc) {
        ClassCode classCode = this.loadClass(className);
        MethodCode methodCode = classCode.getMethodCode(methodName, methodDesc);
        if (methodCode == null && classCode.superName != null) {
            methodCode = this.loadSuperMethod(classCode.superName, methodName, methodDesc);
        }
        return methodCode;
    }

    public ClassCode loadClass(String className) {
        ClassCode classCode = INIT_CLASS_CODES.get(className);
        if (classCode != null) {
            return classCode;
        }
        classCode = this.classCodes.get(className);
        if (classCode != null) {
            return classCode;
        }
        classCode = ClassCodeLoader.getFromResource(className);
        if (classCode == null) {
            classCode = this.loadClassCodes.get(className);
        }
        if (classCode == null) {
            throw new RuntimeException("can't load class " + className);
        }
        this.classCodes.put(className, classCode);
        this.clinit(classCode);
        return classCode;
    }

    public void loadClassCodes(Map<String, ClassCode> classCodes) {
        if (classCodes != null) {
            this.loadClassCodes.putAll(classCodes);
            for (String className : classCodes.keySet()) {
                this.loadClass(className);
            }
        }
    }

    public Map<String, FieldCode> allFields(String className) {
        LinkedHashMap<String, FieldCode> fields = new LinkedHashMap<String, FieldCode>();
        this.allFields(className, fields);
        return fields;
    }

    private void allFields(String className, Map<String, FieldCode> fields) {
        ClassCode classCode = this.loadClass(className);
        for (Map.Entry<String, FieldCode> entry : classCode.fields.entrySet()) {
            if (fields.containsKey(entry.getKey())) continue;
            fields.put(entry.getKey(), entry.getValue());
        }
        if (classCode.superName != null) {
            this.allFields(classCode.superName, fields);
        }
    }

    private void clinit(ClassCode classCode) {
        for (FieldCode fieldCode : classCode.fields.values()) {
            if (!fieldCode.isStatic || fieldCode.isFinal) continue;
            this.vm.heap.putStatic(classCode.name, fieldCode.name, fieldCode.variableType.getDefaultValue());
        }
        MethodCode methodCode = classCode.getMethodCode("<clinit>", "()V");
        if (methodCode != null) {
            this.vm.run(methodCode, null, true);
        }
    }

    public Map<String, ClassCode> getClassCodes() {
        return this.classCodes;
    }

    public Map<String, MethodCode> getMethodCodes() {
        return this.methodCodes;
    }

    public MethodCode lazyLoadCollectionToArrayMethodCode() {
        if (this.collectionToArrayMethodCode == null) {
            this.collectionToArrayMethodCode = this.loadMethod(VariableType.ABSTRACT_COLLECTION_TYPE.getType(), "toArray", "()[Ljava/lang/Object;");
        }
        return this.collectionToArrayMethodCode;
    }

    public MethodCode lazyLoadMapEntrySetMethodCode() {
        if (this.mapEntrySetMethodCode == null) {
            this.mapEntrySetMethodCode = this.loadMethod(VariableType.HASH_MAP_TYPE.getType(), "entrySet", Constants.MAP_ENTRYSET_METHOD_DESC);
        }
        return this.mapEntrySetMethodCode;
    }

    public MethodCode lazyLoadMapEntryKeyMethodCode() {
        if (this.mapEntryKeyMethodCode == null) {
            this.mapEntryKeyMethodCode = this.loadMethod(VariableType.HASH_MAP_NODE_TYPE.getType(), "getKey", Constants.MAP_ENTRY_KEY_METHOD_DESC);
        }
        return this.mapEntryKeyMethodCode;
    }

    public MethodCode lazyLoadMapEntryValueMethodCode() {
        if (this.mapEntryValueMethodCode == null) {
            this.mapEntryValueMethodCode = this.loadMethod(VariableType.HASH_MAP_NODE_TYPE.getType(), "getValue", Constants.MAP_ENTRY_VALUE_METHOD_DESC);
        }
        return this.mapEntryValueMethodCode;
    }
}

