/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.code;

import io.nuls.contract.vm.code.FieldCode;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.util.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public class ClassCode {
    public final int version;
    public final int access;
    public final String name;
    public final String signature;
    public final String superName;
    public final List<String> interfaces;
    public final String sourceFile;
    public final String sourceDebug;
    public final ModuleNode module;
    public final String outerClass;
    public final String outerMethod;
    public final String outerMethodDesc;
    public final List<AnnotationNode> visibleAnnotations;
    public final List<AnnotationNode> invisibleAnnotations;
    public final List<TypeAnnotationNode> visibleTypeAnnotations;
    public final List<TypeAnnotationNode> invisibleTypeAnnotations;
    public final List<Attribute> attrs;
    public final List<InnerClassNode> innerClasses;
    public final String nestHostClass;
    public final List<String> nestMembers;
    public final Map<String, FieldCode> fields;
    public final List<MethodCode> methods;
    private final Map<String, MethodCode> methodMap;
    public final VariableType variableType;
    public final boolean isInterface;
    public final boolean isSuper;
    public final boolean isAbstract;
    public final boolean isV1_6;
    public final boolean isV1_8;
    public final String simpleName;

    public ClassCode(ClassNode classNode) {
        this.version = classNode.version;
        this.access = classNode.access;
        this.name = classNode.name;
        this.signature = classNode.signature;
        this.superName = classNode.superName;
        this.interfaces = ListUtils.emptyIfNull((List)classNode.interfaces);
        this.sourceFile = classNode.sourceFile;
        this.sourceDebug = classNode.sourceDebug;
        this.module = classNode.module;
        this.outerClass = classNode.outerClass;
        this.outerMethod = classNode.outerMethod;
        this.outerMethodDesc = classNode.outerMethodDesc;
        this.visibleAnnotations = ListUtils.emptyIfNull((List)classNode.visibleAnnotations);
        this.invisibleAnnotations = ListUtils.emptyIfNull((List)classNode.invisibleAnnotations);
        this.visibleTypeAnnotations = ListUtils.emptyIfNull((List)classNode.visibleTypeAnnotations);
        this.invisibleTypeAnnotations = ListUtils.emptyIfNull((List)classNode.invisibleTypeAnnotations);
        this.attrs = ListUtils.emptyIfNull((List)classNode.attrs);
        this.innerClasses = ListUtils.emptyIfNull((List)classNode.innerClasses);
        this.nestHostClass = classNode.nestHostClass;
        this.nestMembers = ListUtils.emptyIfNull((List)classNode.nestMembers);
        List fieldNodes = ListUtils.emptyIfNull((List)classNode.fields);
        this.fields = new LinkedHashMap<String, FieldCode>(Utils.hashMapInitialCapacity(fieldNodes.size()));
        for (FieldNode fieldNode : fieldNodes) {
            FieldCode fieldCode = new FieldCode(fieldNode);
            this.fields.put(fieldCode.name, fieldCode);
        }
        List methodNodes = ListUtils.emptyIfNull((List)classNode.methods);
        this.methods = new ArrayList<MethodCode>(Utils.arrayListInitialCapacity(methodNodes.size()));
        this.methodMap = new LinkedHashMap<String, MethodCode>(Utils.hashMapInitialCapacity(methodNodes.size() * 2));
        for (MethodNode methodNode : methodNodes) {
            MethodCode methodCode = new MethodCode(this, methodNode);
            this.methods.add(methodCode);
            this.methodMap.put(methodCode.nameDesc, methodCode);
            if (this.methodMap.containsKey(methodCode.name)) continue;
            this.methodMap.put(methodCode.name, methodCode);
        }
        this.variableType = VariableType.valueOf(this.name);
        this.isInterface = (this.access & 0x200) != 0;
        this.isSuper = (this.access & 0x20) != 0;
        this.isAbstract = (this.access & 0x400) != 0;
        this.isV1_6 = (this.version & 0x32) != 0;
        this.isV1_8 = (this.version & 0x34) != 0;
        this.simpleName = this.getSimpleName();
    }

    public MethodCode getMethodCode(String methodName, String methodDesc) {
        if (StringUtils.isEmpty((CharSequence)methodDesc)) {
            return this.methodMap.get(methodName);
        }
        return this.methodMap.get(methodName + methodDesc);
    }

    private String getSimpleName() {
        int i = this.name.lastIndexOf("$");
        if (i > 0) {
            return this.name.substring(i + 1);
        }
        i = this.name.lastIndexOf("/");
        if (i > 0) {
            return this.name.substring(i + 1);
        }
        return this.name;
    }

    public boolean isSyntheticField(String fieldName) {
        FieldCode fieldCode = this.fields.get(fieldName);
        return fieldCode != null && fieldCode.isSynthetic;
    }
}

