/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.code;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;

public class Descriptors {
    public static final BiMap<String, String> DESCRIPTORS = HashBiMap.create();
    public static final String VOID = "void";
    public static final String BYTE = "byte";
    public static final String CHAR = "char";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String SHORT = "short";
    public static final String BOOLEAN = "boolean";
    public static final String DOUBLE_DESC = "D";
    public static final String LONG_DESC = "J";

    public static List<String> parse(String desc) {
        return Descriptors.parse(desc, false);
    }

    public static List<String> parse(String desc, boolean includeReturn) {
        boolean isL = false;
        boolean isEnd = false;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> descList = new ArrayList<String>();
        for (char c : desc.toCharArray()) {
            if ('[' == c) {
                sb.append(c);
            } else if ('(' != c) {
                if (')' == c) {
                    isEnd = true;
                } else if (';' == c) {
                    isEnd = true;
                    sb.append(c);
                } else if (isL) {
                    sb.append(c);
                } else if ('L' == c) {
                    isL = true;
                    sb.append(c);
                } else if (DESCRIPTORS.inverse().containsKey((Object)String.valueOf(c))) {
                    isEnd = true;
                    sb.append(c);
                } else {
                    throw new IllegalArgumentException("unknown desc");
                }
            }
            if (isEnd) {
                if (sb.length() > 0) {
                    descList.add(sb.toString());
                    sb = new StringBuilder();
                }
                isL = false;
                isEnd = false;
            }
            if (')' == c && !includeReturn) break;
        }
        return descList;
    }

    static {
        DESCRIPTORS.put((Object)VOID, (Object)"V");
        DESCRIPTORS.put((Object)BYTE, (Object)"B");
        DESCRIPTORS.put((Object)CHAR, (Object)"C");
        DESCRIPTORS.put((Object)DOUBLE, (Object)DOUBLE_DESC);
        DESCRIPTORS.put((Object)FLOAT, (Object)"F");
        DESCRIPTORS.put((Object)INT, (Object)"I");
        DESCRIPTORS.put((Object)LONG, (Object)LONG_DESC);
        DESCRIPTORS.put((Object)SHORT, (Object)"S");
        DESCRIPTORS.put((Object)BOOLEAN, (Object)"Z");
    }
}

