/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.code;

import com.google.common.base.Joiner;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.LocalVariableCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.program.ProgramMethodArg;
import io.nuls.contract.vm.program.impl.ProgramDescriptors;
import io.nuls.contract.vm.util.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public class MethodCode {
    public static final String VIEW_ANNOTATION_DESC = "Lio/nuls/contract/sdk/annotation/View;";
    public static final String PAYABLE_ANNOTATION_DESC = "Lio/nuls/contract/sdk/annotation/Payable;";
    public static final String PAYABLEMULTYASSET_ANNOTATION_DESC = "Lio/nuls/contract/sdk/annotation/PayableMultyAsset;";
    public static final String REQUIRED_ANNOTATION_DESC = "Lio/nuls/contract/sdk/annotation/Required;";
    public static final String JSONSERIALIZABLE_ANNOTATION_DESC = "Lio/nuls/contract/sdk/annotation/JSONSerializable;";
    public final int access;
    public final String name;
    public final String desc;
    public final String signature;
    public final List<String> exceptions;
    public final List<ParameterNode> parameters;
    public final List<AnnotationNode> visibleAnnotations;
    public final List<AnnotationNode> invisibleAnnotations;
    public final List<TypeAnnotationNode> visibleTypeAnnotations;
    public final List<TypeAnnotationNode> invisibleTypeAnnotations;
    public final List<Attribute> attrs;
    public final Object annotationDefault;
    public final int visibleAnnotableParameterCount;
    public final List<AnnotationNode>[] visibleParameterAnnotations;
    public final int invisibleAnnotableParameterCount;
    public final List<AnnotationNode>[] invisibleParameterAnnotations;
    public final InsnList instructions;
    public final List<TryCatchBlockNode> tryCatchBlocks;
    public final int maxStack;
    public final int maxLocals;
    public final List<LocalVariableCode> localVariables;
    public final List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public final List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    public final ClassCode classCode;
    public final String className;
    public final String nameDesc;
    public final String fullName;
    public final boolean isPublic;
    public final boolean isStatic;
    public final boolean isAbstract;
    public final boolean isNative;
    public final boolean isClinit;
    public final boolean isConstructor;
    public final VariableType returnVariableType;
    public final List<VariableType> argsVariableType;
    public final String returnArg;
    public final List<ProgramMethodArg> args;
    public final String normalDesc;

    public MethodCode(ClassCode classCode, MethodNode methodNode) {
        this.access = methodNode.access;
        this.name = methodNode.name;
        this.desc = methodNode.desc;
        this.signature = methodNode.signature;
        this.exceptions = ListUtils.emptyIfNull((List)methodNode.exceptions);
        this.parameters = ListUtils.emptyIfNull((List)methodNode.parameters);
        this.visibleAnnotations = ListUtils.emptyIfNull((List)methodNode.visibleAnnotations);
        this.invisibleAnnotations = ListUtils.emptyIfNull((List)methodNode.invisibleAnnotations);
        this.visibleTypeAnnotations = ListUtils.emptyIfNull((List)methodNode.visibleTypeAnnotations);
        this.invisibleTypeAnnotations = ListUtils.emptyIfNull((List)methodNode.invisibleTypeAnnotations);
        this.attrs = ListUtils.emptyIfNull((List)methodNode.attrs);
        this.annotationDefault = methodNode.annotationDefault;
        this.visibleAnnotableParameterCount = methodNode.visibleAnnotableParameterCount;
        this.visibleParameterAnnotations = methodNode.visibleParameterAnnotations;
        this.invisibleAnnotableParameterCount = methodNode.invisibleAnnotableParameterCount;
        this.invisibleParameterAnnotations = methodNode.invisibleParameterAnnotations;
        this.instructions = methodNode.instructions;
        this.tryCatchBlocks = ListUtils.emptyIfNull((List)methodNode.tryCatchBlocks);
        this.maxStack = methodNode.maxStack;
        this.maxLocals = methodNode.maxLocals;
        this.visibleLocalVariableAnnotations = ListUtils.emptyIfNull((List)methodNode.visibleLocalVariableAnnotations);
        this.invisibleLocalVariableAnnotations = ListUtils.emptyIfNull((List)methodNode.invisibleLocalVariableAnnotations);
        this.classCode = classCode;
        this.className = classCode.name;
        this.nameDesc = this.name + this.desc;
        this.fullName = this.className + "." + this.nameDesc;
        this.isPublic = (this.access & 1) != 0;
        this.isStatic = (this.access & 8) != 0;
        this.isAbstract = (this.access & 0x400) != 0;
        this.isNative = (this.access & 0x100) != 0;
        this.isClinit = "<clinit>".equals(this.name);
        this.isConstructor = "<init>".equals(this.name);
        List<VariableType> variableTypes = VariableType.parseAll(this.desc);
        int last = variableTypes.size() - 1;
        this.returnVariableType = variableTypes.get(last);
        this.argsVariableType = variableTypes.subList(0, last);
        List localVariableNodes = ListUtils.emptyIfNull((List)methodNode.localVariables);
        this.localVariables = new ArrayList<LocalVariableCode>(Utils.arrayListInitialCapacity(localVariableNodes.size()));
        for (LocalVariableNode localVariableNode : localVariableNodes) {
            this.localVariables.add(new LocalVariableCode(localVariableNode));
        }
        this.returnArg = ProgramDescriptors.getNormalDesc(this.returnVariableType);
        this.args = new ArrayList<ProgramMethodArg>(Utils.arrayListInitialCapacity(this.argsVariableType.size()));
        ArrayList<CallSite> stringArgs = new ArrayList<CallSite>(Utils.arrayListInitialCapacity(this.argsVariableType.size()));
        int index = 0;
        if (!this.isStatic) {
            ++index;
        }
        for (int i = 0; i < this.argsVariableType.size(); ++i) {
            VariableType previousVariableType;
            VariableType variableType = this.argsVariableType.get(i);
            if (i > 0 && ((previousVariableType = this.argsVariableType.get(i - 1)).isLong() || previousVariableType.isDouble())) {
                ++index;
            }
            Object name = "var" + (i + 1);
            LocalVariableCode localVariableCode = this.getLocalVariableCode(index);
            ++index;
            if (localVariableCode != null) {
                name = localVariableCode.name;
                if (this.isConstructor && classCode.isSyntheticField((String)name)) continue;
            }
            String normalDesc = ProgramDescriptors.getNormalDesc(variableType);
            String stringArg = normalDesc + " " + (String)name;
            stringArgs.add((CallSite)((Object)stringArg));
            ProgramMethodArg arg = new ProgramMethodArg(normalDesc, (String)name, this.hasRequiredAnnotation(i));
            this.args.add(arg);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(Joiner.on((String)", ").join(stringArgs));
        sb.append(") return ");
        sb.append(this.returnArg);
        this.normalDesc = sb.toString();
    }

    public boolean hasViewAnnotation() {
        return this.hasAnnotation(VIEW_ANNOTATION_DESC);
    }

    public boolean hasJSONSerializableAnnotation() {
        return this.hasAnnotation(JSONSERIALIZABLE_ANNOTATION_DESC);
    }

    public boolean hasPayableAnnotation() {
        return this.hasAnnotation(PAYABLE_ANNOTATION_DESC);
    }

    public boolean hasPayableMultyAssetAnnotation() {
        return this.hasAnnotation(PAYABLEMULTYASSET_ANNOTATION_DESC);
    }

    public boolean hasAnnotation(String annotation) {
        return this.visibleAnnotations.stream().anyMatch(annotationNode -> annotation.equals(annotationNode.desc));
    }

    private boolean hasRequiredAnnotation(int i) {
        if (this.visibleParameterAnnotations == null || this.visibleParameterAnnotations.length <= 0 || this.visibleParameterAnnotations.length <= i) {
            return false;
        }
        List<AnnotationNode> list = this.visibleParameterAnnotations[i];
        if (list == null) {
            return false;
        }
        return list.stream().anyMatch(annotationNode -> REQUIRED_ANNOTATION_DESC.equals(annotationNode.desc));
    }

    public LocalVariableCode getLocalVariableCode(int index) {
        return this.localVariables.stream().filter(localVariableCode -> localVariableCode.index == index).findFirst().orElse(null);
    }

    public boolean isClass(String className) {
        return this.className.equals(className);
    }

    public boolean isMethod(String name, String desc) {
        return this.name.equals(name) && this.desc.equals(desc);
    }

    public boolean isMethod(String className, String name, String desc) {
        return this.className.equals(className) && this.name.equals(name) && this.desc.equals(desc);
    }
}

