/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.references;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.code.VariableType;
import org.objectweb.asm.tree.TypeInsnNode;

public class Anewarray {
    public static void anewarray(Frame frame) {
        ObjectRef arrayRef;
        TypeInsnNode typeInsnNode = frame.typeInsnNode();
        String className = typeInsnNode.desc;
        int length = frame.operandStack.popInt();
        if (length < 0) {
            frame.throwNegativeArraySizeException();
            return;
        }
        if (className.contains("[")) {
            VariableType type = VariableType.valueOf(className);
            int[] dimensions = new int[type.getDimensions() + 1];
            dimensions[0] = length;
            VariableType variableType = VariableType.valueOf("[" + className);
            arrayRef = frame.heap.newArray(variableType, dimensions);
        } else {
            VariableType variableType = VariableType.valueOf("[L" + className + ";");
            arrayRef = frame.heap.newArray(variableType, length);
        }
        frame.operandStack.pushRef(arrayRef);
    }
}

