/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeAddress;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeBlock;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeMsg;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeUtils;
import io.nuls.contract.vm.natives.java.lang.NativeAbstractStringBuilder;
import io.nuls.contract.vm.natives.java.lang.NativeCharacter;
import io.nuls.contract.vm.natives.java.lang.NativeClass;
import io.nuls.contract.vm.natives.java.lang.NativeDouble;
import io.nuls.contract.vm.natives.java.lang.NativeFloat;
import io.nuls.contract.vm.natives.java.lang.NativeObject;
import io.nuls.contract.vm.natives.java.lang.NativeRuntime;
import io.nuls.contract.vm.natives.java.lang.NativeSecurityManager;
import io.nuls.contract.vm.natives.java.lang.NativeStrictMath;
import io.nuls.contract.vm.natives.java.lang.NativeString;
import io.nuls.contract.vm.natives.java.lang.NativeSystem;
import io.nuls.contract.vm.natives.java.lang.NativeThrowable;
import io.nuls.contract.vm.natives.java.lang.reflect.NativeArray;
import io.nuls.contract.vm.natives.java.sun.misc.NativeVM;

public class NativeMethod {
    private static final String registerNatives = "registerNatives";
    public static final Result SUPPORT_NATIVE = new Result();
    public static final Result NOT_SUPPORT_NATIVE = new Result();

    public static Result run(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        Result result = null;
        switch (methodCode.className) {
            case "java/lang/AbstractStringBuilder": {
                result = NativeAbstractStringBuilder.override(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Character": {
                result = NativeCharacter.override(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Class": {
                result = NativeClass.override(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Double": {
                result = NativeDouble.override(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Float": {
                result = NativeFloat.override(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/SecurityManager": {
                result = NativeSecurityManager.override(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/String": {
                result = NativeString.override(methodCode, methodArgs, frame, check);
                break;
            }
        }
        if (result != null) {
            return result;
        }
        if (methodCode.instructions.size() > 0) {
            return null;
        }
        if (registerNatives.equals(methodCode.name)) {
            if (check) {
                return SUPPORT_NATIVE;
            }
            return new Result(methodCode.returnVariableType);
        }
        switch (methodCode.className) {
            case "java/lang/reflect/Array": {
                result = NativeArray.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Class": {
                result = NativeClass.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Double": {
                result = NativeDouble.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Float": {
                result = NativeFloat.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Object": {
                result = NativeObject.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Runtime": {
                result = NativeRuntime.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/StrictMath": {
                result = NativeStrictMath.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/String": {
                result = NativeString.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/System": {
                result = NativeSystem.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "java/lang/Throwable": {
                result = NativeThrowable.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "io/nuls/contract/sdk/Address": {
                result = NativeAddress.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "io/nuls/contract/sdk/Block": {
                result = NativeBlock.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "io/nuls/contract/sdk/Msg": {
                result = NativeMsg.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "io/nuls/contract/sdk/Utils": {
                result = NativeUtils.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            case "sun/misc/VM": {
                result = NativeVM.nativeRun(methodCode, methodArgs, frame, check);
                break;
            }
            default: {
                if (check) {
                    result = NOT_SUPPORT_NATIVE;
                    break;
                }
                frame.nonsupportMethod(methodCode);
            }
        }
        return result;
    }

    public static Result run(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        return NativeMethod.run(methodCode, methodArgs, frame, false);
    }

    public static Result result(MethodCode methodCode, Object resultValue, Frame frame) {
        VariableType variableType = methodCode.returnVariableType;
        Result result = new Result(variableType);
        if (variableType.isNotVoid()) {
            result.value(resultValue);
            if (resultValue == null) {
                frame.operandStack.pushRef(null);
            } else if (variableType.isPrimitive()) {
                frame.operandStack.push(resultValue, variableType);
            } else if (resultValue instanceof ObjectRef) {
                frame.operandStack.pushRef((ObjectRef)resultValue);
            } else {
                throw new IllegalArgumentException("unknown result value");
            }
        }
        return result;
    }
}

