/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.io.nuls.contract.sdk;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.enums.CmdRegisterMode;
import io.nuls.contract.enums.CmdRegisterReturnType;
import io.nuls.contract.helper.ContractNewTxFromOtherModuleHandler;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.CmdRegisterManager;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.CmdRegister;
import io.nuls.contract.model.bo.ContractTokenAssetsInfo;
import io.nuls.contract.model.dto.BlockHeaderDto;
import io.nuls.contract.rpc.call.ChainManagerCall;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.Heap;
import io.nuls.contract.vm.MethodArea;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.FieldCode;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.exception.ErrorException;
import io.nuls.contract.vm.natives.NativeMethod;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeAddress;
import io.nuls.contract.vm.program.ProgramAccount;
import io.nuls.contract.vm.program.ProgramCreate;
import io.nuls.contract.vm.program.ProgramCreateData;
import io.nuls.contract.vm.program.ProgramEncodePacked;
import io.nuls.contract.vm.program.ProgramInternalCreate;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramNewTx;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.impl.ProgramInvoke;
import io.nuls.contract.vm.util.JsonUtils;
import io.nuls.contract.vm.util.Utils;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.crypto.KeccakHash;
import io.nuls.core.crypto.Sha3Hash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.message.Response;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class NativeUtils {
    public static final String TYPE = "io/nuls/contract/sdk/Utils";
    public static final String DEBUG_EVENT = "io/nuls/contract/sdk/event/DebugEvent";
    public static final String revert = "io/nuls/contract/sdk/Utils.revert(Ljava/lang/String;)V";
    public static final String emit = "io/nuls/contract/sdk/Utils.emit(Lio/nuls/contract/sdk/Event;)V";
    public static final String sha3 = "io/nuls/contract/sdk/Utils.sha3(Ljava/lang/String;)Ljava/lang/String;";
    public static final String sha3Bytes = "io/nuls/contract/sdk/Utils.sha3([B)Ljava/lang/String;";
    public static final String verifySignatureData = "io/nuls/contract/sdk/Utils.verifySignatureData(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z";
    public static final String getRandomSeedByCount = "io/nuls/contract/sdk/Utils.getRandomSeed(JILjava/lang/String;)Ljava/math/BigInteger;";
    public static final String getRandomSeedByHeight = "io/nuls/contract/sdk/Utils.getRandomSeed(JJLjava/lang/String;)Ljava/math/BigInteger;";
    public static final String getRandomSeedListByCount = "io/nuls/contract/sdk/Utils.getRandomSeedList(JI)Ljava/util/List;";
    public static final String getRandomSeedListByHeight = "io/nuls/contract/sdk/Utils.getRandomSeedList(JJ)Ljava/util/List;";
    public static final String invokeExternalCmd = "io/nuls/contract/sdk/Utils.invokeExternalCmd(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Object;";
    public static final String obj2Json = "io/nuls/contract/sdk/Utils.obj2Json(Ljava/lang/Object;)Ljava/lang/String;";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "io/nuls/contract/sdk/Utils.revert(Ljava/lang/String;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.revert(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.emit(Lio/nuls/contract/sdk/Event;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.emit(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.sha3(Ljava/lang/String;)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.sha3(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.sha3([B)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.sha3Bytes(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.verifySignatureData(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.verifySignatureData(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.getRandomSeed(JILjava/lang/String;)Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.getRandomSeedByCount(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.getRandomSeed(JJLjava/lang/String;)Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.getRandomSeedByHeight(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.getRandomSeedList(JI)Ljava/util/List;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.getRandomSeedListByCount(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.getRandomSeedList(JJ)Ljava/util/List;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.getRandomSeedListByHeight(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.invokeExternalCmd(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Object;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.invokeExternalCmd(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Utils.obj2Json(Ljava/lang/Object;)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeUtils.obj2Json(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result revert(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        String errorMessage = null;
        if (objectRef != null) {
            errorMessage = frame.heap.runToString(objectRef);
        }
        throw new ErrorException(errorMessage, frame.vm.getGasUsed(), null);
    }

    private static Result emit(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        ClassCode classCode = frame.methodArea.loadClass(objectRef.getVariableType().getType());
        boolean isDebugEvent = DEBUG_EVENT.equals(classCode.name);
        List<String> debugEvents = frame.vm.getDebugEvents();
        if (isDebugEvent && debugEvents.size() > 10) {
            Result result = NativeMethod.result(methodCode, null, frame);
            return result;
        }
        Map jsonMap = (Map)NativeUtils.toJson(objectRef, frame.heap, frame.methodArea);
        EventJson eventJson = new EventJson();
        eventJson.setContractAddress(frame.vm.getProgramInvoke().getAddress());
        eventJson.setBlockNumber(frame.vm.getProgramInvoke().getNumber() + 1L);
        eventJson.setEvent(classCode.simpleName);
        eventJson.setPayload(jsonMap);
        String json = JsonUtils.toJson(eventJson);
        if (isDebugEvent) {
            debugEvents.add(json);
        } else {
            frame.vm.getEvents().add(json);
        }
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Object toJson(ObjectRef objectRef, Heap heap, MethodArea methodArea) {
        return NativeUtils.toJson(objectRef.getVariableType(), objectRef, heap, methodArea, 0);
    }

    private static Object toJson(VariableType variableType, Object value, Heap heap, MethodArea methodArea, int depth) {
        ObjectRef ref;
        if (value == null) {
            return null;
        }
        if (depth > 3) {
            if (variableType.isPrimitive()) {
                return variableType.getPrimitiveValue(value);
            }
            ObjectRef ref2 = (ObjectRef)value;
            return heap.runToString(ref2);
        }
        if (variableType.isPrimitive()) {
            return variableType.getPrimitiveValue(value);
        }
        if (variableType.isArray()) {
            ObjectRef ref3 = (ObjectRef)value;
            if (variableType.isPrimitiveType() && variableType.getDimensions() == 1) {
                return heap.getObject(ref3);
            }
            int length = ref3.getDimensions()[0];
            Object[] array = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object item = heap.getArray(ref3, i);
                if (item != null) {
                    ObjectRef itemRef = (ObjectRef)item;
                    item = NativeUtils.toJson(itemRef.getVariableType(), itemRef, heap, methodArea, depth + 1);
                }
                array[i] = item;
            }
            return array;
        }
        if (variableType.isWrapperType()) {
            ObjectRef ref4 = (ObjectRef)value;
            return heap.runToString(ref4);
        }
        String type = variableType.getType();
        boolean isCollection = false;
        boolean isMap = false;
        switch (type) {
            case "java/lang/String": 
            case "java/math/BigInteger": 
            case "java/math/BigDecimal": 
            case "io/nuls/contract/sdk/Address": {
                ObjectRef ref5 = (ObjectRef)value;
                return heap.runToString(ref5);
            }
            case "java/util/Map": 
            case "java/util/HashMap": 
            case "java/util/LinkedHashMap": {
                isMap = true;
                break;
            }
            case "java/util/List": 
            case "java/util/ArrayList": 
            case "java/util/LinkedList": 
            case "java/util/Set": 
            case "java/util/HashSet": 
            case "java/util/HashMap$EntrySet": 
            case "java/util/HashMap$KeySet": 
            case "java/util/LinkedHashMap$EntrySet": 
            case "java/util/LinkedHashMap$KeySet": 
            case "java/util/LinkedHashMap$LinkedEntrySet": 
            case "java/util/LinkedHashMap$LinkedKeySet": {
                isCollection = true;
                break;
            }
        }
        if (isCollection || isMap) {
            ref = (ObjectRef)value;
            if (isCollection) {
                ObjectRef resultRef = heap.getCollectionArrayRef(ref);
                return NativeUtils.toJson(resultRef.getVariableType(), resultRef, heap, methodArea, depth);
            }
            if (isMap) {
                ObjectRef setResultRef = heap.getMapEntrySetRef(ref);
                ObjectRef arrayResultRef = heap.getCollectionArrayRef(setResultRef);
                int length = arrayResultRef.getDimensions()[0];
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (int i = 0; i < length; ++i) {
                    Object item = heap.getArray(arrayResultRef, i);
                    if (item == null) continue;
                    ObjectRef itemRef = (ObjectRef)item;
                    ObjectRef keyRef = heap.getMapEntryKeyRef(itemRef);
                    String key = heap.runToString(keyRef);
                    ObjectRef valueRef = heap.getMapEntryValueRef(itemRef);
                    resultMap.put(key, NativeUtils.toJson(valueRef.getVariableType(), valueRef, heap, methodArea, depth + 1));
                }
                return resultMap;
            }
            return heap.runToString(ref);
        }
        ref = (ObjectRef)value;
        return NativeUtils.toJson(ref, heap, methodArea, depth + 1);
    }

    private static Map<String, Object> toJson(ObjectRef objectRef, Heap heap, MethodArea methodArea, int depth) {
        if (objectRef == null) {
            return null;
        }
        Map<String, FieldCode> fields = methodArea.allFields(objectRef.getVariableType().getType());
        Map<String, Object> map = heap.getFields(objectRef);
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>(Utils.hashMapInitialCapacity(map.size()));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            FieldCode fieldCode = fields.get(name);
            if (fieldCode == null || fieldCode.isSynthetic) continue;
            Object value = entry.getValue();
            jsonMap.put(name, NativeUtils.toJson(fieldCode.variableType, value, heap, methodArea, depth));
        }
        return jsonMap;
    }

    private static Result sha3(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(500L);
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        ObjectRef ref = null;
        if (objectRef != null) {
            String src = frame.heap.runToString(objectRef);
            String sha3 = Sha3Hash.sha3((String)src);
            ref = frame.heap.newString(sha3);
        }
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result sha3Bytes(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(500L);
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        ObjectRef ref = null;
        if (objectRef != null) {
            byte[] bytes = (byte[])frame.heap.getObject(objectRef);
            String sha3 = Sha3Hash.sha3((byte[])bytes);
            ref = frame.heap.newString(sha3);
        }
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result verifySignatureData(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(500L);
        ObjectRef dataRef = (ObjectRef)methodArgs.invokeArgs[0];
        ObjectRef signatureRef = (ObjectRef)methodArgs.invokeArgs[1];
        ObjectRef pubKeyRef = (ObjectRef)methodArgs.invokeArgs[2];
        String data = frame.heap.runToString(dataRef);
        String signature = frame.heap.runToString(signatureRef);
        String pubKey = frame.heap.runToString(pubKeyRef);
        boolean verify = false;
        if (data != null && signature != null && pubKey != null) {
            try {
                verify = Utils.verify(data, signature, pubKey);
            }
            catch (Exception e) {
                verify = false;
            }
        }
        Result result = NativeMethod.result(methodCode, verify, frame);
        return result;
    }

    private static Result getRandomSeedByCount(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(5000L);
        long endHeight = (Long)methodArgs.invokeArgs[0];
        int count = (Integer)methodArgs.invokeArgs[1];
        ObjectRef algorithmRef = (ObjectRef)methodArgs.invokeArgs[2];
        String algorithm = frame.heap.runToString(algorithmRef);
        String seed = frame.vm.getRandomSeed(endHeight, count, algorithm);
        if (StringUtils.isBlank((CharSequence)seed)) {
            seed = "0";
        }
        ObjectRef objectRef = frame.heap.newBigInteger(seed);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static Result getRandomSeedByHeight(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(5000L);
        long startHeight = (Long)methodArgs.invokeArgs[0];
        long endHeight = (Long)methodArgs.invokeArgs[1];
        ObjectRef algorithmRef = (ObjectRef)methodArgs.invokeArgs[2];
        String algorithm = frame.heap.runToString(algorithmRef);
        String seed = frame.vm.getRandomSeed(startHeight, endHeight, algorithm);
        if (StringUtils.isBlank((CharSequence)seed)) {
            seed = "0";
        }
        ObjectRef objectRef = frame.heap.newBigInteger(seed);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static Result getRandomSeedListByCount(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(5000L);
        long endHeight = (Long)methodArgs.invokeArgs[0];
        int count = (Integer)methodArgs.invokeArgs[1];
        List<String> seeds = frame.vm.getRandomSeedList(endHeight, count);
        int i = seeds.size() - 1;
        if (i > 0) {
            frame.vm.addGasUsed(5000 * i);
        }
        ObjectRef objectRef = NativeUtils.newBigIntegerArrayList(frame, seeds);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static ObjectRef newBigIntegerArrayList(Frame frame, List<String> seeds) {
        ObjectRef objectRef = frame.heap.newArrayList();
        MethodCode arrayListAddMethodCode = frame.vm.methodArea.loadMethod(VariableType.ARRAYLIST_TYPE.getType(), "add", "(Ljava/lang/Object;)Z");
        for (String seed : seeds) {
            frame.vm.run(arrayListAddMethodCode, new Object[]{objectRef, frame.heap.newBigInteger(seed)}, false);
        }
        return objectRef;
    }

    private static Result getRandomSeedListByHeight(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(5000L);
        long startHeight = (Long)methodArgs.invokeArgs[0];
        long endHeight = (Long)methodArgs.invokeArgs[1];
        List<String> seeds = frame.vm.getRandomSeedList(startHeight, endHeight);
        int i = seeds.size() - 1;
        if (i > 0) {
            frame.vm.addGasUsed(5000 * i);
        }
        ObjectRef objectRef = NativeUtils.newBigIntegerArrayList(frame, seeds);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static Result invokeExternalCmd(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef;
        List<String> argNames;
        int argNamesSize;
        ProgramInvoke programInvoke = frame.vm.getProgramInvoke();
        if (programInvoke.isCreate()) {
            throw new ErrorException("Invoke external cmd failed. This method cannot be called when creating a contract.", frame.vm.getGasUsed(), null);
        }
        frame.vm.addGasUsed(5000L);
        int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
        ObjectRef cmdNameRef = (ObjectRef)methodArgs.invokeArgs[0];
        ObjectRef argsRef = (ObjectRef)methodArgs.invokeArgs[1];
        String cmdName = frame.heap.runToString(cmdNameRef);
        if ("sc_getCrossTokenSystemContract".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) < ContractContext.UPDATE_VERSION_V250) {
                throw new ErrorException(String.format("Invoke external cmd failed. There is no registration information. chainId: [%s] cmdName: [%s](0)", currentChainId, cmdName), frame.vm.getGasUsed(), null);
            }
            String crossTokenSystemContract = frame.vm.getProgramExecutor().getCrossTokenSystemContract();
            ObjectRef objectRef2 = frame.heap.newString(crossTokenSystemContract);
            Result result = NativeMethod.result(methodCode, objectRef2, frame);
            return result;
        }
        if ("createContract".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_14) {
                return NativeUtils.createContract(methodCode, methodArgs, frame);
            }
        } else if ("encodePacked".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_14) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.encodePacked(args, methodCode, frame);
            }
        } else if ("computeAddress".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_14) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.computeAddress(args, methodCode, frame);
            }
        } else if ("getCodeHash".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_14) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.getCodeHash(args, methodCode, frame);
            }
        } else if ("assetDecimals".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_15) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.assetDecimals(args, methodCode, frame);
            }
        } else if ("currentChainId".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_15) {
                ObjectRef objectRef3 = frame.heap.newString("" + frame.vm.getProgramExecutor().getCurrentChainId());
                Result result = NativeMethod.result(methodCode, objectRef3, frame);
                return result;
            }
        } else if ("getAddressByPublicKey".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_15) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.getAddressByPublicKey(args, methodCode, frame);
            }
        } else if ("keccak".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_17) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.keccak(args, methodCode, frame);
            }
        } else if ("consensusRewardAssets".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_21) {
                String[] args = (String[])frame.heap.getObject(argsRef);
                return NativeUtils.consensusRewardAssets(args, methodCode, frame);
            }
        } else if ("consensusRewardAssetAmount".equals(cmdName) && ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_21) {
            String[] args = (String[])frame.heap.getObject(argsRef);
            return NativeUtils.consensusRewardAssetAmount(args, methodCode, frame);
        }
        String[] args = (String[])frame.heap.getObject(argsRef);
        CmdRegisterManager cmdRegisterManager = (CmdRegisterManager)SpringLiteContext.getBean(CmdRegisterManager.class);
        CmdRegister cmdRegister = cmdRegisterManager.getCmdRegisterByCmdName(currentChainId, cmdName);
        if (cmdRegister == null) {
            throw new ErrorException(String.format("Invoke external cmd failed. There is no registration information. chainId: [%s] cmdName: [%s]", currentChainId, cmdName), frame.vm.getGasUsed(), null);
        }
        String moduleCode = cmdRegister.getModuleCode();
        int argsSize = args == null ? 0 : args.length;
        if (argsSize != (argNamesSize = (argNames = cmdRegister.getArgNames()).size())) {
            throw new ErrorException(String.format("Invoke external cmd failed. Inconsistent number of arguments. register size: [%s] your size: [%s]", argNamesSize, argsSize), frame.vm.getGasUsed(), null);
        }
        HashMap<String, Object> argsMap = new HashMap<String, Object>(8);
        for (int i = 0; i < argsSize; ++i) {
            argsMap.put(argNames.get(i), args[i]);
        }
        byte[] senderBytes = programInvoke.getSender();
        String contractSender = AddressTool.getStringAddressByBytes((byte[])senderBytes);
        String contractAddress = programInvoke.getAddress();
        byte[] contractAddressBytes = programInvoke.getContractAddress();
        argsMap.put("chainId", currentChainId);
        argsMap.put("contractAddress", contractAddress);
        argsMap.put("contractSender", contractSender);
        CmdRegisterMode cmdRegisterMode = cmdRegister.getCmdRegisterMode();
        if (CmdRegisterMode.NEW_TX.equals((Object)cmdRegisterMode)) {
            BlockHeaderDto blockHeaderDto = frame.vm.getBlockHeader(programInvoke.getNumber() + 1L);
            long blockTime = blockHeaderDto.getTime();
            ProgramAccount account = frame.vm.getProgramExecutor().getAccount(contractAddressBytes, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
            argsMap.put("contractBalance", account.getBalance().toString());
            argsMap.put("contractNonce", account.getNonce());
            argsMap.put("blockTime", blockTime);
        }
        ProgramInvokeRegisterCmd invokeRegisterCmd = new ProgramInvokeRegisterCmd(cmdName, argsMap, cmdRegisterMode);
        if ("cc_tokenOutCrossChain".equals(cmdName)) {
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) < ContractContext.UPDATE_VERSION_V250) {
                throw new ErrorException(String.format("Invoke external cmd failed. There is no registration information. chainId: [%s] cmdName: [%s](1)", currentChainId, cmdName), frame.vm.getGasUsed(), null);
            }
            objectRef = NativeUtils.tokenOutCrossChainCmdProcessor(currentChainId, senderBytes, contractSender, args, contractAddress, contractAddressBytes, cmdRegisterManager, moduleCode, cmdName, argsMap, invokeRegisterCmd, frame);
        } else {
            Object cmdResult = NativeUtils.requestAndResponse(cmdRegisterManager, moduleCode, cmdName, argsMap, frame);
            objectRef = NativeUtils.handleResult(currentChainId, contractAddressBytes, cmdResult, invokeRegisterCmd, cmdRegister, frame);
        }
        frame.vm.getInvokeRegisterCmds().add(invokeRegisterCmd);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static Result getCodeHash(String[] args, MethodCode methodCode, Frame frame) {
        try {
            String codeAddress = args[0];
            byte[] codeAddressBytes = AddressTool.getAddress((String)codeAddress);
            if (!NativeAddress.isContract(codeAddressBytes, frame)) {
                throw new Exception("Not contract address");
            }
            byte[] codeHash = frame.vm.getRepository().getCodeHash(codeAddressBytes);
            ObjectRef resultValue = frame.heap.newString(HexUtil.encode((byte[])codeHash));
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (Exception e) {
            throw new ErrorException("Invoke external cmd failed. When getCodeHash.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result keccak(String[] args, MethodCode methodCode, Frame frame) {
        try {
            String hex = args[0];
            String resultStr = KeccakHash.keccak((String)hex);
            ObjectRef resultValue = frame.heap.newString(resultStr);
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (Exception e) {
            throw new ErrorException("Invoke external cmd failed. When keccak.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result consensusRewardAssets(String[] args, MethodCode methodCode, Frame frame) {
        try {
            String address = args[0];
            byte[] addressBytes = AddressTool.getAddress((String)address);
            int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
            Set<String> set = frame.vm.getAssetsAbountContractRewardLogByConsensus(currentChainId, addressBytes);
            String[] res = new String[set.size()];
            set.toArray(res);
            ObjectRef objectRef = frame.heap.stringArrayToObjectRef(res);
            Result result = NativeMethod.result(methodCode, objectRef, frame);
            return result;
        }
        catch (Exception e) {
            throw new ErrorException("Invoke external cmd failed. When consensusRewardAssets.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result consensusRewardAssetAmount(String[] args, MethodCode methodCode, Frame frame) {
        try {
            String address = args[0];
            int assetChainId = Integer.parseInt(args[1]);
            int assetId = Integer.parseInt(args[2]);
            byte[] addressBytes = AddressTool.getAddress((String)address);
            int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
            BigInteger amount = frame.vm.getAssetAmountAbountContractRewardLogByConsensus(currentChainId, addressBytes, assetChainId, assetId);
            ObjectRef resultValue = frame.heap.newString(amount.toString());
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (Exception e) {
            throw new ErrorException("Invoke external cmd failed. When consensusRewardAssets.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result getAddressByPublicKey(String[] args, MethodCode methodCode, Frame frame) {
        try {
            byte[] publicKey;
            int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
            String pubkey = args[0];
            String resultStr = "";
            if (Utils.isHexString(pubkey) && (publicKey = HexUtil.decode((String)pubkey)) != null && publicKey.length == 33) {
                resultStr = AddressTool.getAddressString((byte[])publicKey, (int)currentChainId);
            }
            ObjectRef resultValue = frame.heap.newString(resultStr);
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (Exception e) {
            throw new ErrorException("Invoke external cmd failed. When getAddressByPublicKey.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result assetDecimals(String[] args, MethodCode methodCode, Frame frame) {
        try {
            int assetChainId = Integer.parseInt(args[0]);
            int assetId = Integer.parseInt(args[1]);
            int decimals = frame.vm.getCrossAssetsDecimals(assetChainId, assetId);
            ObjectRef resultValue = frame.heap.newString("" + decimals);
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (Exception e) {
            throw new ErrorException("Invoke external cmd failed. When getAssetDecimals.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result computeAddress(String[] args, MethodCode methodCode, Frame frame) {
        try {
            int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
            String salt = args[0];
            String codeHash = args[1];
            String sender = args[2];
            ProgramCreateData createData = new ProgramCreateData(AddressTool.getAddress((String)sender), Utils.dataToBytes(salt), HexUtil.decode((String)codeHash));
            Address newAddress = new Address(currentChainId, BaseConstant.CONTRACT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])KeccakHash.keccakBytes((byte[])createData.serialize(), (int)256)));
            ObjectRef resultValue = frame.heap.newString(newAddress.toString());
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (IOException e) {
            throw new ErrorException("Invoke external cmd failed. When computeAddress.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result encodePacked(String[] args, MethodCode methodCode, Frame frame) {
        try {
            ProgramEncodePacked encodePacked = args == null ? new ProgramEncodePacked(0, args) : new ProgramEncodePacked((short)args.length, args);
            ObjectRef resultValue = frame.heap.newString(HexUtil.encode((byte[])encodePacked.serialize()));
            Result result = NativeMethod.result(methodCode, resultValue, frame);
            return result;
        }
        catch (IOException e) {
            throw new ErrorException("Invoke external cmd failed. When encodePacked.", frame.vm.getGasUsed(), e.getMessage());
        }
    }

    private static Result createContract(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ProgramResult programResult;
        String[][] args;
        ProgramInvoke programInvoke = frame.vm.getProgramInvoke();
        if (programInvoke.isCreate()) {
            throw new ErrorException("Invoke external cmd failed. This method cannot be called when creating a contract.", frame.vm.getGasUsed(), null);
        }
        int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
        ObjectRef argsRef = (ObjectRef)methodArgs.invokeArgs[1];
        String[] _args = (String[])frame.heap.getObject(argsRef);
        int length = _args.length;
        String codeAddress = _args[0];
        byte[] codeAddressBytes = AddressTool.getAddress((String)codeAddress);
        if (!NativeAddress.isContract(codeAddressBytes, frame)) {
            throw new ErrorException("Invoke external cmd failed. When creating a contract. [codeCopy] is not a contract address.", frame.vm.getGasUsed(), null);
        }
        String salt = _args[1];
        if (length == 2) {
            args = null;
        } else {
            Object[] subArgs = new String[length - 2];
            System.arraycopy(_args, 2, subArgs, 0, length - 2);
            args = ContractUtil.twoDimensionalArray(subArgs);
        }
        try {
            programResult = NativeUtils.createContract(currentChainId, salt, codeAddressBytes, args, frame);
        }
        catch (IOException e) {
            throw new ErrorException("Invoke external cmd failed. When creating a contract.", frame.vm.getGasUsed(), e.getMessage());
        }
        if (!programResult.isSuccess()) {
            return new Result();
        }
        List<ProgramInternalCreate> internalCreates = frame.vm.getInternalCreates();
        ProgramInternalCreate create = frame.vm.getInternalCreates().get(internalCreates.size() - 1);
        ObjectRef resultValue = frame.heap.newString(AddressTool.getStringAddressByBytes((byte[])create.getContractAddress()));
        Result result = NativeMethod.result(methodCode, resultValue, frame);
        return result;
    }

    private static ProgramResult createContract(int chainId, String salt, byte[] codeAddressBytes, String[][] args, Frame frame) throws IOException {
        ProgramInvoke programInvoke = frame.vm.getProgramInvoke();
        byte[] codes = frame.vm.getRepository().getCode(codeAddressBytes);
        byte[] codeHash = frame.vm.getRepository().getCodeHash(codeAddressBytes);
        ProgramCreateData createData = new ProgramCreateData(programInvoke.getContractAddress(), Utils.dataToBytes(salt), codeHash);
        Address newAddress = new Address(chainId, BaseConstant.CONTRACT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])KeccakHash.keccakBytes((byte[])createData.serialize(), (int)256)));
        ProgramCreate programCreate = new ProgramCreate();
        programCreate.setContractAddress(newAddress.getAddressBytes());
        programCreate.setSender(programInvoke.getContractAddress());
        programCreate.setValue(BigInteger.ZERO);
        programCreate.setPrice(programInvoke.getPrice());
        programCreate.setGasLimit(frame.vm.getGasLeft());
        programCreate.setNumber(programInvoke.getNumber());
        programCreate.setContractCode(codes);
        programCreate.setArgs(args);
        programCreate.setSenderPublicKey(programInvoke.getSenderPublicKey());
        programCreate.setInternalCreate(true);
        programCreate.setEstimateGas(programInvoke.isEstimateGas());
        ProgramInternalCreate programInternalCreate = new ProgramInternalCreate();
        programInternalCreate.setSender(programCreate.getSender());
        programInternalCreate.setContractAddress(programCreate.getContractAddress());
        programInternalCreate.setContractCode(programCreate.getContractCode());
        programInternalCreate.setCodeCopyBy(codeAddressBytes);
        programInternalCreate.setArgs(programCreate.getArgs());
        frame.vm.getInternalCreates().add(programInternalCreate);
        ProgramResult programResult = frame.vm.getProgramExecutor().callProgramExecutor().create(programCreate);
        frame.vm.addGasUsed(programResult.getGasUsed());
        frame.vm.getDebugEvents().addAll(programResult.getDebugEvents());
        if (programResult.isSuccess()) {
            frame.vm.getEvents().addAll(programResult.getEvents());
            return programResult;
        }
        Iterator<String> descendingIterator = programResult.getStackTraces().descendingIterator();
        while (descendingIterator.hasNext()) {
            frame.vm.getStackTraces().addFirst(descendingIterator.next());
        }
        frame.throwRuntimeException(programResult.getErrorMessage());
        return programResult;
    }

    private static ObjectRef tokenOutCrossChainCmdProcessor(int currentChainId, byte[] senderBytes, String contractSender, String[] args, String contractAddress, byte[] contractAddressBytes, CmdRegisterManager cmdRegisterManager, String moduleCode, String cmdName, Map argsMap, ProgramInvokeRegisterCmd invokeRegisterCmd, Frame frame) {
        byte[] nrc20Bytes = senderBytes;
        String nrc20 = contractSender;
        if (!NativeAddress.isContract(nrc20Bytes, frame)) {
            throw new ErrorException("non-contract address", frame.vm.getGasUsed(), null);
        }
        String toAddress = args[1];
        int chainIdByAddress = AddressTool.getChainIdByAddress((String)toAddress);
        if (currentChainId == chainIdByAddress) {
            throw new ErrorException("The chainId of the recipient is not a cross-chain", frame.vm.getGasUsed(), null);
        }
        ChainManager chainManager = (ChainManager)SpringLiteContext.getBean(ChainManager.class);
        Chain chain = chainManager.getChainMap().get(currentChainId);
        Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
        ContractTokenAssetsInfo tokenAssetsInfo = tokenAssetsInfoMap.get(nrc20);
        if (tokenAssetsInfo == null) {
            throw new ErrorException("The token is not registered", frame.vm.getGasUsed(), null);
        }
        int assetId = tokenAssetsInfo.getAssetId();
        argsMap.put("assetId", assetId);
        try {
            boolean isCrossAssets = ChainManagerCall.isCrossAssets(currentChainId, assetId);
            if (!isCrossAssets) {
                throw new ErrorException("The asset is not a cross-chain asset[0]", frame.vm.getGasUsed(), null);
            }
        }
        catch (NulsException e) {
            Log.error(e.getMessage());
            throw new ErrorException("The asset is not a cross-chain asset[1]", frame.vm.getGasUsed(), null);
        }
        try {
            NativeUtils.dealTokenOutCrossChain(contractAddress, contractSender, args, frame);
            NativeUtils.newTokenOutCrossChainTx(currentChainId, contractAddressBytes, cmdRegisterManager, moduleCode, cmdName, argsMap, invokeRegisterCmd, frame);
            ProgramNewTx newTx = invokeRegisterCmd.getProgramNewTx();
            String txHash = newTx.getTxHash();
            Transaction tx = newTx.getTx();
            CoinData coinData = tx.getCoinDataInstance();
            List froms = coinData.getFrom();
            BigInteger txFee = BigInteger.ZERO;
            for (CoinFrom from : froms) {
                if (from.getAssetsChainId() != currentChainId || from.getAssetsId() != 1) continue;
                txFee = txFee.add(from.getAmount());
            }
            String[] invokeResult = new String[]{String.valueOf(currentChainId), String.valueOf(assetId), txHash, txFee.toString()};
            ObjectRef objectRef = frame.heap.stringArrayToObjectRef(invokeResult);
            return objectRef;
        }
        catch (Exception e) {
            Log.error(e.getMessage());
            throw new ErrorException(String.format("new tx error: %s", e.getMessage()), frame.vm.getGasUsed(), null);
        }
    }

    private static void dealTokenOutCrossChain(String currentContractAddress, String tokenContractAddress, String[] args, Frame frame) throws IOException {
        String fromAddress = args[0];
        String value = args[2];
        BigInteger valueBig = new BigInteger(value);
        String[][] args1 = new String[][]{{fromAddress}, {currentContractAddress}};
        ProgramResult programResult = NativeAddress.call(tokenContractAddress, "allowance", "", args1, BigInteger.ZERO, frame);
        String authorizedAmounts = programResult.getResult();
        BigInteger authorizedmountsBig = new BigInteger(authorizedAmounts);
        if (authorizedmountsBig.compareTo(valueBig) < 0) {
            throw new ErrorException("No enough amount for authorization", frame.vm.getGasUsed(), null);
        }
        args1 = new String[][]{{fromAddress}};
        programResult = NativeAddress.call(tokenContractAddress, "balanceOf", "", args1, BigInteger.ZERO, frame);
        String balance = programResult.getResult();
        if (new BigInteger(balance).compareTo(valueBig) < 0) {
            throw new ErrorException("No enough balance of the token", frame.vm.getGasUsed(), null);
        }
        args1 = new String[][]{{fromAddress}, {currentContractAddress}, {value}};
        programResult = NativeAddress.call(tokenContractAddress, "transferFrom", null, args1, BigInteger.ZERO, frame);
        if (!Boolean.parseBoolean(programResult.getResult())) {
            throw new ErrorException("transfer token error", frame.vm.getGasUsed(), null);
        }
    }

    private static void newTokenOutCrossChainTx(int chainId, byte[] contractAddressBytes, CmdRegisterManager cmdRegisterManager, String moduleCode, String cmdName, Map argsMap, ProgramInvokeRegisterCmd invokeRegisterCmd, Frame frame) {
        String txString;
        String txHash;
        Object cmdResult = NativeUtils.requestAndResponse(cmdRegisterManager, moduleCode, cmdName, argsMap, frame);
        if (cmdResult instanceof List) {
            List list = (List)cmdResult;
            txHash = (String)list.get(0);
            txString = (String)list.get(1);
        } else if (cmdResult.getClass().isArray()) {
            String[] result = (String[])cmdResult;
            txHash = result[0];
            txString = result[1];
        } else {
            throw new ErrorException(String.format("Invoke external cmd failed. Unkown return object: %s ", cmdResult.getClass().getName()), frame.vm.getGasUsed(), null);
        }
        ContractNewTxFromOtherModuleHandler handler = (ContractNewTxFromOtherModuleHandler)SpringLiteContext.getBean(ContractNewTxFromOtherModuleHandler.class);
        Transaction tx = handler.updateNonceAndVmBalance(chainId, contractAddressBytes, txHash, txString, frame);
        ProgramNewTx programNewTx = new ProgramNewTx(txHash, txString, tx);
        invokeRegisterCmd.setProgramNewTx(programNewTx);
        frame.vm.getOrderedInnerTxs().add(programNewTx);
    }

    private static Object requestAndResponse(CmdRegisterManager cmdRegisterManager, String moduleCode, String cmdName, Map argsMap, Frame frame) {
        Response cmdResp;
        try {
            cmdResp = cmdRegisterManager.requestAndResponse(moduleCode, cmdName, argsMap);
        }
        catch (Exception e) {
            throw new ErrorException(String.format("Invoke external cmd failed. error: %s", e.getMessage()), frame.vm.getGasUsed(), null);
        }
        if (!cmdResp.isSuccess()) {
            String errorCode = cmdResp.getResponseErrorCode();
            String errorMsg = cmdResp.getResponseComment();
            throw new ErrorException(String.format("Invoke external cmd failed. error code: %s, error message: ", errorCode, errorMsg), frame.vm.getGasUsed(), null);
        }
        Map responseData = (Map)cmdResp.getResponseData();
        Map resultMap = (Map)responseData.get(cmdName);
        return resultMap.get("value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ObjectRef handleResult(int chainId, byte[] contractAddressBytes, Object cmdResult, ProgramInvokeRegisterCmd invokeRegisterCmd, CmdRegister cmdRegister, Frame frame) {
        if (invokeRegisterCmd.getCmdRegisterMode().equals((Object)CmdRegisterMode.NEW_TX)) {
            String txString;
            String txHash;
            if (cmdResult instanceof List) {
                List list = (List)cmdResult;
                txHash = (String)list.get(0);
                txString = (String)list.get(1);
            } else {
                if (!cmdResult.getClass().isArray()) throw new ErrorException(String.format("Invoke external cmd failed. Unkown return object: %s ", cmdResult.getClass().getName()), frame.vm.getGasUsed(), null);
                String[] newTxArray = (String[])cmdResult;
                txHash = newTxArray[0];
                txString = newTxArray[1];
            }
            ContractNewTxFromOtherModuleHandler handler = (ContractNewTxFromOtherModuleHandler)SpringLiteContext.getBean(ContractNewTxFromOtherModuleHandler.class);
            Transaction tx = handler.updateNonceAndVmBalance(chainId, contractAddressBytes, txHash, txString, frame);
            ProgramNewTx programNewTx = new ProgramNewTx(txHash, txString, tx);
            invokeRegisterCmd.setProgramNewTx(programNewTx);
            frame.vm.getOrderedInnerTxs().add(programNewTx);
            return frame.heap.newString(txHash);
        }
        CmdRegisterReturnType returnType = cmdRegister.getCmdRegisterReturnType();
        if (returnType.equals((Object)CmdRegisterReturnType.STRING)) {
            return frame.heap.newString((String)cmdResult);
        }
        if (returnType.equals((Object)CmdRegisterReturnType.STRING_ARRAY)) {
            if (cmdResult instanceof List) {
                return NativeUtils.listToObjectRef((List)cmdResult, frame);
            }
            if (!cmdResult.getClass().isArray()) throw new ErrorException(String.format("Invoke external cmd failed. Unkown return object: %s ", cmdResult.getClass().getName()), frame.vm.getGasUsed(), null);
            return frame.heap.stringArrayToObjectRef((String[])cmdResult);
        }
        if (!returnType.equals((Object)CmdRegisterReturnType.STRING_TWO_DIMENSIONAL_ARRAY)) throw new ErrorException(String.format("Invoke external cmd failed. Unkown return type: %s ", new Object[]{returnType}), frame.vm.getGasUsed(), null);
        if (cmdResult instanceof List) {
            List resultList = (List)cmdResult;
            int size = resultList.size();
            ObjectRef objectRef = frame.heap.newArray(VariableType.STRING_TWO_DIMENSIONAL_ARRAY_TYPE, size, 0);
            int k = 0;
            while (k < size) {
                Object o = resultList.get(k);
                if (o instanceof List) {
                    frame.heap.putArray(objectRef, k, NativeUtils.listToObjectRef((List)o, frame));
                } else if (o instanceof String[]) {
                    frame.heap.putArray(objectRef, k, frame.heap.stringArrayToObjectRef((String[])o));
                }
                ++k;
            }
            return objectRef;
        }
        if (!cmdResult.getClass().isArray()) throw new ErrorException(String.format("Invoke external cmd failed. Unkown return object: %s ", cmdResult.getClass().getName()), frame.vm.getGasUsed(), null);
        String[][] resultArray = (String[][])cmdResult;
        return frame.heap.stringTwoDimensionalArrayToObjectRef(resultArray);
    }

    private static ObjectRef listToObjectRef(List resultList, Frame frame) {
        int size = resultList.size();
        ObjectRef objectRef = frame.heap.newArray(VariableType.STRING_ARRAY_TYPE, size);
        for (int k = 0; k < size; ++k) {
            frame.heap.putArray(objectRef, k, frame.heap.newString((String)resultList.get(k)));
        }
        return objectRef;
    }

    private static Result obj2Json(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        frame.vm.addGasUsed(2000L);
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        ObjectRef ref = null;
        if (objectRef != null) {
            String json = NativeUtils.objectRef2Json(objectRef, frame.heap, frame.methodArea);
            int currentChainId = frame.vm.getProgramExecutor().getCurrentChainId();
            if (ProtocolGroupManager.getCurrentVersion((int)currentChainId) >= ContractContext.PROTOCOL_14) {
                frame.vm.addGasUsed(4 * json.length());
            }
            ref = frame.heap.newString(json);
        }
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    public static String objectRef2Json(ObjectRef objectRef, Heap heap, MethodArea methodArea) {
        if (objectRef != null) {
            Object objectMap = NativeUtils.toJson(objectRef, heap, methodArea);
            String json = JsonUtils.toJson(objectMap);
            return json;
        }
        return null;
    }

    static class EventJson {
        private String contractAddress;
        private long blockNumber;
        private String event;
        private Map<String, Object> payload;

        EventJson() {
        }

        public String getContractAddress() {
            return this.contractAddress;
        }

        public void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        public long getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getEvent() {
            return this.event;
        }

        public void setEvent(String event) {
            this.event = event;
        }

        public Map<String, Object> getPayload() {
            return this.payload;
        }

        public void setPayload(Map<String, Object> payload) {
            this.payload = payload;
        }
    }
}

