/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.natives.NativeMethod;
import java.util.List;

public class NativeClass {
    public static final String TYPE = "java/lang/Class";
    public static final String getPrimitiveClass = "java/lang/Class.getPrimitiveClass(Ljava/lang/String;)Ljava/lang/Class;";
    public static final String getComponentType = "java/lang/Class.getComponentType()Ljava/lang/Class;";
    public static final String isArray = "java/lang/Class.isArray()Z";
    public static final String isPrimitive = "java/lang/Class.isPrimitive()Z";
    public static final String isInterface = "java/lang/Class.isInterface()Z";
    public static final String desiredAssertionStatus = "java/lang/Class.desiredAssertionStatus()Z";
    public static final String desiredAssertionStatus0 = "java/lang/Class.desiredAssertionStatus0(Ljava/lang/Class;)Z";
    public static final String getGenericSignature0 = "java/lang/Class.getGenericSignature0()Ljava/lang/String;";
    public static final String getName0 = "java/lang/Class.getName0()Ljava/lang/String;";
    public static final String getInterfaces = "java/lang/Class.getInterfaces()[Ljava/lang/Class;";
    public static final String getSuperclass = "java/lang/Class.getSuperclass()Ljava/lang/Class;";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Class.getInterfaces()[Ljava/lang/Class;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.getInterfaces(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.desiredAssertionStatus()Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.desiredAssertionStatus(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Class.getPrimitiveClass(Ljava/lang/String;)Ljava/lang/Class;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.getPrimitiveClass(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.getComponentType()Ljava/lang/Class;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.getComponentType(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.isArray()Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.isArray(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.isPrimitive()Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.isPrimitive(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.isInterface()Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.isInterface(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.desiredAssertionStatus0(Ljava/lang/Class;)Z": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.desiredAssertionStatus0(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.getGenericSignature0()Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.getGenericSignature0(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.getName0()Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.getName0(methodCode, methodArgs, frame);
            }
            case "java/lang/Class.getSuperclass()Ljava/lang/Class;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeClass.getSuperclass(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result getPrimitiveClass(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        String name = frame.heap.runToString(objectRef);
        VariableType variableType = VariableType.valueOf(name);
        ObjectRef classRef = frame.heap.getClassRef(variableType.getDesc());
        Result result = NativeMethod.result(methodCode, classRef, frame);
        return result;
    }

    private static Result getComponentType(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        ObjectRef classRef = null;
        if (variableType.isArray()) {
            classRef = frame.heap.getClassRef(variableType.getComponentType().getDesc());
        }
        Result result = NativeMethod.result(methodCode, classRef, frame);
        return result;
    }

    private static Result isArray(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        boolean b = variableType.isArray();
        Result result = NativeMethod.result(methodCode, b, frame);
        return result;
    }

    private static Result isPrimitive(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        boolean b = variableType.isPrimitive();
        Result result = NativeMethod.result(methodCode, b, frame);
        return result;
    }

    private static Result isInterface(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        boolean b = false;
        if (!variableType.isArray() && !variableType.isPrimitiveType()) {
            ClassCode classCode = frame.methodArea.loadClass(variableType.getType());
            b = classCode.isInterface;
        }
        Result result = NativeMethod.result(methodCode, b, frame);
        return result;
    }

    private static Result desiredAssertionStatus(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        boolean status = false;
        Result result = NativeMethod.result(methodCode, status, frame);
        return result;
    }

    private static Result desiredAssertionStatus0(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        boolean status = false;
        Result result = NativeMethod.result(methodCode, status, frame);
        return result;
    }

    private static Result getGenericSignature0(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        ObjectRef ref = null;
        if (!variableType.isPrimitiveType()) {
            ClassCode classCode = frame.methodArea.loadClass(variableType.getType());
            String signature = classCode.signature;
            ref = frame.heap.newString(signature);
        }
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result getName0(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        String name;
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        if (variableType.isArray()) {
            name = variableType.getDesc();
        } else {
            name = variableType.getType();
            if (name.startsWith("L") && name.endsWith(";")) {
                name = name.substring(1, name.length() - 1);
            }
        }
        name = name.replace('/', '.');
        ObjectRef ref = frame.heap.newString(name);
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result getInterfaces(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef array;
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        if (!variableType.isPrimitiveType()) {
            ClassCode classCode = frame.methodArea.loadClass(variableType.getType());
            List<String> interfaces = classCode.interfaces;
            int length = interfaces.size();
            array = frame.heap.newArray(VariableType.valueOf("[Ljava/lang/Class;"), length);
            for (int i = 0; i < length; ++i) {
                String interfaceName = interfaces.get(i);
                VariableType interfaceType = VariableType.valueOf(interfaceName);
                ObjectRef ref = frame.heap.getClassRef(interfaceType.getDesc());
                frame.heap.putArray(array, i, ref);
            }
        } else {
            array = frame.heap.newArray(VariableType.valueOf("[Ljava/lang/Class;"), 0);
        }
        Result result = NativeMethod.result(methodCode, array, frame);
        return result;
    }

    private static Result getSuperclass(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        VariableType variableType = objectRef.getVariableType().isArray() ? objectRef.getVariableType() : VariableType.valueOf(objectRef.getRef());
        ClassCode classCode = frame.methodArea.loadClass(variableType.getType());
        VariableType superVariableType = VariableType.valueOf(classCode.superName);
        ObjectRef classRef = frame.heap.getClassRef(superVariableType.getDesc());
        Result result = NativeMethod.result(methodCode, classRef, frame);
        return result;
    }
}

