/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeDouble {
    public static final String TYPE = "java/lang/Double";
    public static final String doubleToRawLongBits = "java/lang/Double.doubleToRawLongBits(D)J";
    public static final String longBitsToDouble = "java/lang/Double.longBitsToDouble(J)D";
    public static final String parseDouble = "java/lang/Double.parseDouble(Ljava/lang/String;)D";
    public static final String toString = "java/lang/Double.toString(D)Ljava/lang/String;";
    public static final String toHexString = "java/lang/Double.toHexString(D)Ljava/lang/String;";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Double.parseDouble(Ljava/lang/String;)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeDouble.parseDouble(methodCode, methodArgs, frame);
            }
            case "java/lang/Double.toString(D)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeDouble.toString(methodCode, methodArgs, frame);
            }
            case "java/lang/Double.toHexString(D)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeDouble.toHexString(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Double.doubleToRawLongBits(D)J": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeDouble.doubleToRawLongBits(methodCode, methodArgs, frame);
            }
            case "java/lang/Double.longBitsToDouble(J)D": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeDouble.longBitsToDouble(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result doubleToRawLongBits(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double value = (Double)methodArgs.invokeArgs[0];
        long bits = Double.doubleToRawLongBits(value);
        Result result = NativeMethod.result(methodCode, bits, frame);
        return result;
    }

    private static Result longBitsToDouble(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        long bits = (Long)methodArgs.invokeArgs[0];
        double d = Double.longBitsToDouble(bits);
        Result result = NativeMethod.result(methodCode, d, frame);
        return result;
    }

    private static Result parseDouble(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double d;
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        String s = frame.heap.runToString(objectRef);
        try {
            d = Double.parseDouble(s);
        }
        catch (Exception e) {
            frame.throwNumberFormatException(e.getMessage());
            return null;
        }
        Result result = NativeMethod.result(methodCode, d, frame);
        return result;
    }

    private static Result toString(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double d = (Double)methodArgs.invokeArgs[0];
        String s = Double.toString(d);
        ObjectRef ref = frame.heap.newString(s);
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result toHexString(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        double d = (Double)methodArgs.invokeArgs[0];
        String s = Double.toHexString(d);
        ObjectRef ref = frame.heap.newString(s);
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }
}

