/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeFloat {
    public static final String TYPE = "java/lang/Float";
    public static final String intBitsToFloat = "java/lang/Float.intBitsToFloat(I)F";
    public static final String floatToRawIntBits = "java/lang/Float.floatToRawIntBits(F)I";
    public static final String parseFloat = "java/lang/Float.parseFloat(Ljava/lang/String;)F";
    public static final String toString = "java/lang/Float.toString(F)Ljava/lang/String;";
    public static final String toHexString = "java/lang/Float.toHexString(F)Ljava/lang/String;";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Float.parseFloat(Ljava/lang/String;)F": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeFloat.parseFloat(methodCode, methodArgs, frame);
            }
            case "java/lang/Float.toString(F)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeFloat.toString(methodCode, methodArgs, frame);
            }
            case "java/lang/Float.toHexString(F)Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeFloat.toHexString(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Float.intBitsToFloat(I)F": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeFloat.intBitsToFloat(methodCode, methodArgs, frame);
            }
            case "java/lang/Float.floatToRawIntBits(F)I": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeFloat.floatToRawIntBits(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result intBitsToFloat(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        int bits = (Integer)methodArgs.invokeArgs[0];
        float f = Float.intBitsToFloat(bits);
        Result result = NativeMethod.result(methodCode, Float.valueOf(f), frame);
        return result;
    }

    private static Result floatToRawIntBits(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        float value = ((Float)methodArgs.invokeArgs[0]).floatValue();
        int bits = Float.floatToRawIntBits(value);
        Result result = NativeMethod.result(methodCode, bits, frame);
        return result;
    }

    private static Result parseFloat(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        float f;
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        String s = frame.heap.runToString(objectRef);
        try {
            f = Float.parseFloat(s);
        }
        catch (Exception e) {
            frame.throwNumberFormatException(e.getMessage());
            return null;
        }
        Result result = NativeMethod.result(methodCode, Float.valueOf(f), frame);
        return result;
    }

    private static Result toString(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        float f = ((Float)methodArgs.invokeArgs[0]).floatValue();
        String s = Float.toString(f);
        ObjectRef ref = frame.heap.newString(s);
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result toHexString(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        float f = ((Float)methodArgs.invokeArgs[0]).floatValue();
        String s = Float.toHexString(f);
        ObjectRef ref = frame.heap.newString(s);
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }
}

