/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeRuntime {
    public static final String TYPE = "java/lang/Runtime";
    public static final String availableProcessors = "java/lang/Runtime.availableProcessors()I";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Runtime.availableProcessors()I": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeRuntime.availableProcessors(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result availableProcessors(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, 1, frame);
        return result;
    }
}

