/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeSecurityManager {
    public static final String TYPE = "java/lang/SecurityManager";
    public static final String getRootGroup = "java/lang/SecurityManager.getRootGroup()Ljava/lang/ThreadGroup;";
    public static final String checkAccessThread = "java/lang/SecurityManager.checkAccess(Ljava/lang/Thread;)V";
    public static final String checkAccess = "java/lang/SecurityManager.checkAccess(Ljava/lang/ThreadGroup;)V";
    public static final String checkPropertyAccess = "java/lang/SecurityManager.checkPropertyAccess(Ljava/lang/String;)V";
    public static final String checkPermission = "java/lang/SecurityManager.checkPermission(Ljava/security/Permission;)V";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/SecurityManager.getRootGroup()Ljava/lang/ThreadGroup;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSecurityManager.getRootGroup(methodCode, methodArgs, frame);
            }
            case "java/lang/SecurityManager.checkAccess(Ljava/lang/Thread;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSecurityManager.checkAccessThread(methodCode, methodArgs, frame);
            }
            case "java/lang/SecurityManager.checkAccess(Ljava/lang/ThreadGroup;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSecurityManager.checkAccess(methodCode, methodArgs, frame);
            }
            case "java/lang/SecurityManager.checkPropertyAccess(Ljava/lang/String;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSecurityManager.checkPropertyAccess(methodCode, methodArgs, frame);
            }
            case "java/lang/SecurityManager.checkPermission(Ljava/security/Permission;)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSecurityManager.checkPermission(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    private static Result getRootGroup(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result checkAccessThread(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result checkAccess(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result checkPropertyAccess(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result checkPermission(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }
}

