/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeString {
    public static final String TYPE = "java/lang/String";
    public static final String getBytes = "java/lang/String.getBytes()[B";
    public static final String intern = "java/lang/String.intern()Ljava/lang/String;";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/String.getBytes()[B": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeString.getBytes(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/String.intern()Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeString.intern(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result getBytes(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        String str;
        ObjectRef objectRef = methodArgs.objectRef;
        ObjectRef ref = null;
        if (objectRef != null && (str = frame.heap.runToString(objectRef)) != null) {
            byte[] bytes = str.getBytes();
            ref = frame.heap.newArray(bytes);
        }
        Result result = NativeMethod.result(methodCode, ref, frame);
        return result;
    }

    private static Result intern(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }
}

