/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeSystem {
    public static final String TYPE = "java/lang/System";
    public static final String arraycopy = "java/lang/System.arraycopy(Ljava/lang/Object;ILjava/lang/Object;II)V";
    public static final String identityHashCode = "java/lang/System.identityHashCode(Ljava/lang/Object;)I";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/System.arraycopy(Ljava/lang/Object;ILjava/lang/Object;II)V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSystem.arraycopy(methodCode, methodArgs, frame);
            }
            case "java/lang/System.identityHashCode(Ljava/lang/Object;)I": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeSystem.identityHashCode(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result arraycopy(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Object[] args = methodArgs.invokeArgs;
        ObjectRef srcObjectRef = (ObjectRef)args[0];
        int srcPos = (Integer)args[1];
        ObjectRef destObjectRef = (ObjectRef)args[2];
        int destPos = (Integer)args[3];
        int length = (Integer)args[4];
        if (length > 0 && frame.checkArray(srcObjectRef, srcPos) && frame.checkArray(srcObjectRef, srcPos + length - 1) && frame.checkArray(destObjectRef, destPos) && frame.checkArray(destObjectRef, destPos + length - 1)) {
            frame.heap.arraycopy(srcObjectRef, srcPos, destObjectRef, destPos, length);
        }
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }

    private static Result identityHashCode(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = (ObjectRef)methodArgs.invokeArgs[0];
        int hashCode = NativeSystem.identityHashCode(objectRef);
        Result result = NativeMethod.result(methodCode, hashCode, frame);
        return result;
    }

    public static int identityHashCode(ObjectRef objectRef) {
        int hashCode = 0;
        if (objectRef != null) {
            hashCode = objectRef.hashCode();
        }
        return hashCode;
    }
}

