/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.base.basic.AddressTool;
import java.math.BigInteger;
import java.util.Arrays;

public class ProgramTransfer {
    private byte[] from;
    private byte[] to;
    private BigInteger value;
    private int assetChainId;
    private int assetId;
    private long lockedTime;

    public ProgramTransfer() {
    }

    public ProgramTransfer(byte[] from, byte[] to, BigInteger value, int assetChainId, int assetId, long lockedTime) {
        this.from = from;
        this.to = to;
        this.value = value;
        this.assetChainId = assetChainId;
        this.assetId = assetId;
        this.lockedTime = lockedTime;
    }

    public void setFrom(byte[] from) {
        this.from = from;
    }

    public void setTo(byte[] to) {
        this.to = to;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public byte[] getFrom() {
        return this.from;
    }

    public byte[] getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public int getAssetChainId() {
        return this.assetChainId;
    }

    public void setAssetChainId(int assetChainId) {
        this.assetChainId = assetChainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public long getLockedTime() {
        return this.lockedTime;
    }

    public void setLockedTime(long lockedTime) {
        this.lockedTime = lockedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramTransfer that = (ProgramTransfer)o;
        if (this.assetChainId != that.assetChainId) {
            return false;
        }
        if (this.assetId != that.assetId) {
            return false;
        }
        if (this.lockedTime != that.lockedTime) {
            return false;
        }
        if (!Arrays.equals(this.from, that.from)) {
            return false;
        }
        if (!Arrays.equals(this.to, that.to)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.from);
        result = 31 * result + Arrays.hashCode(this.to);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.assetChainId;
        result = 31 * result + this.assetId;
        result = 31 * result + (int)(this.lockedTime ^ this.lockedTime >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"from\":").append(AddressTool.getStringAddressByBytes((byte[])this.from));
        sb.append(",\"to\":").append(AddressTool.getStringAddressByBytes((byte[])this.to));
        sb.append(",\"value\":").append(this.value);
        sb.append(",\"assetChainId\":").append(this.assetChainId);
        sb.append(",\"assetId\":").append(this.assetId);
        sb.append(",\"lockedTime\":").append(this.lockedTime);
        sb.append('}');
        return sb.toString();
    }
}

