/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.nuls.contract.vm.code.Descriptors;
import io.nuls.contract.vm.code.VariableType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ProgramDescriptors {
    public static final BiMap<String, String> DESCRIPTORS = HashBiMap.create();
    private static final Pattern PATTERN;

    public static String getNormalDesc(VariableType variableType) {
        Object desc = variableType.getDesc().replace("[", "");
        String desc1 = (String)Descriptors.DESCRIPTORS.inverse().get(desc);
        if (desc1 != null) {
            desc = desc1;
        } else {
            desc1 = (String)DESCRIPTORS.inverse().get(desc);
            if (desc1 != null) {
                desc = desc1;
            }
        }
        if (variableType.isArray()) {
            for (int i = 0; i < variableType.getDimensions(); ++i) {
                desc = (String)desc + "[]";
            }
        }
        return desc;
    }

    public static String parseDesc(String desc) {
        if (desc == null) {
            return null;
        }
        desc = desc.trim();
        StringBuilder sb = new StringBuilder();
        Matcher matcher = PATTERN.matcher(desc);
        if (matcher.matches()) {
            sb.append("(");
            String arg = matcher.group(1);
            if (StringUtils.isNotEmpty((CharSequence)arg)) {
                String[] args;
                for (String s : args = arg.split(", ")) {
                    sb.append(ProgramDescriptors.getDesc(s));
                }
            }
            sb.append(")");
            String returnArg = matcher.group(2);
            sb.append(ProgramDescriptors.getDesc(returnArg));
        } else {
            sb.append(desc);
        }
        return sb.toString();
    }

    private static String getDesc(String desc) {
        int dimensions = StringUtils.countMatches((CharSequence)desc, (CharSequence)"[]");
        desc = ((String)desc).replace("[]", "");
        String[] parts = ((String)desc).split(" ");
        String desc1 = (String)Descriptors.DESCRIPTORS.get(desc = parts[0]);
        if (desc1 != null) {
            desc = desc1;
        } else {
            desc1 = (String)DESCRIPTORS.get(desc);
            if (desc1 != null) {
                desc = desc1;
            }
        }
        for (int i = 0; i < dimensions; ++i) {
            desc = "[" + (String)desc;
        }
        return desc;
    }

    static {
        DESCRIPTORS.put((Object)"Boolean", (Object)"Ljava/lang/Boolean;");
        DESCRIPTORS.put((Object)"Byte", (Object)"Ljava/lang/Byte;");
        DESCRIPTORS.put((Object)"Short", (Object)"Ljava/lang/Short;");
        DESCRIPTORS.put((Object)"Character", (Object)"Ljava/lang/Character;");
        DESCRIPTORS.put((Object)"Integer", (Object)"Ljava/lang/Integer;");
        DESCRIPTORS.put((Object)"Long", (Object)"Ljava/lang/Long;");
        DESCRIPTORS.put((Object)"Float", (Object)"Ljava/lang/Float;");
        DESCRIPTORS.put((Object)"Double", (Object)"Ljava/lang/Double;");
        DESCRIPTORS.put((Object)"String", (Object)"Ljava/lang/String;");
        DESCRIPTORS.put((Object)"BigInteger", (Object)"Ljava/math/BigInteger;");
        DESCRIPTORS.put((Object)"BigDecimal", (Object)"Ljava/math/BigDecimal;");
        DESCRIPTORS.put((Object)"Address", (Object)"Lio/nuls/contract/sdk/Address;");
        PATTERN = Pattern.compile("^\\((.*)\\) return (.+)$");
    }
}

