/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program.impl;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.dto.BlockHeaderDto;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.VMContext;
import io.nuls.contract.vm.BigIntegerWrapper;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.VM;
import io.nuls.contract.vm.VMFactory;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.ClassCodeLoader;
import io.nuls.contract.vm.code.ClassCodes;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.exception.ErrorException;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeAddress;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeUtils;
import io.nuls.contract.vm.program.ProgramAccount;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.contract.vm.program.ProgramCreate;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.ProgramStatus;
import io.nuls.contract.vm.program.impl.ProgramChecker;
import io.nuls.contract.vm.program.impl.ProgramDescriptors;
import io.nuls.contract.vm.program.impl.ProgramInvoke;
import io.nuls.contract.vm.program.impl.ProgramTime;
import io.nuls.core.crypto.HexUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ethereum.config.CommonConfig;
import org.ethereum.config.DefaultConfig;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.AccountState;
import org.ethereum.core.Block;
import org.ethereum.core.Repository;
import org.ethereum.datasource.Source;
import org.ethereum.db.RepositoryRoot;
import org.ethereum.db.StateSource;
import org.ethereum.util.FastByteComparisons;
import org.ethereum.vm.DataWord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramExecutorImpl
implements ProgramExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProgramExecutorImpl.class);
    private final ProgramExecutorImpl parent;
    private final VMContext vmContext;
    private final Source<byte[], byte[]> source;
    private final Repository repository;
    private final byte[] prevStateRoot;
    private final long beginTime;
    private final Map<String, ProgramAccount> accounts;
    private long blockNumber;
    private long currentTime;
    private boolean revert;
    private Chain chain;
    private final Thread thread;
    private Map<String, Map<ObjectRef, Map<String, Object>>> contractObjects;
    private Map<String, Set<ObjectRef>> contractChanges;
    private Map<String, Map<String, Object>> contractArrays;
    private Map<String, BigIntegerWrapper> contractObjectRefCount;

    public ProgramExecutorImpl(VMContext vmContext, Chain chain) {
        this(null, vmContext, ProgramExecutorImpl.stateSource(chain), null, null, null, null);
        this.chain = chain;
    }

    private ProgramExecutorImpl(ProgramExecutorImpl programExecutor, VMContext vmContext, Source<byte[], byte[]> source, Repository repository, byte[] prevStateRoot, Map<String, ProgramAccount> accounts, Thread thread) {
        this.parent = programExecutor;
        this.vmContext = vmContext;
        this.source = source;
        this.repository = repository;
        this.prevStateRoot = prevStateRoot;
        this.beginTime = this.currentTime = System.currentTimeMillis();
        this.accounts = accounts;
        this.thread = thread;
    }

    public ProgramExecutor callProgramExecutor() {
        ProgramExecutorImpl programExecutor = new ProgramExecutorImpl(this, this.vmContext, this.source, this.repository, this.prevStateRoot, this.accounts, this.thread);
        programExecutor.contractObjects = this.contractObjects;
        programExecutor.contractChanges = this.contractChanges;
        programExecutor.contractArrays = this.contractArrays;
        programExecutor.contractObjectRefCount = this.contractObjectRefCount;
        return programExecutor;
    }

    @Override
    public int getCurrentChainId() {
        Chain c = this.getCurrentChain();
        if (c != null) {
            return c.getChainId();
        }
        return 0;
    }

    private Chain getCurrentChain() {
        ProgramExecutorImpl programExecutor = this;
        while (programExecutor.chain == null && (programExecutor = programExecutor.parent) != null) {
        }
        if (programExecutor != null) {
            return programExecutor.chain;
        }
        return null;
    }

    @Override
    public ProgramExecutor begin(byte[] prevStateRoot) {
        if (log.isDebugEnabled()) {
            log.debug("begin vm root: {}", (Object)HexUtil.encode((byte[])prevStateRoot));
        }
        RepositoryRoot repository = new RepositoryRoot(this.source, prevStateRoot);
        return new ProgramExecutorImpl(this, this.vmContext, this.source, repository, prevStateRoot, new HashMap<String, ProgramAccount>(), Thread.currentThread());
    }

    @Override
    public ProgramExecutor startTracking() {
        this.checkThread();
        if (log.isDebugEnabled()) {
            log.debug("startTracking");
        }
        Repository track = this.repository.startTracking();
        return new ProgramExecutorImpl(this, this.vmContext, this.source, track, null, new HashMap<String, ProgramAccount>(), this.thread);
    }

    @Override
    public void commit() {
        this.checkThread();
        if (!this.revert) {
            this.repository.commit();
            if (this.prevStateRoot == null) {
                if (this.parent.blockNumber == 0L) {
                    this.parent.blockNumber = this.blockNumber;
                }
                if (this.parent.blockNumber != this.blockNumber) {
                    throw new RuntimeException(String.format("must use the same block number, parent blockNumber is [%s], this blockNumber is [%s]", this.parent.blockNumber, this.blockNumber));
                }
            } else {
                if (this.vmContext != null) {
                    BlockHeaderDto blockHeaderDto;
                    try {
                        blockHeaderDto = this.vmContext.getBlockHeader(this.getCurrentChainId(), this.blockNumber);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    byte[] parentHash = HexUtil.decode((String)blockHeaderDto.getPreHash());
                    byte[] hash = HexUtil.decode((String)blockHeaderDto.getHash());
                    Block block = new Block(parentHash, hash, this.blockNumber);
                    this.getCurrentChain().getDefaultConfig().blockStore().saveBlock(block, BigInteger.ONE, true);
                    this.getCurrentChain().getDefaultConfig().pruneManager().blockCommitted(block.getHeader());
                }
                this.getCurrentChain().getCommonConfig().dbFlushManager().flush();
            }
            this.logTime("commit");
        }
    }

    public String getCrossTokenSystemContract() {
        return this.vmContext.getCrossTokenSystemContract();
    }

    @Override
    public byte[] getRoot() {
        this.checkThread();
        byte[] root = !this.revert ? this.repository.getRoot() : this.prevStateRoot;
        if (log.isDebugEnabled()) {
            log.debug("end vm root: {}, runtime: {}", (Object)HexUtil.encode((byte[])root), (Object)(System.currentTimeMillis() - this.beginTime));
        }
        return root;
    }

    @Override
    public ProgramResult create(ProgramCreate programCreate) {
        this.checkThread();
        ProgramInvoke programInvoke = new ProgramInvoke();
        programInvoke.setContractAddress(programCreate.getContractAddress());
        programInvoke.setAddress(NativeAddress.toString(programInvoke.getContractAddress()));
        programInvoke.setSender(programCreate.getSender());
        programInvoke.setPrice(programCreate.getPrice());
        programInvoke.setGasLimit(programCreate.getGasLimit());
        programInvoke.setValue(programCreate.getValue() != null ? programCreate.getValue() : BigInteger.ZERO);
        programInvoke.setNumber(programCreate.getNumber());
        programInvoke.setData(programCreate.getContractCode());
        programInvoke.setMethodName("<init>");
        programInvoke.setArgs(programCreate.getArgs() != null ? programCreate.getArgs() : new String[0][0]);
        programInvoke.setEstimateGas(programCreate.isEstimateGas());
        programInvoke.setCreate(true);
        programInvoke.setInternalCall(false);
        programInvoke.setViewMethod(false);
        programInvoke.setSenderPublicKey(programCreate.getSenderPublicKey());
        return this.execute(programInvoke);
    }

    @Override
    public ProgramResult call(ProgramCall programCall) {
        this.checkThread();
        ProgramInvoke programInvoke = new ProgramInvoke();
        programInvoke.setContractAddress(programCall.getContractAddress());
        programInvoke.setAddress(NativeAddress.toString(programInvoke.getContractAddress()));
        programInvoke.setSender(programCall.getSender());
        programInvoke.setPrice(programCall.getPrice());
        programInvoke.setGasLimit(programCall.getGasLimit());
        programInvoke.setValue(programCall.getValue() != null ? programCall.getValue() : BigInteger.ZERO);
        programInvoke.setMultyAssetValues(programCall.getMultyAssetValues());
        programInvoke.setNumber(programCall.getNumber());
        programInvoke.setMethodName(programCall.getMethodName());
        programInvoke.setMethodDesc(programCall.getMethodDesc());
        programInvoke.setArgs(programCall.getArgs() != null ? programCall.getArgs() : new String[0][0]);
        programInvoke.setEstimateGas(programCall.isEstimateGas());
        programInvoke.setCreate(false);
        programInvoke.setInternalCall(programCall.isInternalCall());
        programInvoke.setViewMethod(programCall.isViewMethod());
        programInvoke.setSenderPublicKey(programCall.getSenderPublicKey());
        ProgramResult result = this.execute(programInvoke);
        return result;
    }

    private ProgramResult checkExecute(ProgramInvoke programInvoke, MethodCode methodCode) {
        boolean isBalanceTriggerForConsensusContractMethod;
        String methodName = programInvoke.getMethodName();
        String methodDescBase = programInvoke.getMethodDesc();
        BigInteger transferValue = programInvoke.getValue();
        String contractAddress = programInvoke.getAddress();
        byte[] sender = programInvoke.getSender();
        if (methodCode == null) {
            return this.revert(String.format("can't find method %s%s", methodName, methodDescBase == null ? "" : methodDescBase));
        }
        if (!methodCode.isPublic) {
            return this.revert("can only invoke public method");
        }
        if (transferValue.compareTo(BigInteger.ZERO) > 0 && !methodCode.hasPayableAnnotation()) {
            return this.revert(String.format("contract[%s]'s method[%s] is not a payable method", contractAddress, methodCode.name));
        }
        List<ProgramMultyAssetValue> multyAssetValues = programInvoke.getMultyAssetValues();
        if (multyAssetValues != null && !multyAssetValues.isEmpty() && !methodCode.hasPayableMultyAssetAnnotation()) {
            return this.revert(String.format("contract[%s]'s method[%s] is not a payableMultyAsset method", contractAddress, methodCode.name));
        }
        boolean bl = isBalanceTriggerForConsensusContractMethod = "_payable".equals(methodName) && "(String[][] args) return void".equals(methodDescBase);
        if (isBalanceTriggerForConsensusContractMethod && sender != null) {
            return this.revert("can't invoke _payable(String[][] args) method");
        }
        if (!(methodCode.argsVariableType.size() == programInvoke.getArgs().length || isBalanceTriggerForConsensusContractMethod && programInvoke.getArgs().length > 0)) {
            return this.revert(String.format("require %s parameters in method [%s%s]", methodCode.argsVariableType.size(), methodCode.name, methodCode.normalDesc));
        }
        return null;
    }

    private ProgramResult execute(ProgramInvoke programInvoke) {
        if (programInvoke.getPrice() < 1L) {
            return this.revert("gas price must be greater than zero");
        }
        if (programInvoke.getGasLimit() < 1L) {
            return this.revert("gas must be greater than zero");
        }
        long maxGas = programInvoke.isViewMethod() ? this.vmContext.getCustomMaxViewGasLimit(this.getCurrentChainId()) : 10000000L;
        if (programInvoke.getGasLimit() > maxGas) {
            return this.revert("gas must be less than " + maxGas);
        }
        if (programInvoke.getValue().compareTo(BigInteger.ZERO) < 0) {
            return this.revert("value can't be less than zero");
        }
        this.blockNumber = programInvoke.getNumber();
        this.logTime("start");
        VM vm = null;
        try {
            boolean isUpgradedV240;
            AccountState accountState;
            Map<String, ClassCode> classCodes;
            byte[] contractAddressBytes = programInvoke.getContractAddress();
            byte[] sender = programInvoke.getSender();
            String contractAddress = programInvoke.getAddress();
            String methodName = programInvoke.getMethodName();
            String methodDescBase = programInvoke.getMethodDesc();
            byte[] contractCodeData = programInvoke.getData();
            BigInteger transferValue = programInvoke.getValue();
            List<ProgramMultyAssetValue> multyAssetValues = programInvoke.getMultyAssetValues();
            if (programInvoke.isCreate()) {
                if (contractCodeData == null) {
                    return this.revert("contract code can't be null");
                }
                classCodes = ClassCodeLoader.loadJarCache(contractCodeData);
                this.logTime("load new code");
                ProgramChecker.check(classCodes);
                this.logTime("check code");
                accountState = this.repository.getAccountState(contractAddressBytes);
                if (accountState != null) {
                    return this.revert(String.format("contract[%s] already exists", contractAddress));
                }
                accountState = this.repository.createAccount(contractAddressBytes, sender);
                this.logTime("new account state");
                this.repository.saveCode(contractAddressBytes, contractCodeData);
                this.logTime("save code");
            } else {
                if ("<init>".equals(methodName)) {
                    return this.revert("can't invoke <init> method");
                }
                accountState = this.repository.getAccountState(contractAddressBytes);
                if (accountState == null) {
                    return this.revert(String.format("contract[%s] does not exist", contractAddress));
                }
                this.logTime("load account state");
                if (accountState.getNonce().compareTo(BigInteger.ZERO) <= 0) {
                    return this.revert(String.format("contract[%s] has stopped", contractAddress));
                }
                byte[] codes = this.repository.getCode(contractAddressBytes);
                classCodes = ClassCodeLoader.loadJarCache(codes);
                this.logTime("load code");
            }
            vm = VMFactory.createVM();
            this.logTime("load vm");
            if (ProtocolGroupManager.getCurrentVersion((int)this.getCurrentChainId()) >= ContractContext.PROTOCOL_14) {
                vm.addGasUsed(contractCodeData == null ? 0L : (long)(contractCodeData.length * 7));
            }
            vm.setProgramExecutor(this);
            vm.heap.loadClassCodes(classCodes);
            boolean bl = isUpgradedV240 = ProtocolGroupManager.getCurrentVersion((int)this.getCurrentChainId()) >= ContractContext.UPDATE_VERSION_V240;
            if (isUpgradedV240) {
                if (this.contractObjects == null) {
                    this.contractObjects = new HashMap<String, Map<ObjectRef, Map<String, Object>>>();
                    this.contractObjects.put(contractAddress, vm.heap.objects);
                } else {
                    Map<ObjectRef, Map<String, Object>> objectRefMapMap = this.contractObjects.get(contractAddress);
                    if (objectRefMapMap != null) {
                        if (programInvoke.isInternalCall()) {
                            vm.heap.objects = objectRefMapMap;
                        }
                    } else {
                        this.contractObjects.put(contractAddress, vm.heap.objects);
                    }
                }
                if (this.contractArrays == null) {
                    this.contractArrays = new HashMap<String, Map<String, Object>>();
                    this.contractArrays.put(contractAddress, vm.heap.arrays);
                } else {
                    Map<String, Object> arraysMap = this.contractArrays.get(contractAddress);
                    if (arraysMap != null) {
                        if (programInvoke.isInternalCall()) {
                            vm.heap.arrays = arraysMap;
                        }
                    } else {
                        this.contractArrays.put(contractAddress, vm.heap.arrays);
                    }
                }
                if (this.contractChanges == null) {
                    this.contractChanges = new HashMap<String, Set<ObjectRef>>();
                    this.contractChanges.put(contractAddress, vm.heap.changes);
                } else {
                    Set<ObjectRef> changesObjectRefs = this.contractChanges.get(contractAddress);
                    if (changesObjectRefs != null) {
                        if (programInvoke.isInternalCall()) {
                            vm.heap.changes = changesObjectRefs;
                        }
                    } else {
                        this.contractChanges.put(contractAddress, vm.heap.changes);
                    }
                }
            }
            vm.methodArea.loadClassCodes(classCodes);
            this.logTime("load classes");
            ClassCode contractClassCode = ProgramExecutorImpl.getContractClassCode(classCodes);
            String methodDesc = ProgramDescriptors.parseDesc(methodDescBase);
            MethodCode methodCode = vm.methodArea.loadMethod(contractClassCode.name, methodName, methodDesc);
            if (ProtocolGroupManager.getCurrentVersion((int)this.getCurrentChainId()) >= ContractContext.PROTOCOL_19 && methodCode != null && !programInvoke.isCreate() && (methodCode.isConstructor || "<init>".equals(methodCode.name))) {
                return this.revert("can't invoke constructor");
            }
            ProgramResult checkExecute = this.checkExecute(programInvoke, methodCode);
            if (checkExecute != null) {
                if (ProtocolGroupManager.getCurrentVersion((int)this.getCurrentChainId()) >= ContractContext.PROTOCOL_14 && programInvoke.isCreate()) {
                    checkExecute.setGasUsed(vm.getGasUsed());
                }
                return checkExecute;
            }
            this.logTime("load method");
            ObjectRef objectRef = programInvoke.isCreate() ? vm.heap.newContract(contractAddressBytes, contractClassCode, this.repository) : vm.heap.loadContract(contractAddressBytes, contractClassCode, this.repository);
            if (isUpgradedV240) {
                if (this.contractObjectRefCount == null) {
                    this.contractObjectRefCount = new HashMap<String, BigIntegerWrapper>();
                    this.contractObjectRefCount.put(contractAddress, vm.heap.objectRefCount);
                } else {
                    BigIntegerWrapper objectRefCount = this.contractObjectRefCount.get(contractAddress);
                    if (objectRefCount != null) {
                        if (programInvoke.isInternalCall()) {
                            vm.heap.objectRefCount = objectRefCount;
                        }
                    } else {
                        this.contractObjectRefCount.put(contractAddress, vm.heap.objectRefCount);
                    }
                }
            }
            this.logTime("load contract ref");
            if (transferValue.compareTo(BigInteger.ZERO) > 0) {
                this.getAccount(contractAddressBytes, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID).addBalance(transferValue);
            }
            if (multyAssetValues != null && !multyAssetValues.isEmpty()) {
                for (ProgramMultyAssetValue assetValue : multyAssetValues) {
                    this.getAccount(contractAddressBytes, assetValue.getAssetChainId(), assetValue.getAssetId()).addBalance(assetValue.getValue());
                }
            }
            vm.setRepository(this.repository);
            vm.setGas(programInvoke.getGasLimit());
            if (ProtocolGroupManager.getCurrentVersion((int)this.getCurrentChainId()) < ContractContext.PROTOCOL_14) {
                vm.addGasUsed(contractCodeData == null ? 0L : (long)contractCodeData.length);
            }
            this.logTime("load end");
            vm.run(objectRef, methodCode, this.vmContext, programInvoke);
            this.logTime("run");
            ProgramResult programResult = new ProgramResult();
            programResult.setGasUsed(vm.getGasUsed());
            programResult.setDebugEvents(vm.getDebugEvents());
            Result vmResult = vm.getResult();
            Object resultValue = vmResult.getValue();
            if (vmResult.isError() || vmResult.isException()) {
                if (resultValue != null && resultValue instanceof ObjectRef) {
                    vm.setResult(new Result());
                    String error = vm.heap.runToString((ObjectRef)resultValue);
                    String stackTrace = vm.heap.stackTrace((ObjectRef)resultValue);
                    programResult.error(error);
                    programResult.setStackTrace(stackTrace);
                    programResult.getStackTraces().addFirst(stackTrace);
                    Iterator<String> descendingIterator = vm.getStackTraces().descendingIterator();
                    while (descendingIterator.hasNext()) {
                        programResult.getStackTraces().addFirst(descendingIterator.next());
                    }
                } else {
                    programResult.error(null);
                }
                this.logTime("contract exception");
                this.revert = true;
                programResult.setGasUsed(vm.getGasUsed());
                return programResult;
            }
            programResult.setTransfers(vm.getTransfers());
            programResult.setInternalCalls(vm.getInternalCalls());
            programResult.setEvents(vm.getEvents());
            programResult.setInvokeRegisterCmds(vm.getInvokeRegisterCmds());
            programResult.setOrderedInnerTxs(vm.getOrderedInnerTxs());
            programResult.setInternalCreates(vm.getInternalCreates());
            if (resultValue != null) {
                if (resultValue instanceof ObjectRef) {
                    String result = methodCode.hasJSONSerializableAnnotation() ? NativeUtils.objectRef2Json((ObjectRef)resultValue, vm.heap, vm.methodArea) : vm.heap.runToString((ObjectRef)resultValue);
                    programResult.setResult(result);
                } else {
                    programResult.setResult(resultValue.toString());
                }
            }
            if (methodCode.isPublic && methodCode.hasViewAnnotation()) {
                this.revert = true;
                programResult.view();
                programResult.setGasUsed(vm.getGasUsed());
                return programResult;
            }
            this.logTime("contract return");
            Map<DataWord, DataWord> contractState = vm.heap.contractState();
            this.logTime("contract state");
            for (Map.Entry<DataWord, DataWord> entry : contractState.entrySet()) {
                DataWord key = entry.getKey();
                DataWord value = entry.getValue();
                this.repository.addStorageRow(contractAddressBytes, key, value);
            }
            this.logTime("add contract state");
            if (programInvoke.isCreate()) {
                this.repository.setNonce(contractAddressBytes, BigInteger.ONE);
            }
            programResult.setGasUsed(vm.getGasUsed());
            programResult.setAccounts(this.accounts);
            return programResult;
        }
        catch (ErrorException e) {
            this.revert = true;
            ProgramResult programResult = new ProgramResult();
            programResult.setGasUsed(e.getGasUsed());
            this.logTime("error");
            if (vm != null) {
                programResult.setDebugEvents(vm.getDebugEvents());
            }
            return programResult.error(e.getMessage());
        }
        catch (Exception e) {
            Log.error(e);
            ProgramResult programResult = this.revert(e.getMessage());
            return programResult;
        }
    }

    private ProgramResult revert(String errorMessage) {
        return this.revert(errorMessage, null);
    }

    private ProgramResult revert(String errorMessage, String stackTrace) {
        this.revert = true;
        ProgramResult programResult = new ProgramResult();
        programResult.setStackTrace(stackTrace);
        this.logTime("revert");
        return programResult.revert(errorMessage);
    }

    @Override
    public ProgramResult stop(long blockNumber, byte[] address, byte[] sender) {
        this.checkThread();
        AccountState accountState = this.repository.getAccountState(address);
        if (accountState == null) {
            return this.revert("can't find contract");
        }
        if (!FastByteComparisons.equal(sender, accountState.getOwner())) {
            return this.revert("only the owner can stop the contract");
        }
        BigInteger balance = this.getTotalBalance(address, null, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
        if (BigInteger.ZERO.compareTo(balance) != 0) {
            return this.revert("contract balance is not zero");
        }
        if (BigInteger.ZERO.compareTo(accountState.getNonce()) >= 0) {
            return this.revert("contract has stopped");
        }
        this.blockNumber = blockNumber;
        this.repository.setNonce(address, BigInteger.ZERO);
        ProgramResult programResult = new ProgramResult();
        return programResult;
    }

    @Override
    public ProgramStatus status(byte[] address) {
        this.checkThread();
        this.revert = true;
        AccountState accountState = this.repository.getAccountState(address);
        if (accountState == null) {
            return ProgramStatus.not_found;
        }
        BigInteger nonce = this.repository.getNonce(address);
        if (BigInteger.ZERO.compareTo(nonce) >= 0) {
            return ProgramStatus.stop;
        }
        return ProgramStatus.normal;
    }

    public ProgramAccount getAccount(byte[] address, int assetChainId, int assetId) {
        String accountKey = ContractUtil.addressKey(address, assetChainId, assetId);
        ProgramAccount account = this.accounts.get(accountKey);
        if (account == null) {
            BigInteger freeze;
            BigInteger balance;
            String nonce = null;
            ContractBalance contractBalance = this.getBalance(address, assetChainId, assetId);
            if (contractBalance != null) {
                balance = contractBalance.getBalance();
                freeze = contractBalance.getFreeze();
                nonce = contractBalance.getNonce();
            } else {
                balance = BigInteger.ZERO;
                freeze = BigInteger.ZERO;
            }
            account = new ProgramAccount(address, balance, nonce, assetChainId, assetId);
            account.addFreeze(freeze);
            this.accounts.put(accountKey, account);
        }
        return account;
    }

    private ContractBalance getBalance(byte[] address, int assetChainId, int assetId) {
        ContractBalance contractBalance = null;
        if (this.vmContext != null) {
            contractBalance = this.vmContext.getBalance(this.getCurrentChainId(), assetChainId, assetId, address);
        }
        return contractBalance;
    }

    private BigInteger getTotalBalance(byte[] address, Long blockNumber, int assetChainId, int assetId) {
        BigInteger balance = BigInteger.ZERO;
        if (this.vmContext != null) {
            balance = this.vmContext.getTotalBalance(this.getCurrentChainId(), assetChainId, assetId, address);
        }
        return balance;
    }

    @Override
    public List<ProgramMethod> method(byte[] address) {
        this.checkThread();
        this.revert = true;
        byte[] codes = this.repository.getCode(address);
        return this.jarMethod(codes);
    }

    @Override
    public byte[] contractCode(byte[] address) {
        this.checkThread();
        this.revert = true;
        byte[] codes = this.repository.getCode(address);
        return codes;
    }

    @Override
    public byte[] contractCodeHash(byte[] address) {
        this.checkThread();
        this.revert = true;
        byte[] codes = this.repository.getCodeHash(address);
        return codes;
    }

    @Override
    public List<ProgramMethod> jarMethod(byte[] jarData) {
        this.revert = true;
        if (jarData == null || jarData.length < 1) {
            return new ArrayList<ProgramMethod>();
        }
        Map<String, ClassCode> classCodes = ClassCodeLoader.loadJarCache(jarData);
        return ProgramExecutorImpl.getProgramMethods(classCodes);
    }

    private void checkThread() {
    }

    private static List<ProgramMethod> getProgramMethods(Map<String, ClassCode> classCodes) {
        List<ProgramMethod> programMethods = ProgramExecutorImpl.getProgramMethodCodes(classCodes).stream().map(methodCode -> {
            ProgramMethod method = new ProgramMethod();
            method.setName(methodCode.name);
            method.setDesc(methodCode.normalDesc);
            method.setArgs(methodCode.args);
            method.setReturnArg(methodCode.returnArg);
            method.setView(methodCode.hasViewAnnotation());
            method.setPayable(methodCode.hasPayableAnnotation());
            method.setPayableMultyAsset(methodCode.hasPayableMultyAssetAnnotation());
            method.setJsonSerializable(methodCode.hasJSONSerializableAnnotation());
            method.setEvent(false);
            return method;
        }).collect(Collectors.toList());
        programMethods.addAll(ProgramExecutorImpl.getEventConstructor(classCodes));
        return programMethods;
    }

    public static List<MethodCode> getProgramMethodCodes(Map<String, ClassCode> classCodes) {
        LinkedHashMap<String, MethodCode> methodCodes = new LinkedHashMap<String, MethodCode>();
        ClassCode contractClassCode = ProgramExecutorImpl.getContractClassCode(classCodes);
        if (contractClassCode != null) {
            ProgramExecutorImpl.contractMethods(methodCodes, classCodes, contractClassCode, false);
        }
        return methodCodes.values().stream().collect(Collectors.toList());
    }

    private static ClassCode getContractClassCode(Map<String, ClassCode> classCodes) {
        return classCodes.values().stream().filter(classCode -> classCode.interfaces.contains("io/nuls/contract/sdk/Contract")).findFirst().orElse(null);
    }

    private static void contractMethods(Map<String, MethodCode> methodCodes, Map<String, ClassCode> classCodes, ClassCode classCode, boolean isSupperClass) {
        classCode.methods.stream().filter(methodCode -> methodCode.isPublic && !methodCode.isAbstract).forEach(methodCode -> {
            if (!(isSupperClass && "<init>".equals(methodCode.name) || "<clinit>".equals(methodCode.name))) {
                String name = methodCode.name + "." + methodCode.desc;
                methodCodes.putIfAbsent(name, (MethodCode)methodCode);
            }
        });
        String superName = classCode.superName;
        if (StringUtils.isNotEmpty((CharSequence)superName)) {
            classCodes.values().stream().filter(code -> superName.equals(code.name)).findFirst().ifPresent(code -> ProgramExecutorImpl.contractMethods(methodCodes, classCodes, code, true));
        }
    }

    private static Set<ProgramMethod> getEventConstructor(Map<String, ClassCode> classCodes) {
        LinkedHashMap methodCodes = new LinkedHashMap();
        ProgramExecutorImpl.getEventClassCodes(classCodes).forEach(classCode -> {
            for (MethodCode methodCode : classCode.methods) {
                if (!methodCode.isConstructor) continue;
                methodCodes.put(methodCode.fullName, methodCode);
            }
        });
        return methodCodes.values().stream().filter(methodCode -> methodCode.isConstructor).map(methodCode -> {
            ProgramMethod method = new ProgramMethod();
            method.setName(methodCode.classCode.simpleName);
            method.setDesc(methodCode.normalDesc);
            method.setArgs(methodCode.args);
            method.setReturnArg(methodCode.returnArg);
            method.setView(false);
            method.setPayable(false);
            method.setPayableMultyAsset(false);
            method.setJsonSerializable(false);
            method.setEvent(true);
            return method;
        }).collect(Collectors.toSet());
    }

    private static List<ClassCode> getEventClassCodes(Map<String, ClassCode> classCodes) {
        ClassCodes allCodes = new ClassCodes(classCodes);
        return classCodes.values().stream().filter(classCode -> !classCode.isAbstract && allCodes.instanceOf((ClassCode)classCode, "io/nuls/contract/sdk/Event")).collect(Collectors.toList());
    }

    private static Source<byte[], byte[]> stateSource(Chain chain) {
        SystemProperties config = SystemProperties.getDefault();
        CommonConfig commonConfig = CommonConfig.newInstance(chain.getChainId());
        chain.setCommonConfig(commonConfig);
        DefaultConfig defaultConfig = DefaultConfig.newInstance(commonConfig);
        chain.setDefaultConfig(defaultConfig);
        StateSource stateSource = commonConfig.stateSource();
        stateSource.setConfig(config);
        stateSource.setCommonConfig(commonConfig);
        return stateSource;
    }

    public void logTime(String message) {
        if (log.isDebugEnabled()) {
            long currentTime = System.currentTimeMillis();
            long step = currentTime - this.currentTime;
            long runtime = currentTime - this.beginTime;
            this.currentTime = currentTime;
            ProgramTime.cache.putIfAbsent(message, new ProgramTime());
            ProgramTime time = ProgramTime.cache.get(message);
            time.add(step);
            log.debug("[{}] runtime: {}ms, step: {}ms, {}", new Object[]{message, runtime, step, time});
        }
    }
}

