/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.util;

import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.util.Utils;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;

public class CloneUtils {
    public static void clone(Map<String, Object> source, Map<String, Object> target) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            Object newObject = CloneUtils.cloneObject(object);
            target.put(key, newObject);
        }
    }

    public static Map<String, Object> clone(Map<String, Object> source) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>(Utils.hashMapInitialCapacity(source.size()));
        CloneUtils.clone(source, target);
        return target;
    }

    public static Object cloneObject(Object object) {
        Object newObject = null;
        if (object == null) {
            newObject = null;
        } else if (object instanceof Integer) {
            newObject = (int)((Integer)object);
        } else if (object instanceof Long) {
            newObject = (long)((Long)object);
        } else if (object instanceof Float) {
            newObject = Float.valueOf(((Float)object).floatValue());
        } else if (object instanceof Double) {
            newObject = (double)((Double)object);
        } else if (object instanceof Boolean) {
            newObject = (boolean)((Boolean)object);
        } else if (object instanceof Byte) {
            newObject = (byte)((Byte)object);
        } else if (object instanceof Character) {
            newObject = Character.valueOf(((Character)object).charValue());
        } else if (object instanceof Short) {
            newObject = (short)((Short)object);
        } else if (object instanceof String) {
            newObject = object;
        } else if (object instanceof ObjectRef) {
            newObject = object;
        } else if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            Object array = Array.newInstance(object.getClass().getComponentType(), length);
            System.arraycopy(object, 0, array, 0, length);
            newObject = array;
        } else {
            newObject = object;
        }
        return newObject;
    }
}

