/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain;

import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.ChainManagerCall;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;

@Component
public class CrossChainBootStrap
implements INulsCoresBootstrap {
    @Autowired
    private NulsCoresConfig nulsCrossChainConfig;
    @Autowired
    private RegisteredCrossChainService registeredCrossChainService;
    @Autowired
    private ChainManager chainManager;

    @Override
    public int order() {
        return 7;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.CC.name, "1.0");
    }

    public void init() {
        try {
            this.initDB();
            this.chainManager.initChain();
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    @Override
    public void onDependenciesReady() {
        try {
            this.chainManager.runChain();
            for (Chain chain : this.chainManager.getChainMap().values()) {
                if (chain.isMainChain()) continue;
                NetWorkCall.activeCrossNet(chain.getChainId(), chain.getConfig().getMaxOutAmount(), chain.getConfig().getMaxInAmount(), this.nulsCrossChainConfig.getCrossSeedIps());
            }
            if (this.nulsCrossChainConfig.isMainNet()) {
                RegisteredChainMessage registeredChainMessage = this.registeredCrossChainService.get();
                if (registeredChainMessage != null && registeredChainMessage.getChainInfoList() != null) {
                    this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
                } else {
                    registeredChainMessage = ChainManagerCall.getRegisteredChainInfo(this.chainManager);
                    this.registeredCrossChainService.save(registeredChainMessage);
                    this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
                }
            }
            this.chainManager.registerContractTx();
            ConfigurationLoader configurationLoader = (ConfigurationLoader)SpringLiteContext.getBean(ConfigurationLoader.class);
            this.nulsCrossChainConfig.setSeedNodeList(Arrays.stream(configurationLoader.getValue("consensus", "seedNodes").split(",")).collect(Collectors.toSet()));
            Log.info((String)"cc onDependenciesReady");
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    private void initDB() throws Exception {
        RocksDBService.init((String)(this.nulsCrossChainConfig.getDataPath() + File.separator + ModuleE.CC.name));
        RocksDBService.createTable((String)"language");
        RocksDBService.createTable((String)"config");
        RocksDBService.createTable((String)"local_verifier");
        RocksDBService.createTable((String)"registered_chain");
    }
}

