/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.crosschain.base.message.base.BaseMessage;
import java.io.IOException;
import java.util.Arrays;

public class BroadCtxSignMessage
extends BaseMessage {
    private NulsHash localHash;
    private byte[] signature;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.localHash.getBytes());
        stream.writeBytesWithLength(this.signature);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.localHash = byteBuffer.readHash();
        this.signature = byteBuffer.readByLengthByte();
    }

    public int size() {
        int size = 0;
        size += 32;
        return size += SerializeUtils.sizeOfBytes((byte[])this.signature);
    }

    public NulsHash getLocalHash() {
        return this.localHash;
    }

    public void setLocalHash(NulsHash localHash) {
        this.localHash = localHash;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BroadCtxSignMessage)) {
            return false;
        }
        return Arrays.equals(this.getSignature(), ((BroadCtxSignMessage)((Object)obj)).getSignature());
    }
}

