/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.crosschain.base.message.base.BaseMessage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class CtxFullSignMessage
extends BaseMessage {
    private NulsHash localTxHash;
    private byte[] transactionSignature;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.localTxHash.getBytes());
        stream.writeBytesWithLength(this.transactionSignature);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.localTxHash = byteBuffer.readHash();
        this.transactionSignature = byteBuffer.readByLengthByte();
    }

    public int size() {
        int size = 0;
        size += 32;
        return size += SerializeUtils.sizeOfBytes((byte[])this.transactionSignature);
    }

    public byte[] getTransactionSignature() {
        return this.transactionSignature;
    }

    public void setTransactionSignature(byte[] transactionSignature) {
        this.transactionSignature = transactionSignature;
    }

    public NulsHash getLocalTxHash() {
        return this.localTxHash;
    }

    public void setLocalTxHash(NulsHash localTxHash) {
        this.localTxHash = localTxHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CtxFullSignMessage that = (CtxFullSignMessage)((Object)o);
        return Objects.equals(this.localTxHash, that.localTxHash) && Arrays.equals(this.transactionSignature, that.transactionSignature);
    }

    public int hashCode() {
        int result = Objects.hash(this.localTxHash);
        result = 31 * result + Arrays.hashCode(this.transactionSignature);
        return result;
    }
}

