/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.crosschain.base.message.BroadCtxSignMessage;
import io.nuls.crosschain.base.service.ProtocolService;
import io.nuls.crosschain.base.utils.HashSetTimeDuplicateProcessor;

@Component(value="BroadCtxSignHandlerV1")
public class BroadCtxSignHandler
implements MessageProcessor {
    @Autowired
    private ProtocolService protocolService;
    private HashSetTimeDuplicateProcessor processor = new HashSetTimeDuplicateProcessor(1000, 300000L);

    public String getCmd() {
        return "recvCtxSign";
    }

    public void process(int chainId, String nodeId, String message) {
        BroadCtxSignMessage realMessage = (BroadCtxSignMessage)((Object)RPCUtil.getInstanceRpcStr((String)message, BroadCtxSignMessage.class));
        if (realMessage == null || realMessage.getLocalHash() == null) {
            return;
        }
        String hash = realMessage.getLocalHash().toHex();
        if (this.processor.insertAndCheck(nodeId + hash)) {
            this.protocolService.receiveCtxSign(chainId, nodeId, realMessage);
        }
    }
}

