/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.crosschain.base.message.base.BaseMessage;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RegisteredChainChangeData
extends BaseMessage {
    private int registerChainId;
    private int type;
    private List<ChainInfo> chainInfoList;

    public RegisteredChainChangeData() {
    }

    public RegisteredChainChangeData(int registerChainId, int type, List<ChainInfo> chainInfoList) {
        this.registerChainId = registerChainId;
        this.type = type;
        this.chainInfoList = chainInfoList;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.registerChainId);
        stream.writeUint16(this.type);
        int count = this.chainInfoList == null ? 0 : this.chainInfoList.size();
        stream.writeVarInt(count);
        if (this.chainInfoList != null) {
            for (ChainInfo chainInfo : this.chainInfoList) {
                stream.writeNulsData((BaseNulsData)chainInfo);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.registerChainId = byteBuffer.readUint16();
        this.type = byteBuffer.readUint16();
        int count = (int)byteBuffer.readVarInt();
        if (count > 0) {
            ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
            for (int i = 0; i < count; ++i) {
                chainInfoList.add((ChainInfo)byteBuffer.readNulsData((BaseNulsData)new ChainInfo()));
            }
            this.chainInfoList = chainInfoList;
        }
    }

    public int size() {
        int size = SerializeUtils.sizeOfUint16() * 2;
        size += SerializeUtils.sizeOfVarInt((Integer)(this.chainInfoList == null ? 0 : this.chainInfoList.size()));
        if (this.chainInfoList != null && this.chainInfoList.size() > 0) {
            for (ChainInfo chainInfo : this.chainInfoList) {
                size += SerializeUtils.sizeOfNulsData((NulsData)chainInfo);
            }
        }
        return size;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegisteredChainMessage) {
            RegisteredChainMessage message = (RegisteredChainMessage)((Object)obj);
            try {
                if (this.getChainInfoList() == null && message.getChainInfoList() == null) {
                    return true;
                }
                if (this.getChainInfoList() == null && message.getChainInfoList() != null) {
                    return false;
                }
                if (this.getChainInfoList() != null && message.getChainInfoList() == null) {
                    return false;
                }
                if (this.getChainInfoList().size() != message.getChainInfoList().size()) {
                    return false;
                }
                if (Arrays.equals(this.serialize(), message.serialize())) {
                    return true;
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e);
            }
        }
        return false;
    }

    public List<ChainInfo> getChainInfoList() {
        return this.chainInfoList;
    }

    public int getRegisterChainId() {
        return this.registerChainId;
    }

    public void setRegisterChainId(int registerChainId) {
        this.registerChainId = registerChainId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setChainInfoList(List<ChainInfo> chainInfoList) {
        this.chainInfoList = chainInfoList;
    }

    public void addChainInfo(ChainInfo chainInfo) {
        this.chainInfoList.remove((Object)chainInfo);
        this.chainInfoList.add(chainInfo);
    }
}

