/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.crosschain.base.constant.CrossChainErrorCode;
import io.nuls.crosschain.base.message.BroadCtxHashMessage;
import io.nuls.crosschain.base.message.BroadCtxSignMessage;
import io.nuls.crosschain.base.message.CtxStateMessage;
import io.nuls.crosschain.base.message.GetCirculationMessage;
import io.nuls.crosschain.base.message.GetCtxStateMessage;
import io.nuls.crosschain.base.message.GetOtherCtxMessage;
import io.nuls.crosschain.base.message.NewOtherCtxMessage;
import io.nuls.crosschain.base.service.ProtocolService;
import java.util.Map;

@Component
public class CrossChainProtocolCmd
extends BaseCmd {
    @Autowired
    private ProtocolService service;

    @CmdAnnotation(cmd="getOtherCtx", version=1.0, description="Cross chain nodes obtain complete transactions from this node/Cross-chain nodes obtain complete transactions from their own nodes")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response getOtherCtx(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        GetOtherCtxMessage message = new GetOtherCtxMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.getOtherCtx(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="getCtxState", version=1.0, description="Obtaining Cross Chain Transaction Processing Status/Getting the state of cross-chain transaction processing")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response getCtxState(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        GetCtxStateMessage message = new GetCtxStateMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.getCtxState(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="recvCtxState", version=1.0, description="Cross chain transaction processing status messages/receive cross transaction state")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response recvCtxState(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        CtxStateMessage message = new CtxStateMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.receiveCtxState(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="getCirculat", version=1.0, description="Query the asset information message of this chain/get chain circulation")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response getCirculat(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        GetCirculationMessage message = new GetCirculationMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.getCirculation(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="recvOtherCtx", version=1.0, description="Receive complete transactions broadcasted across chain nodes/Receiving Complete Transactions for Cross-Chain Node Broadcasting")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response recvOtherCtx(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        NewOtherCtxMessage message = new NewOtherCtxMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.receiveOtherCtx(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="recvCtxHash", version=1.0, description="Receive transactions broadcasted across chain nodesHash/Transaction Hash receiving cross-link node broadcasting")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response recvCtxHash(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        BroadCtxHashMessage message = new BroadCtxHashMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.receiveCtxHash(chainId, nodeId, message);
        return this.success();
    }

    @CmdAnnotation(cmd="recvCtxSign", version=1.0, description="Receive transaction signatures broadcasted by nodes within the chain/Transaction signature for broadcasting in receiving chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="nodeId", parameterType="String", parameterDes="nodeIP"), @Parameter(parameterName="messageBody", parameterType="String", parameterDes="Message Body")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response recvCtxSign(Map<String, Object> params) {
        int chainId = Integer.parseInt(params.get("chainId").toString());
        String nodeId = params.get("nodeId").toString();
        byte[] decode = RPCUtil.decode((String)params.get("messageBody").toString());
        BroadCtxSignMessage message = new BroadCtxSignMessage();
        try {
            message.parse(new NulsByteBuffer(decode));
        }
        catch (NulsException e) {
            return this.failed(CrossChainErrorCode.PARAMETER_ERROR);
        }
        this.service.receiveCtxSign(chainId, nodeId, message);
        return this.success();
    }
}

