/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.model.bo;

import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.core.thread.commom.NulsThreadFactory;
import io.nuls.crosschain.model.bo.NodeType;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.model.bo.message.WaitBroadSignMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Chain {
    private ConfigBean config;
    private Map<NulsHash, List<NodeType>> otherHashNodeIdMap;
    private Map<NulsHash, Integer> otherCtxStageMap;
    private Map<NulsHash, List<Byte>> ctxStateMap;
    private Map<NulsHash, Set<WaitBroadSignMessage>> waitBroadSignMap;
    private LinkedBlockingQueue<UntreatedMessage> hashMessageQueue;
    private LinkedBlockingQueue<UntreatedMessage> signMessageByzantineQueue;
    private LinkedBlockingQueue<UntreatedMessage> otherCtxMessageQueue;
    private LinkedBlockingQueue<UntreatedMessage> getCtxStateQueue;
    private LinkedBlockingQueue<UntreatedMessage> txFullSignMessageQueue;
    private final ExecutorService threadPool = ThreadUtils.createThreadPool((int)8, (int)100, (NulsThreadFactory)new NulsThreadFactory("CrossChainProcessor"));
    private NulsLogger logger;
    private Map<NulsHash, List<UntreatedMessage>> futureMessageMap;
    private List<String> verifierList;
    private boolean mainChain = false;
    private long lastChangeHeight = 0L;
    private Transaction verifierChangeTx = null;
    private Map<Integer, Long> crossChainTxMap;
    private Map<Integer, Long> verifierChangeTxMap;
    private final ReentrantReadWriteLock switchVerifierLock = new ReentrantReadWriteLock();
    private int syncStatus = 0;
    private final ExecutorService crossTxThreadPool = ThreadUtils.createThreadPool((int)4, (int)10000, (NulsThreadFactory)new NulsThreadFactory("CROSS_TX_THREAD_POOL"));

    public Chain() {
        this.otherHashNodeIdMap = new ConcurrentHashMap<NulsHash, List<NodeType>>();
        this.ctxStateMap = new ConcurrentHashMap<NulsHash, List<Byte>>();
        this.otherCtxStageMap = new ConcurrentHashMap<NulsHash, Integer>();
        this.waitBroadSignMap = new ConcurrentHashMap<NulsHash, Set<WaitBroadSignMessage>>();
        this.hashMessageQueue = new LinkedBlockingQueue();
        this.signMessageByzantineQueue = new LinkedBlockingQueue();
        this.otherCtxMessageQueue = new LinkedBlockingQueue();
        this.getCtxStateQueue = new LinkedBlockingQueue();
        this.txFullSignMessageQueue = new LinkedBlockingQueue();
        this.futureMessageMap = new ConcurrentHashMap<NulsHash, List<UntreatedMessage>>();
        this.verifierList = new ArrayList<String>();
        this.crossChainTxMap = new ConcurrentHashMap<Integer, Long>();
        this.verifierChangeTxMap = new ConcurrentHashMap<Integer, Long>();
    }

    public int getChainId() {
        return this.config.getChainId();
    }

    public ConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(ConfigBean config) {
        this.config = config;
    }

    public Map<NulsHash, List<Byte>> getCtxStateMap() {
        return this.ctxStateMap;
    }

    public void setCtxStateMap(Map<NulsHash, List<Byte>> ctxStateMap) {
        this.ctxStateMap = ctxStateMap;
    }

    public NulsLogger getLogger() {
        return this.logger;
    }

    public void setLogger(NulsLogger logger) {
        this.logger = logger;
    }

    public boolean isMainChain() {
        return this.mainChain;
    }

    public void setMainChain(boolean mainChain) {
        this.mainChain = mainChain;
    }

    public Map<NulsHash, Set<WaitBroadSignMessage>> getWaitBroadSignMap() {
        return this.waitBroadSignMap;
    }

    public void setWaitBroadSignMap(Map<NulsHash, Set<WaitBroadSignMessage>> waitBroadSignMap) {
        this.waitBroadSignMap = waitBroadSignMap;
    }

    public LinkedBlockingQueue<UntreatedMessage> getHashMessageQueue() {
        return this.hashMessageQueue;
    }

    public void setHashMessageQueue(LinkedBlockingQueue<UntreatedMessage> hashMessageQueue) {
        this.hashMessageQueue = hashMessageQueue;
    }

    public LinkedBlockingQueue<UntreatedMessage> getSignMessageByzantineQueue() {
        return this.signMessageByzantineQueue;
    }

    public void setSignMessageByzantineQueue(LinkedBlockingQueue<UntreatedMessage> signMessageByzantineQueue) {
        this.signMessageByzantineQueue = signMessageByzantineQueue;
    }

    public LinkedBlockingQueue<UntreatedMessage> getOtherCtxMessageQueue() {
        return this.otherCtxMessageQueue;
    }

    public void setOtherCtxMessageQueue(LinkedBlockingQueue<UntreatedMessage> otherCtxMessageQueue) {
        this.otherCtxMessageQueue = otherCtxMessageQueue;
    }

    public Map<NulsHash, List<NodeType>> getOtherHashNodeIdMap() {
        return this.otherHashNodeIdMap;
    }

    public void setOtherHashNodeIdMap(Map<NulsHash, List<NodeType>> otherHashNodeIdMap) {
        this.otherHashNodeIdMap = otherHashNodeIdMap;
    }

    public Map<NulsHash, Integer> getOtherCtxStageMap() {
        return this.otherCtxStageMap;
    }

    public void setOtherCtxStageMap(Map<NulsHash, Integer> otherCtxStageMap) {
        this.otherCtxStageMap = otherCtxStageMap;
    }

    public LinkedBlockingQueue<UntreatedMessage> getGetCtxStateQueue() {
        return this.getCtxStateQueue;
    }

    public void setGetCtxStateQueue(LinkedBlockingQueue<UntreatedMessage> getCtxStateQueue) {
        this.getCtxStateQueue = getCtxStateQueue;
    }

    public Map<NulsHash, List<UntreatedMessage>> getFutureMessageMap() {
        return this.futureMessageMap;
    }

    public List<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(List<String> verifierList) {
        this.verifierList = verifierList;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public Transaction getVerifierChangeTx() {
        return this.verifierChangeTx;
    }

    public void setVerifierChangeTx(Transaction verifierChangeTx) {
        this.verifierChangeTx = verifierChangeTx;
    }

    public Map<Integer, Long> getCrossChainTxMap() {
        return this.crossChainTxMap;
    }

    public void setCrossChainTxMap(Map<Integer, Long> crossChainTxMap) {
        this.crossChainTxMap = crossChainTxMap;
    }

    public Map<Integer, Long> getVerifierChangeTxMap() {
        return this.verifierChangeTxMap;
    }

    public void setVerifierChangeTxMap(Map<Integer, Long> verifierChangeTxMap) {
        this.verifierChangeTxMap = verifierChangeTxMap;
    }

    public ExecutorService getCrossTxThreadPool() {
        return this.crossTxThreadPool;
    }

    public ReentrantReadWriteLock getSwitchVerifierLock() {
        return this.switchVerifierLock;
    }

    public long getLastChangeHeight() {
        return this.lastChangeHeight;
    }

    public void setLastChangeHeight(long lastChangeHeight) {
        this.lastChangeHeight = lastChangeHeight;
    }

    public int getSyncStatus() {
        return this.syncStatus;
    }

    public void setSyncStatus(int syncStatus) {
        this.syncStatus = syncStatus;
    }

    public synchronized Transaction isExistVerifierChangeTx(Transaction verifierChangeTx) {
        if (this.verifierChangeTx == null) {
            this.verifierChangeTx = verifierChangeTx;
            return null;
        }
        return this.verifierChangeTx;
    }

    public LinkedBlockingQueue<UntreatedMessage> getTxFullSignMessageQueue() {
        return this.txFullSignMessageQueue;
    }
}

