/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.model.bo.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class CrossTxData
extends BaseNulsData {
    private int chainId;
    private NulsHash originalTxHash;

    public CrossTxData() {
    }

    public CrossTxData(NulsHash originalTxHash, int chainId) {
        this.originalTxHash = originalTxHash;
        this.chainId = chainId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossTxData)) {
            return false;
        }
        CrossTxData crossTxData = (CrossTxData)((Object)obj);
        if (this.chainId != crossTxData.getChainId()) {
            return false;
        }
        return crossTxData.getOriginalTxHash().equals((Object)this.originalTxHash);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.write(this.originalTxHash.getBytes());
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.originalTxHash = byteBuffer.readHash();
    }

    public int size() {
        int s = 0;
        s += SerializeUtils.sizeOfUint16();
        return s += 32;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public NulsHash getOriginalTxHash() {
        return this.originalTxHash;
    }

    public void setOriginalTxHash(NulsHash originalTxHash) {
        this.originalTxHash = originalTxHash;
    }
}

