/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.crosschain.rpc.call.CommonCall;
import io.nuls.crosschain.utils.CommonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountCall {
    public static String getPrikey(String address, String password) throws NulsException {
        try {
            int chainId = AddressTool.getChainIdByAddress((String)address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("address", address);
            params.put("password", password);
            HashMap result = (HashMap)CommonCall.request(ModuleE.AC.abbr, "ac_getPriKeyByAddress", params);
            return (String)result.get("priKey");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static boolean isEncrypted(String address) throws NulsException {
        try {
            int chainId = AddressTool.getChainIdByAddress((String)address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("address", address);
            HashMap result = (HashMap)CommonCall.request(ModuleE.AC.abbr, "ac_isEncrypted", params);
            return (Boolean)result.get("value");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static MultiSigAccount getMultiSigAccount(byte[] multiSignAddress) throws NulsException {
        try {
            String address = AddressTool.getStringAddressByBytes((byte[])multiSignAddress);
            int chainId = AddressTool.getChainIdByAddress((String)address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("address", address);
            HashMap result = (HashMap)CommonCall.request(ModuleE.AC.abbr, "ac_getMultiSignAccount", params);
            String mAccountStr = (String)result.get("value");
            return null == mAccountStr ? null : (MultiSigAccount)CommonUtil.getInstanceRpcStr(mAccountStr, MultiSigAccount.class);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static P2PHKSignature signDigest(String address, String password, byte[] data) throws NulsException {
        try {
            int chainId = AddressTool.getChainIdByAddress((String)address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("address", address);
            params.put("password", password);
            params.put("data", RPCUtil.encode((byte[])data));
            HashMap result = (HashMap)CommonCall.request(ModuleE.AC.abbr, "ac_signDigest", params);
            String signatureStr = (String)result.get("signature");
            return (P2PHKSignature)CommonUtil.getInstanceRpcStr(signatureStr, P2PHKSignature.class);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static void addAddressPrefix(List<Map<String, Object>> prefixList) throws NulsException {
        try {
            HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>(2);
            params.put("prefixList", prefixList);
            CommonCall.request(ModuleE.AC.abbr, "ac_addAddressPrefix", params);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

