/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.crosschain.base.message.CirculationMessage;
import io.nuls.crosschain.base.model.bo.AssetInfo;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.Circulation;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.rpc.call.CommonCall;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChainManagerCall {
    public static boolean verifyCtxAsset(int chainId, Transaction tx) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            HashMap result = (HashMap)CommonCall.request(ModuleE.CM.abbr, "cm_assetCirculateValidator", params);
            return (Boolean)result.get("value");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static boolean ctxAssetCirculateCommit(int chainId, List<String> txList, String blockHeader) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("txList", txList);
            params.put("blockHeader", blockHeader);
            HashMap result = (HashMap)CommonCall.request(ModuleE.CM.abbr, "cm_assetCirculateCommit", params);
            return (Boolean)result.get("value");
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    public static boolean ctxAssetCirculateRollback(int chainId, List<String> txList, String blockHeader) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("txList", txList);
            params.put("blockHeader", blockHeader);
            HashMap result = (HashMap)CommonCall.request(ModuleE.CM.abbr, "cm_assetCirculateRollBack", params);
            return (Boolean)result.get("value");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static void sendCirculation(int chainId, CirculationMessage message) throws NulsException {
        try {
            ArrayList assertList = new ArrayList();
            if (message.getCirculationList() != null && message.getCirculationList().size() > 0) {
                for (Circulation circulation : message.getCirculationList()) {
                    HashMap<String, Number> assertInfoMap = new HashMap<String, Number>(4);
                    assertInfoMap.put("assetId", circulation.getAssetId());
                    assertInfoMap.put("availableAmount", circulation.getAvailableAmount());
                    assertInfoMap.put("freeze", circulation.getFreeze());
                    assertList.add(assertInfoMap);
                }
            }
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("assets", assertList);
            CommonCall.request(ModuleE.CM.abbr, "updateChainAsset", params);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static RegisteredChainMessage getRegisteredChainInfo(ChainManager chainManager) throws NulsException {
        try {
            HashMap result = (HashMap)CommonCall.request(ModuleE.CM.abbr, "getCrossChainInfos", new HashMap(2));
            ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
            List chainInfos = (List)result.get("chainInfos");
            if (chainInfos != null && chainInfos.size() > 0) {
                block2: for (Map chainInfoMap : chainInfos) {
                    ChainInfo chainInfo2 = (ChainInfo)((Object)JSONUtils.map2pojo((Map)chainInfoMap, ChainInfo.class));
                    for (AssetInfo assetInfo : chainInfo2.getAssetInfoList()) {
                        if (!assetInfo.isUsable()) continue;
                        chainInfoList.add(chainInfo2);
                        continue block2;
                    }
                }
            }
            chainInfoList.forEach(chainInfo -> {
                ChainInfo oldChainInfo = chainManager.getChainInfo(chainInfo.getChainId());
                if (oldChainInfo != null && oldChainInfo.getVerifierList() != null && !oldChainInfo.getVerifierList().isEmpty()) {
                    chainInfo.setVerifierList(oldChainInfo.getVerifierList());
                }
            });
            RegisteredChainMessage registeredChainMessage = new RegisteredChainMessage();
            registeredChainMessage.setChainInfoList(chainInfoList);
            return registeredChainMessage;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

