/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.crosschain.base.message.base.BaseMessage;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.utils.LoggerUtil;
import java.lang.constant.Constable;
import java.util.HashMap;

public class NetWorkCall {
    public static boolean broadcast(int chainId, BaseMessage message, String command, boolean isCross) {
        return NetWorkCall.broadcast(chainId, message, null, command, isCross);
    }

    public static boolean broadcast(int chainId, BaseMessage message, String excludeNodes, String command, boolean isCross) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("excludeNodes", excludeNodes);
            params.put("messageBody", RPCUtil.encode((byte[])message.serialize()));
            params.put("command", command);
            params.put("isCross", isCross);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_broadcast", params, (long)5000L);
            if (!cmdResp.isSuccess()) {
                LoggerUtil.commonLog.error("[nw_broadcast] Packing state failed to send!");
                return false;
            }
            return (Boolean)((HashMap)((HashMap)cmdResp.getResponseData()).get("nw_broadcast")).get("value");
        }
        catch (Exception e) {
            LoggerUtil.commonLog.error(e);
            return false;
        }
    }

    public static boolean sendToNode(int chainId, BaseMessage message, String nodeId, String command) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("nodes", nodeId);
            params.put("messageBody", RPCUtil.encode((byte[])message.serialize()));
            params.put("command", command);
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_sendPeersMsg", params).isSuccess();
        }
        catch (Exception e) {
            LoggerUtil.commonLog.error(e);
            return false;
        }
    }

    public static int getAvailableNodeAmount(int chainId, boolean isCross) throws NulsException {
        HashMap<String, Constable> callParams = new HashMap<String, Constable>(4);
        callParams.put("chainId", Integer.valueOf(chainId));
        callParams.put("isCross", Boolean.valueOf(isCross));
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_getChainConnectAmount", callParams);
            if (!callResp.isSuccess()) {
                throw new NulsException(NulsCrossChainErrorCode.INTERFACE_CALL_FAILED);
            }
            HashMap callResult = (HashMap)((HashMap)callResp.getResponseData()).get("nw_getChainConnectAmount");
            return (Integer)callResult.get("connectAmount");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static void activeCrossNet(int chainId, int maxOut, int maxIn, String seedIps) throws NulsException {
        HashMap<String, Object> callParams = new HashMap<String, Object>(4);
        callParams.put("chainId", chainId);
        callParams.put("maxOut", maxOut);
        callParams.put("maxIn", maxIn);
        callParams.put("seedIps", seedIps);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_activeCross", callParams);
            if (!callResp.isSuccess()) {
                Log.error((String)JSONUtils.obj2json((Object)callResp));
                throw new NulsException(NulsCrossChainErrorCode.INTERFACE_CALL_FAILED);
            }
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

