/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.dto.input.CoinDTO;
import io.nuls.crosschain.base.model.dto.input.CrossTxTransferDTO;
import io.nuls.crosschain.base.service.CrossChainService;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.rpc.call.AccountCall;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.rpc.call.ChainManagerCall;
import io.nuls.crosschain.rpc.call.TransactionCall;
import io.nuls.crosschain.srorage.CommitedOtherCtxService;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.CtxStateService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.SendHeightService;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.LoggerUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.manager.CoinDataManager;
import io.nuls.crosschain.utils.thread.CrossTxHandler;
import io.nuls.crosschain.utils.validator.CrossTxValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class NulsCrossChainServiceImpl
implements CrossChainService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private CrossTxValidator txValidator;
    @Autowired
    private SendHeightService sendHeightService;
    @Autowired
    private ConvertHashService convertHashService;
    @Autowired
    private CtxStateService ctxStateService;
    @Autowired
    private ConvertCtxService convertCtxService;
    @Autowired
    private CtxStatusService ctxStatusService;
    @Autowired
    private CommitedOtherCtxService otherCtxService;
    private Map<Integer, Set<NulsHash>> verifiedCtxMap = new HashMap<Integer, Set<NulsHash>>();

    @Override
    public Result createCrossTx(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        CrossTxTransferDTO crossTxTransferDTO = (CrossTxTransferDTO)JSONUtils.map2pojo(params, CrossTxTransferDTO.class);
        int chainId = crossTxTransferDTO.getChainId();
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        if (!this.chainManager.isCrossNetUseAble()) {
            chain.getLogger().info("Cross chain network networking exception\uff01");
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CROSS_CHAIN_NETWORK_UNAVAILABLE);
        }
        Transaction tx = new Transaction(this.config.getCrossCtxType());
        try {
            tx.setRemark(StringUtils.bytes((String)crossTxTransferDTO.getRemark()));
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            List<CoinFrom> coinFromList = this.coinDataManager.assemblyCoinFrom(chain, crossTxTransferDTO.getListFrom(), false);
            List<CoinTo> coinToList = this.coinDataManager.assemblyCoinTo(crossTxTransferDTO.getListTo(), chain);
            this.coinDataManager.verifyCoin(coinFromList, coinToList, chain);
            int txSize = tx.size();
            CoinData coinData = this.coinDataManager.getCrossCoinData(chain, coinFromList, coinToList, txSize, this.config.isMainNet());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            TransactionSignature transactionSignature = new TransactionSignature();
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            ArrayList<String> signedAddressList = new ArrayList<String>();
            for (CoinDTO coinDTO : crossTxTransferDTO.getListFrom()) {
                if (signedAddressList.contains(coinDTO.getAddress())) continue;
                P2PHKSignature p2PHKSignature = AccountCall.signDigest(coinDTO.getAddress(), coinDTO.getPassword(), tx.getHash().getBytes());
                p2PHKSignatures.add(p2PHKSignature);
                signedAddressList.add(coinDTO.getAddress());
            }
            if (!this.txValidator.coinDataValid(chain, coinData, tx.size())) {
                chain.getLogger().error("Cross chain transactionsCoinDataVerification failed\uff01\n\n");
                return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.COINDATA_VERIFY_FAIL);
            }
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
            if (!TransactionCall.sendTx(chain, RPCUtil.encode((byte[])tx.serialize()))) {
                chain.getLogger().error("Cross chain transaction sending transaction module failed\n\n");
                throw new NulsException(NulsCrossChainErrorCode.INTERFACE_CALL_FAILED);
            }
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("txHash", tx.getHash().toHex());
            return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.SERIALIZE_ERROR);
        }
    }

    @Override
    public Result newApiModuleCrossTx(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        String txStr = (String)params.get("tx");
        try {
            Transaction tx = new Transaction();
            tx.parse(RPCUtil.decode((String)txStr), 0);
            CoinData coinData = tx.getCoinDataInstance();
            if (!this.txValidator.coinDataValid(chain, coinData, tx.size())) {
                chain.getLogger().error("Cross chain transactionsCoinDataVerification failed\uff01\n\n");
                return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.COINDATA_VERIFY_FAIL);
            }
            if (!TransactionCall.sendTx(chain, RPCUtil.encode((byte[])tx.serialize()))) {
                chain.getLogger().error("Cross chain transaction sending transaction module failed\n\n");
                throw new NulsException(NulsCrossChainErrorCode.INTERFACE_CALL_FAILED);
            }
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("txHash", tx.getHash().toHex());
            result.put("success", true);
            return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.SERIALIZE_ERROR);
        }
    }

    @Override
    public Result validCrossTx(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        String txStr = (String)params.get("tx");
        try {
            Transaction transaction = new Transaction();
            transaction.parse(RPCUtil.decode((String)txStr), 0);
            if (!this.txValidator.validateTx(chain, transaction, null)) {
                chain.getLogger().error("Cross chain transaction verification failed,Hash:{}\n", new Object[]{transaction.getHash().toHex()});
                return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            chain.getLogger().info("Cross chain transaction verification successful,Hash:{}\n", new Object[]{transaction.getHash().toHex()});
            return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.SERIALIZE_ERROR);
        }
    }

    @Override
    public boolean commitCrossTx(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        int syncStatus = BlockCall.getBlockStatus(chain);
        try {
            ArrayList<NulsHash> convertHashList = new ArrayList<NulsHash>();
            ArrayList<NulsHash> ctxStatusList = new ArrayList<NulsHash>();
            ArrayList<NulsHash> otherCtxList = new ArrayList<NulsHash>();
            for (Transaction transaction : txs) {
                CtxStatusPO ctxStatusPO;
                NulsHash convertHash;
                NulsHash ctxHash = transaction.getHash();
                if (this.verifiedCtxMap.get(chainId) != null) {
                    this.verifiedCtxMap.get(chainId).remove(ctxHash);
                }
                CoinData coinData = transaction.getCoinDataInstance();
                int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress());
                int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
                if (chainId == toChainId) {
                    convertHash = ctxHash;
                    if (!this.config.isMainNet()) {
                        convertHash = TxUtil.friendConvertToMain(chain, transaction, 10).getHash();
                    }
                    if (!this.convertHashService.save(convertHash, ctxHash, chainId)) {
                        this.rollbackCtx(convertHashList, ctxStatusList, otherCtxList, chainId);
                        return false;
                    }
                    convertHashList.add(convertHash);
                    if (!this.otherCtxService.save(convertHash, transaction, chainId)) {
                        this.rollbackCtx(convertHashList, ctxStatusList, otherCtxList, chainId);
                        return false;
                    }
                    otherCtxList.add(convertHash);
                    continue;
                }
                if (!this.config.isMainNet()) {
                    convertHash = TxUtil.friendConvertToMain(chain, transaction, 10).getHash();
                    if (!this.convertHashService.save(convertHash, ctxHash, chainId)) {
                        this.rollbackCtx(convertHashList, ctxStatusList, otherCtxList, chainId);
                        return false;
                    }
                    convertHashList.add(convertHash);
                }
                if (chainId != fromChainId) {
                    transaction.setTransactionSignature(null);
                    if (!this.otherCtxService.save(ctxHash, transaction, chainId)) {
                        this.rollbackCtx(convertHashList, ctxStatusList, otherCtxList, chainId);
                        return false;
                    }
                    otherCtxList.add(ctxHash);
                }
                if ((ctxStatusPO = this.ctxStatusService.get(ctxHash, chainId)) != null && ctxStatusPO.getStatus() == TxStatusEnum.CONFIRMED.getStatus()) {
                    chain.getLogger().info("The cross chain transfer transaction has been processed before and does not need to be processed again\uff1a{}", new Object[]{ctxHash.toHex()});
                    continue;
                }
                ctxStatusList.add(ctxHash);
                chain.getLogger().debug("Cross chain transaction submission completed, perform Byzantine verification on cross chain transfer transactions\uff1a{}", new Object[]{ctxHash.toHex()});
                transaction.setTransactionSignature(null);
                chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, transaction, syncStatus));
            }
            if (this.config.isMainNet()) {
                ArrayList<String> txStrList = new ArrayList<String>();
                for (Transaction tx : txs) {
                    txStrList.add(RPCUtil.encode((byte[])tx.serialize()));
                }
                String string = RPCUtil.encode((byte[])blockHeader.serialize());
                ChainManagerCall.ctxAssetCirculateCommit(chainId, txStrList, string);
            }
            chain.getLogger().info("height\uff1a{} Cross chain transaction submission completed\n", new Object[]{blockHeader.getHeight()});
            return true;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    @Override
    public boolean rollbackCrossTx(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        try {
            for (Transaction transaction : txs) {
                CtxStatusPO ctxStatusPO;
                CoinData coinData = transaction.getCoinDataInstance();
                int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress());
                int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
                NulsHash ctxHash = transaction.getHash();
                if (chainId == fromChainId) {
                    ctxStatusPO = this.ctxStatusService.get(ctxHash, chainId);
                    if (ctxStatusPO != null && ctxStatusPO.getStatus() == TxStatusEnum.CONFIRMED.getStatus()) {
                        chain.getLogger().info("The cross chain transfer transaction has been processed and does not need to be rolled back\uff1a{}", new Object[]{ctxHash.toHex()});
                        continue;
                    }
                    if (this.ctxStatusService.delete(ctxHash, chainId) && this.convertHashService.delete(ctxHash, chainId)) continue;
                    return false;
                }
                if (chainId == toChainId) {
                    NulsHash convertHash = ctxHash;
                    if (!this.config.isMainNet() && transaction.getType() == this.config.getCrossCtxType()) {
                        convertHash = TxUtil.friendConvertToMain(chain, transaction, 10).getHash();
                    }
                    if (this.convertHashService.delete(convertHash, chainId)) continue;
                    return false;
                }
                ctxStatusPO = this.ctxStatusService.get(ctxHash, chainId);
                if (ctxStatusPO != null && ctxStatusPO.getStatus() == TxStatusEnum.CONFIRMED.getStatus()) {
                    chain.getLogger().info("The cross chain transfer transaction has been processed and does not need to be rolled back\uff1a{}", new Object[]{ctxHash.toHex()});
                    continue;
                }
                if (this.ctxStatusService.delete(ctxHash, chainId) && this.convertHashService.delete(ctxHash, chainId)) continue;
                return false;
            }
            if (this.config.isMainNet()) {
                ArrayList<String> txStrList = new ArrayList<String>();
                for (Transaction tx : txs) {
                    txStrList.add(RPCUtil.encode((byte[])tx.serialize()));
                }
                String string = RPCUtil.encode((byte[])blockHeader.serialize());
                ChainManagerCall.ctxAssetCirculateRollback(chainId, txStrList, string);
            }
            return true;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    @Override
    public Map<String, Object> crossTxBatchValid(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            result.put("txList", txs);
            result.put("errorCode", NulsCrossChainErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        if (!this.verifiedCtxMap.keySet().contains(chainId)) {
            this.verifiedCtxMap.put(chainId, new HashSet());
        }
        Set<NulsHash> verifiedCtxSet = this.verifiedCtxMap.get(chainId);
        ArrayList<Transaction> invalidCtxList = new ArrayList<Transaction>();
        String errorCode = null;
        for (Transaction ctx : txs) {
            NulsHash ctxHash = ctx.getHash();
            try {
                if (verifiedCtxSet.contains(ctxHash)) continue;
                if (!this.txValidator.validateTx(chain, ctx, blockHeader)) {
                    invalidCtxList.add(ctx);
                    continue;
                }
                verifiedCtxSet.add(ctxHash);
            }
            catch (NulsException e) {
                invalidCtxList.add(ctx);
                chain.getLogger().error("Cross-Chain Transaction Verification Failure");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
            catch (IOException io) {
                invalidCtxList.add(ctx);
                chain.getLogger().error("Cross-Chain Transaction Verification Failure");
                chain.getLogger().error((Exception)io);
                errorCode = NulsCrossChainErrorCode.SERIALIZE_ERROR.getCode();
            }
        }
        result.put("txList", invalidCtxList);
        result.put("errorCode", errorCode);
        return result;
    }

    @Override
    public Result getCrossTxState(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("txHash") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        String hashStr = (String)params.get("txHash");
        HashMap<String, Byte> result = new HashMap<String, Byte>(2);
        NulsHash requestHash = NulsHash.fromHex((String)hashStr);
        byte statisticsResult = TxUtil.getCtxState(chain, requestHash);
        result.put("value", statisticsResult);
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
    }

    @Override
    public Result getRegisteredChainInfoList(Map<String, Object> params) {
        HashMap<String, List<ChainInfo>> result = new HashMap<String, List<ChainInfo>>(2);
        LoggerUtil.commonLog.info("------Obtain cross chain asset information---Total length\uff1a" + this.chainManager.getRegisteredCrossChainList().size());
        result.put("list", this.chainManager.getRegisteredCrossChainList());
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
    }

    @Override
    public int getCrossChainTxType() {
        return this.config.getCrossCtxType();
    }

    @Override
    public Result getByzantineCount(Map<String, Object> params) {
        if (params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(2);
        result.put("value", this.config.getByzantineRatio() * CommonUtil.getCurrentPackAddressList(chain).size() / 100);
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
    }

    private void rollbackCtx(List<NulsHash> convertHashList, List<NulsHash> ctxStatusList, List<NulsHash> otherCtxList, int chainId) {
        for (NulsHash convertHash : convertHashList) {
            this.convertHashService.delete(convertHash, chainId);
        }
        for (NulsHash otherHash : otherCtxList) {
            this.otherCtxService.delete(otherHash, chainId);
        }
        for (NulsHash ctxStatusHash : ctxStatusList) {
            CtxStatusPO ctxStatusPO = this.ctxStatusService.get(ctxStatusHash, chainId);
            ctxStatusPO.setStatus(TxStatusEnum.UNCONFIRM.getStatus());
            this.ctxStatusService.save(ctxStatusHash, ctxStatusPO, chainId);
        }
    }
}

