/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainChangeData;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.base.service.RegisteredChainChangeService;
import io.nuls.crosschain.base.utils.enumeration.ChainInfoChangeType;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class RegisteredChainChangeServiceImpl
implements RegisteredChainChangeService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private RegisteredCrossChainService registeredCrossChainService;

    @Override
    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String errorCode = null;
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (this.config.isMainNet()) {
            invalidTxList.addAll(txs);
            chain.getLogger().error("Main network does not package registration chain change transactions");
            result.put("errorCode", NulsCrossChainErrorCode.DATA_ERROR.getCode());
            return result;
        }
        ChainInfo chainInfo = this.chainManager.getChainInfo(this.config.getMainChainId());
        if (chainInfo == null || chainInfo.getVerifierList().isEmpty()) {
            invalidTxList.addAll(txs);
            result.put("errorCode", NulsCrossChainErrorCode.CHAIN_UNREGISTERED_VERIFIER.getCode());
            chain.getLogger().error("The main network verifier information has not been initialized on this chain yet");
            return result;
        }
        int minPassCount = CommonUtil.getByzantineCount(chain, chainInfo.getVerifierList().size());
        for (Transaction verifierChangeTx : txs) {
            try {
                if (!SignatureUtil.validateCtxSignture((Transaction)verifierChangeTx)) {
                    chain.getLogger().info("Main network protocol cross chain transaction signature verification failed\uff01");
                    throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
                }
                if (TxUtil.signByzantineVerify(chain, verifierChangeTx, new ArrayList<String>(chainInfo.getVerifierList()), minPassCount, this.config.getMainChainId())) continue;
                chain.getLogger().info("Signature Byzantine verification failed\uff01");
                throw new NulsException(NulsCrossChainErrorCode.CTX_SIGN_BYZANTINE_FAIL);
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
                invalidTxList.add(verifierChangeTx);
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    @Override
    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        for (Transaction crossChainChangeTx : txs) {
            try {
                RegisteredChainMessage registeredChainMessage;
                RegisteredChainChangeData txData = new RegisteredChainChangeData();
                txData.parse(crossChainChangeTx.getTxData(), 0);
                if (txData.getType() == ChainInfoChangeType.INIT_REGISTER_CHAIN.getType()) {
                    int maxSignatureCount;
                    int mainByzantineRatio;
                    Set<String> verifierSet;
                    if (this.chainManager.getRegisteredCrossChainList() != null && !this.chainManager.getRegisteredCrossChainList().isEmpty()) {
                        ChainInfo chainInfo2 = this.chainManager.getChainInfo(this.config.getMainChainId());
                        verifierSet = chainInfo2.getVerifierList();
                        mainByzantineRatio = chainInfo2.getSignatureByzantineRatio();
                        maxSignatureCount = chainInfo2.getMaxSignatureCount();
                    } else {
                        verifierSet = new HashSet<String>(Arrays.asList(this.config.getVerifiers().split(",")));
                        mainByzantineRatio = this.config.getMainByzantineRatio();
                        maxSignatureCount = this.config.getMaxSignatureCount();
                    }
                    for (ChainInfo chainInfo3 : txData.getChainInfoList()) {
                        if (chainInfo3.getChainId() != this.config.getMainChainId()) continue;
                        chainInfo3.setVerifierList(verifierSet);
                        chainInfo3.setMaxSignatureCount(maxSignatureCount);
                        chainInfo3.setSignatureByzantineRatio(mainByzantineRatio);
                    }
                    registeredChainMessage = new RegisteredChainMessage(txData.getChainInfoList());
                    this.registeredCrossChainService.save(registeredChainMessage);
                    this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
                    this.chainManager.setCrossNetUseAble(true);
                    chain.getLogger().info("Registered cross chain chain information initialization completed");
                    continue;
                }
                registeredChainMessage = this.registeredCrossChainService.get();
                if (registeredChainMessage == null) continue;
                if (txData.getChainInfoList() == null || txData.getChainInfoList().isEmpty()) {
                    registeredChainMessage.getChainInfoList().removeIf(chainInfo -> chainInfo.getChainId() == txData.getRegisterChainId());
                    this.registeredCrossChainService.save(registeredChainMessage);
                    this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
                    chain.getLogger().info("Cross chain deregistration,chainId:{}", new Object[]{txData.getRegisterChainId()});
                    continue;
                }
                for (ChainInfo chainInfo4 : txData.getChainInfoList()) {
                    if (chainInfo4.getChainId() == this.config.getMainChainId()) {
                        ChainInfo oldChainInfo = this.chainManager.getChainInfo(this.config.getMainChainId());
                        chainInfo4.setVerifierList(oldChainInfo.getVerifierList());
                        chainInfo4.setSignatureByzantineRatio(oldChainInfo.getSignatureByzantineRatio());
                        chainInfo4.setMaxSignatureCount(oldChainInfo.getMaxSignatureCount());
                    }
                    registeredChainMessage.addChainInfo(chainInfo4);
                    chain.getLogger().info("Registered cross chain chain information has changed,chainId:{}", new Object[]{chainInfo4.getChainId()});
                }
                this.registeredCrossChainService.save(registeredChainMessage);
                this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        return true;
    }
}

