/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.srorage.imp;

import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.crosschain.srorage.ConvertCtxService;
import java.util.ArrayList;
import java.util.List;

@Component
public class ConvertCtxServiceImpl
implements ConvertCtxService {
    @Override
    public boolean save(NulsHash atxHash, Transaction ctx, int chainID) {
        try {
            if (atxHash == null || ctx == null) {
                return false;
            }
            return RocksDBService.put((String)("convert_ctx" + chainID), (byte[])atxHash.getBytes(), (byte[])ctx.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public Transaction get(NulsHash atxHash, int chainID) {
        try {
            if (atxHash == null) {
                return null;
            }
            byte[] txBytes = RocksDBService.get((String)("convert_ctx" + chainID), (byte[])atxHash.getBytes());
            if (txBytes == null) {
                return null;
            }
            Transaction tx = new Transaction();
            tx.parse(txBytes, 0);
            return tx;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean delete(NulsHash atxHash, int chainID) {
        try {
            if (atxHash == null) {
                return false;
            }
            return RocksDBService.delete((String)("convert_ctx" + chainID), (byte[])atxHash.getBytes());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public List<Transaction> getList(int chainID) {
        try {
            List list = RocksDBService.entryList((String)("convert_ctx" + chainID));
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            for (Entry entry : list) {
                Transaction tx = new Transaction();
                tx.parse((byte[])entry.getValue(), 0);
                txList.add(tx);
            }
            return txList;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }
}

