/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.srorage.imp;

import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.crosschain.model.po.LocalVerifierPO;
import io.nuls.crosschain.srorage.LocalVerifierService;

@Component
public class LocalVerifierServiceImpl
implements LocalVerifierService {
    @Override
    public boolean save(LocalVerifierPO po, int chainID) {
        try {
            if (po == null) {
                return false;
            }
            return RocksDBService.put((String)"local_verifier", (byte[])ByteUtils.intToBytes((int)chainID), (byte[])po.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean backup(int chainID, long blockHeight) {
        LocalVerifierPO localVerifierPO = this.get(chainID);
        try {
            if (localVerifierPO == null) {
                return false;
            }
            return RocksDBService.put((String)("old_local_verifier" + chainID), (byte[])ByteUtils.longToBytes((long)blockHeight), (byte[])localVerifierPO.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return true;
        }
    }

    @Override
    public boolean rollback(int chainID, long blockHeight) {
        byte[] value = RocksDBService.get((String)("old_local_verifier" + chainID), (byte[])ByteUtils.longToBytes((long)blockHeight));
        if (value == null) {
            Log.error((String)"No backup data found");
            return true;
        }
        try {
            RocksDBService.put((String)"local_verifier", (byte[])ByteUtils.intToBytes((int)chainID), (byte[])value);
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public LocalVerifierPO get(int chainID) {
        byte[] value = RocksDBService.get((String)"local_verifier", (byte[])ByteUtils.intToBytes((int)chainID));
        if (value == null) {
            Log.info((String)"The chain verifier has not been initialized");
            return null;
        }
        LocalVerifierPO po = new LocalVerifierPO();
        try {
            po.parse(value, 0);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
        return po;
    }

    @Override
    public boolean delete(int chainID) {
        try {
            return RocksDBService.delete((String)"local_verifier", (byte[])ByteUtils.intToBytes((int)chainID));
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }
}

