/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.srorage.imp;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.LoggerUtil;
import io.nuls.crosschain.utils.manager.ChainManager;

@Component
public class RegisteredCrossChainServiceImpl
implements RegisteredCrossChainService {
    private final byte[] key = "registered_chain".getBytes();
    @Autowired
    private ChainManager chainManager;

    @Override
    public boolean save(RegisteredChainMessage registeredChainMessage) {
        registeredChainMessage.getChainInfoList().stream().filter(d -> d.getChainId() == 9).forEach(chainInfo -> {
            LoggerUtil.commonLog.info("chain id {} Verifier List\uff1a{}", new Object[]{chainInfo.getChainId(), chainInfo.getVerifierList()});
            LoggerUtil.commonLog.info("Current height:{}", new Object[]{this.chainManager.getChainHeaderMap().get(1).getHeight() + 1L});
        });
        try {
            return RocksDBService.put((String)"registered_chain", (byte[])this.key, (byte[])registeredChainMessage.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public RegisteredChainMessage get() {
        try {
            byte[] messageBytes = RocksDBService.get((String)"registered_chain", (byte[])this.key);
            if (messageBytes == null) {
                return null;
            }
            RegisteredChainMessage registeredChainMessage = new RegisteredChainMessage();
            registeredChainMessage.parse(messageBytes, 0);
            return registeredChainMessage;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean canCross(int assetChainId, int assetId) {
        RegisteredChainMessage all = this.get();
        if (all == null || all.getChainInfoList() == null) {
            Log.error((String)"The data is empty");
            return false;
        }
        return all.getChainInfoList().stream().anyMatch(chainInfo -> chainInfo.getAssetInfoList().stream().anyMatch(assetInfo -> assetInfo.getAssetId() == assetId && chainInfo.getChainId() == assetChainId));
    }
}

